/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.compile.tasks;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.render.chunk.DefaultChunkRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.ExtendedBlockEntityType;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildContext;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation.MeshTaskSizeEstimator;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderCache;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderTask;
import net.caffeinemc.mods.sodium.client.render.chunk.data.BuiltSectionInfo;
import net.caffeinemc.mods.sodium.client.render.chunk.data.BuiltSectionMeshParts;
import net.caffeinemc.mods.sodium.client.render.chunk.occlusion.DirectionalVisGraph;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.material.DefaultMaterials;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortBehavior;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortType;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.TranslucentGeometryCollector;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.DynamicData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.PresentTranslucentData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.Sorter;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.TranslucentData;
import net.caffeinemc.mods.sodium.client.services.PlatformLevelRenderHooks;
import net.caffeinemc.mods.sodium.client.util.task.CancellationToken;
import net.caffeinemc.mods.sodium.client.world.LevelSlice;
import net.caffeinemc.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.joml.Vector3dc;

public class ChunkBuilderMeshingTask
extends ChunkBuilderTask<ChunkBuildOutput> {
    private final ChunkRenderContext renderContext;
    private final boolean forceSort;

    public ChunkBuilderMeshingTask(RenderSection render, int buildTime, Vector3dc absoluteCameraPos, ChunkRenderContext renderContext, boolean forceSort) {
        super(render, buildTime, absoluteCameraPos);
        this.renderContext = renderContext;
        this.forceSort = forceSort;
    }

    @Override
    public ChunkBuildOutput execute(ChunkBuildContext buildContext, CancellationToken cancellationToken) {
        BuiltSectionInfo.Builder renderData = new BuiltSectionInfo.Builder();
        DirectionalVisGraph occluder = new DirectionalVisGraph();
        VisGraph oldVisGraph = new VisGraph();
        ChunkBuildBuffers buffers = buildContext.buffers;
        buffers.init(renderData, this.render.getSectionIndex());
        BlockRenderCache cache = buildContext.cache;
        cache.init(this.renderContext);
        LevelSlice slice = cache.getWorldSlice();
        int minX = this.render.getOriginX();
        int minY = this.render.getOriginY();
        int minZ = this.render.getOriginZ();
        int maxX = minX + 16;
        int maxY = minY + 16;
        int maxZ = minZ + 16;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(minX, minY, minZ);
        BlockPos.MutableBlockPos modelOffset = new BlockPos.MutableBlockPos();
        TranslucentGeometryCollector collector = SodiumClientMod.options().performance.getSortBehavior() != SortBehavior.OFF ? new TranslucentGeometryCollector(this.render.getPosition()) : null;
        BlockRenderer blockRenderer = cache.getBlockRenderer();
        blockRenderer.prepare(buffers, slice, collector);
        try {
            for (int y = minY; y < maxY; ++y) {
                if (cancellationToken.isCancelled()) {
                    return null;
                }
                for (int z = minZ; z < maxZ; ++z) {
                    for (int x = minX; x < maxX; ++x) {
                        BlockEntityRenderer renderer;
                        BlockEntity entity;
                        FluidState fluidState;
                        TerrainRenderPass[] blockState = slice.getBlockState(x, y, z);
                        if (blockState.isAir() && !blockState.hasBlockEntity()) continue;
                        blockPos.set(x, y, z);
                        int localX = x & 0xF;
                        int localY = y & 0xF;
                        int localZ = z & 0xF;
                        modelOffset.set(localX, localY, localZ);
                        if (blockState.getRenderShape() == RenderShape.MODEL) {
                            BakedModel model = cache.getBlockModels().getBlockModel((BlockState)blockState);
                            blockRenderer.renderModel(model, (BlockState)blockState, (BlockPos)blockPos, (BlockPos)modelOffset);
                        }
                        if (!(fluidState = blockState.getFluidState()).isEmpty()) {
                            cache.getFluidRenderer().render(slice, (BlockState)blockState, fluidState, (BlockPos)blockPos, (BlockPos)modelOffset, collector, buffers);
                        }
                        if (blockState.hasBlockEntity() && (entity = slice.getBlockEntity((BlockPos)blockPos)) != null && ExtendedBlockEntityType.shouldRender(entity.getType(), (BlockGetter)slice, (BlockPos)blockPos, entity) && (renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(entity)) != null) {
                            renderData.addBlockEntity(entity, !renderer.shouldRenderOffScreen(entity));
                        }
                        if (!blockState.isSolidRender((BlockGetter)slice, (BlockPos)blockPos)) continue;
                        occluder.setOpaque(localX, localY, localZ);
                        oldVisGraph.setOpaque((BlockPos)blockPos);
                    }
                }
            }
        }
        catch (ReportedException ex) {
            throw this.fillCrashInfo(ex.getReport(), slice, (BlockPos)blockPos);
        }
        catch (Exception ex) {
            throw this.fillCrashInfo(CrashReport.forThrowable((Throwable)ex, (String)"Encountered exception while building chunk meshes"), slice, (BlockPos)blockPos);
        }
        PlatformLevelRenderHooks.INSTANCE.runChunkMeshAppenders(this.renderContext.getRenderers(), type -> buffers.get(DefaultMaterials.forRenderLayer(type)).asFallbackVertexConsumer(DefaultMaterials.forRenderLayer(type), collector), slice);
        blockRenderer.release();
        SortType sortType = SortType.NONE;
        if (collector != null) {
            sortType = collector.finishRendering();
        }
        Reference2ReferenceOpenHashMap meshes = new Reference2ReferenceOpenHashMap();
        int visibleSlices = DefaultChunkRenderer.getVisibleFaces((int)this.absoluteCameraPos.x(), (int)this.absoluteCameraPos.y(), (int)this.absoluteCameraPos.z(), this.render.getChunkX(), this.render.getChunkY(), this.render.getChunkZ());
        for (TerrainRenderPass pass2 : DefaultTerrainRenderPasses.ALL) {
            boolean sliceReordering;
            boolean translucentBehavior = collector != null && pass2.isTranslucent();
            boolean forceUnassigned = translucentBehavior && sortType.needsDirectionMixing;
            BuiltSectionMeshParts mesh2 = buffers.createMesh(pass2, visibleSlices, forceUnassigned, sliceReordering = !translucentBehavior || sortType.allowSliceReordering);
            if (mesh2 == null) continue;
            meshes.put(pass2, mesh2);
            renderData.addRenderPass(pass2);
        }
        if (cancellationToken.isCancelled()) {
            meshes.forEach((pass, mesh) -> mesh.getVertexData().free());
            return null;
        }
        renderData.setOcclusionData(occluder.resolve());
        boolean reuseUploadedData = false;
        TranslucentData translucentData = null;
        if (collector != null) {
            TranslucentData oldData = this.render.getTranslucentData();
            if (this.forceSort && !(oldData instanceof DynamicData)) {
                oldData = null;
            }
            translucentData = collector.getTranslucentData(oldData, (BuiltSectionMeshParts)meshes.get(DefaultTerrainRenderPasses.TRANSLUCENT), this);
            reuseUploadedData = !this.forceSort && translucentData == oldData;
        }
        ChunkBuildOutput output = new ChunkBuildOutput(this.render, this.submitTime, translucentData, renderData.build(), (Map<TerrainRenderPass, BuiltSectionMeshParts>)meshes);
        if (collector != null) {
            if (reuseUploadedData) {
                output.markAsReusingUploadedData();
            } else if (translucentData instanceof PresentTranslucentData) {
                PresentTranslucentData present = (PresentTranslucentData)translucentData;
                Sorter sorter = present.getSorter();
                sorter.writeIndexBuffer(this, true);
                output.setSorter(sorter);
            }
        }
        return output;
    }

    private ReportedException fillCrashInfo(CrashReport report, LevelSlice slice, BlockPos pos) {
        CrashReportCategory crashReportSection = report.addCategory("Block being rendered", 1);
        BlockState state = null;
        try {
            state = slice.getBlockState(pos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CrashReportCategory.populateBlockDetails((CrashReportCategory)crashReportSection, (LevelHeightAccessor)slice, (BlockPos)pos, (BlockState)state);
        crashReportSection.setDetail("Chunk section", (Object)this.render);
        if (this.renderContext != null) {
            crashReportSection.setDetail("Render context volume", (Object)this.renderContext.getVolume());
        }
        return new ReportedException(report);
    }

    @Override
    public long estimateTaskSizeWith(MeshTaskSizeEstimator estimator) {
        return estimator.estimateSize(this.render);
    }
}

