/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline;

import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.client.model.color.ColorProvider;
import net.caffeinemc.mods.sodium.client.model.light.LightMode;
import net.caffeinemc.mods.sodium.client.model.light.LightPipeline;
import net.caffeinemc.mods.sodium.client.model.light.LightPipelineProvider;
import net.caffeinemc.mods.sodium.client.model.light.data.QuadLightData;
import net.caffeinemc.mods.sodium.client.model.quad.ModelQuad;
import net.caffeinemc.mods.sodium.client.model.quad.ModelQuadView;
import net.caffeinemc.mods.sodium.client.model.quad.ModelQuadViewMutable;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline.BlockOcclusionCache;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.material.Material;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.TranslucentGeometryCollector;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.builder.ChunkMeshBufferBuilder;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import net.caffeinemc.mods.sodium.client.services.PlatformBlockAccess;
import net.caffeinemc.mods.sodium.client.util.DirectionUtil;
import net.caffeinemc.mods.sodium.client.world.LevelSlice;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;

public class DefaultFluidRenderer {
    public static final float EPSILON = 0.001f;
    private static final float ALIGNED_EQUALS_EPSILON = 0.011f;
    private final BlockPos.MutableBlockPos scratchPos = new BlockPos.MutableBlockPos();
    private final MutableFloat scratchHeight = new MutableFloat(0.0f);
    private final MutableInt scratchSamples = new MutableInt();
    private final BlockOcclusionCache occlusionCache = new BlockOcclusionCache();
    private final ModelQuadViewMutable quad = new ModelQuad();
    private final LightPipelineProvider lighters;
    private final QuadLightData quadLightData = new QuadLightData();
    private final int[] quadColors = new int[4];
    private final float[] brightness = new float[4];
    private final ChunkVertexEncoder.Vertex[] vertices = ChunkVertexEncoder.Vertex.uninitializedQuad();

    public DefaultFluidRenderer(LightPipelineProvider lighters) {
        this.quad.setLightFace(Direction.UP);
        this.lighters = lighters;
    }

    private boolean isFullBlockFluidOccluded(BlockAndTintGetter world, BlockPos pos, Direction dir, BlockState blockState, FluidState fluid) {
        return !this.occlusionCache.shouldDrawFullBlockFluidSide(blockState, (BlockGetter)world, pos, dir, fluid, Shapes.block());
    }

    private boolean isSideExposed(BlockAndTintGetter world, int x, int y, int z, Direction dir, float height) {
        BlockPos.MutableBlockPos pos = this.scratchPos.set(x + dir.getStepX(), y + dir.getStepY(), z + dir.getStepZ());
        BlockState blockState = world.getBlockState((BlockPos)pos);
        if (blockState.canOcclude()) {
            VoxelShape shape = blockState.getOcclusionShape((BlockGetter)world, (BlockPos)pos);
            if (shape.isEmpty()) {
                return true;
            }
            VoxelShape threshold = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)height, (double)1.0);
            return !Shapes.blockOccudes((VoxelShape)threshold, (VoxelShape)shape, (Direction)dir);
        }
        return true;
    }

    public void render(LevelSlice level, BlockState blockState, FluidState fluidState, BlockPos blockPos, BlockPos offset, TranslucentGeometryCollector collector, ChunkModelBuilder meshBuilder, Material material, ColorProvider<FluidState> colorProvider, TextureAtlasSprite[] sprites) {
        float northEastHeight;
        float southEastHeight;
        float southWestHeight;
        float northWestHeight;
        int posX = blockPos.getX();
        int posY = blockPos.getY();
        int posZ = blockPos.getZ();
        Fluid fluid = fluidState.getType();
        boolean cullUp = this.isFullBlockFluidOccluded(level, blockPos, Direction.UP, blockState, fluidState);
        boolean cullDown = this.isFullBlockFluidOccluded(level, blockPos, Direction.DOWN, blockState, fluidState) || !this.isSideExposed(level, posX, posY, posZ, Direction.DOWN, 0.8888889f);
        boolean cullNorth = this.isFullBlockFluidOccluded(level, blockPos, Direction.NORTH, blockState, fluidState);
        boolean cullSouth = this.isFullBlockFluidOccluded(level, blockPos, Direction.SOUTH, blockState, fluidState);
        boolean cullWest = this.isFullBlockFluidOccluded(level, blockPos, Direction.WEST, blockState, fluidState);
        boolean cullEast = this.isFullBlockFluidOccluded(level, blockPos, Direction.EAST, blockState, fluidState);
        if (cullUp && cullDown && cullEast && cullWest && cullNorth && cullSouth) {
            return;
        }
        boolean isWater = fluidState.is(FluidTags.WATER);
        float fluidHeight = this.fluidHeight(level, fluid, blockPos, Direction.UP);
        if (fluidHeight >= 1.0f) {
            northWestHeight = 1.0f;
            southWestHeight = 1.0f;
            southEastHeight = 1.0f;
            northEastHeight = 1.0f;
        } else {
            BlockPos.MutableBlockPos scratchPos = new BlockPos.MutableBlockPos();
            float heightNorth = this.fluidHeight(level, fluid, (BlockPos)scratchPos.setWithOffset((Vec3i)blockPos, Direction.NORTH), Direction.NORTH);
            float heightSouth = this.fluidHeight(level, fluid, (BlockPos)scratchPos.setWithOffset((Vec3i)blockPos, Direction.SOUTH), Direction.SOUTH);
            float heightEast = this.fluidHeight(level, fluid, (BlockPos)scratchPos.setWithOffset((Vec3i)blockPos, Direction.EAST), Direction.EAST);
            float heightWest = this.fluidHeight(level, fluid, (BlockPos)scratchPos.setWithOffset((Vec3i)blockPos, Direction.WEST), Direction.WEST);
            northWestHeight = this.fluidCornerHeight(level, fluid, fluidHeight, heightNorth, heightWest, (BlockPos)scratchPos.set((Vec3i)blockPos).move(Direction.NORTH).move(Direction.WEST));
            southWestHeight = this.fluidCornerHeight(level, fluid, fluidHeight, heightSouth, heightWest, (BlockPos)scratchPos.set((Vec3i)blockPos).move(Direction.SOUTH).move(Direction.WEST));
            southEastHeight = this.fluidCornerHeight(level, fluid, fluidHeight, heightSouth, heightEast, (BlockPos)scratchPos.set((Vec3i)blockPos).move(Direction.SOUTH).move(Direction.EAST));
            northEastHeight = this.fluidCornerHeight(level, fluid, fluidHeight, heightNorth, heightEast, (BlockPos)scratchPos.set((Vec3i)blockPos).move(Direction.NORTH).move(Direction.EAST));
        }
        float yOffset = cullDown ? 0.0f : 0.001f;
        ModelQuadViewMutable quad = this.quad;
        LightMode lightMode = isWater && Minecraft.useAmbientOcclusion() ? LightMode.SMOOTH : LightMode.FLAT;
        LightPipeline lighter = this.lighters.getLighter(lightMode);
        quad.setFlags(0);
        if (!cullUp && this.isSideExposed(level, posX, posY, posZ, Direction.UP, Math.min(Math.min(northWestHeight, southWestHeight), Math.min(southEastHeight, northEastHeight)))) {
            boolean creaseNorthEastSouthWest;
            float v4;
            float u4;
            float v3;
            float u3;
            float v2;
            float u2;
            float v1;
            float u1;
            TextureAtlasSprite sprite;
            northWestHeight -= 0.001f;
            southWestHeight -= 0.001f;
            southEastHeight -= 0.001f;
            northEastHeight -= 0.001f;
            Vec3 velocity = fluidState.getFlow((BlockGetter)level, blockPos);
            if (velocity.x == 0.0 && velocity.z == 0.0) {
                sprite = sprites[0];
                u1 = sprite.getU(0.0f);
                v1 = sprite.getV(0.0f);
                u2 = u1;
                v2 = sprite.getV(1.0f);
                u3 = sprite.getU(1.0f);
                v3 = v2;
                u4 = u3;
                v4 = v1;
            } else {
                sprite = sprites[1];
                float dir = (float)Mth.atan2((double)velocity.z, (double)velocity.x) - 1.5707964f;
                float sin = Mth.sin((float)dir) * 0.25f;
                float cos = Mth.cos((float)dir) * 0.25f;
                u1 = sprite.getU(0.5f + (-cos - sin));
                v1 = sprite.getV(0.5f + -cos + sin);
                u2 = sprite.getU(0.5f + -cos + sin);
                v2 = sprite.getV(0.5f + cos + sin);
                u3 = sprite.getU(0.5f + cos + sin);
                v3 = sprite.getV(0.5f + (cos - sin));
                u4 = sprite.getU(0.5f + (cos - sin));
                v4 = sprite.getV(0.5f + (-cos - sin));
            }
            float uAvg = (u1 + u2 + u3 + u4) / 4.0f;
            float vAvg = (v1 + v2 + v3 + v4) / 4.0f;
            float s3 = sprites[0].uvShrinkRatio();
            u1 = Mth.lerp((float)s3, (float)u1, (float)uAvg);
            u2 = Mth.lerp((float)s3, (float)u2, (float)uAvg);
            u3 = Mth.lerp((float)s3, (float)u3, (float)uAvg);
            u4 = Mth.lerp((float)s3, (float)u4, (float)uAvg);
            v1 = Mth.lerp((float)s3, (float)v1, (float)vAvg);
            v2 = Mth.lerp((float)s3, (float)v2, (float)vAvg);
            v3 = Mth.lerp((float)s3, (float)v3, (float)vAvg);
            v4 = Mth.lerp((float)s3, (float)v4, (float)vAvg);
            quad.setSprite(sprite);
            boolean aligned = DefaultFluidRenderer.isAlignedEquals(northEastHeight, northWestHeight) && DefaultFluidRenderer.isAlignedEquals(northWestHeight, southEastHeight) && DefaultFluidRenderer.isAlignedEquals(southEastHeight, southWestHeight) && DefaultFluidRenderer.isAlignedEquals(southWestHeight, northEastHeight);
            boolean bl = creaseNorthEastSouthWest = aligned || northEastHeight > northWestHeight && northEastHeight > southEastHeight || northEastHeight < northWestHeight && northEastHeight < southEastHeight || southWestHeight > northWestHeight && southWestHeight > southEastHeight || southWestHeight < northWestHeight && southWestHeight < southEastHeight;
            if (creaseNorthEastSouthWest) {
                DefaultFluidRenderer.setVertex(quad, 1, 0.0f, northWestHeight, 0.0f, u1, v1);
                DefaultFluidRenderer.setVertex(quad, 2, 0.0f, southWestHeight, 1.0f, u2, v2);
                DefaultFluidRenderer.setVertex(quad, 3, 1.0f, southEastHeight, 1.0f, u3, v3);
                DefaultFluidRenderer.setVertex(quad, 0, 1.0f, northEastHeight, 0.0f, u4, v4);
            } else {
                DefaultFluidRenderer.setVertex(quad, 0, 0.0f, northWestHeight, 0.0f, u1, v1);
                DefaultFluidRenderer.setVertex(quad, 1, 0.0f, southWestHeight, 1.0f, u2, v2);
                DefaultFluidRenderer.setVertex(quad, 2, 1.0f, southEastHeight, 1.0f, u3, v3);
                DefaultFluidRenderer.setVertex(quad, 3, 1.0f, northEastHeight, 0.0f, u4, v4);
            }
            this.updateQuad(quad, level, blockPos, lighter, Direction.UP, ModelQuadFacing.POS_Y, 1.0f, colorProvider, fluidState);
            this.writeQuad(meshBuilder, collector, material, offset, quad, aligned ? ModelQuadFacing.POS_Y : ModelQuadFacing.UNASSIGNED, false);
            if (fluidState.shouldRenderBackwardUpFace((BlockGetter)level, (BlockPos)this.scratchPos.set(posX, posY + 1, posZ))) {
                this.writeQuad(meshBuilder, collector, material, offset, quad, aligned ? ModelQuadFacing.NEG_Y : ModelQuadFacing.UNASSIGNED, true);
            }
        }
        if (!cullDown) {
            TextureAtlasSprite sprite = sprites[0];
            float minU = sprite.getU0();
            float maxU = sprite.getU1();
            float minV = sprite.getV0();
            float maxV = sprite.getV1();
            quad.setSprite(sprite);
            DefaultFluidRenderer.setVertex(quad, 0, 0.0f, yOffset, 1.0f, minU, maxV);
            DefaultFluidRenderer.setVertex(quad, 1, 0.0f, yOffset, 0.0f, minU, minV);
            DefaultFluidRenderer.setVertex(quad, 2, 1.0f, yOffset, 0.0f, maxU, minV);
            DefaultFluidRenderer.setVertex(quad, 3, 1.0f, yOffset, 1.0f, maxU, maxV);
            this.updateQuad(quad, level, blockPos, lighter, Direction.DOWN, ModelQuadFacing.NEG_Y, 1.0f, colorProvider, fluidState);
            this.writeQuad(meshBuilder, collector, material, offset, quad, ModelQuadFacing.NEG_Y, false);
        }
        quad.setFlags(6);
        block6: for (Direction dir : DirectionUtil.HORIZONTAL_DIRECTIONS) {
            float z2;
            float z1;
            float x2;
            float x1;
            float c2;
            float c1;
            switch (dir) {
                case NORTH: {
                    if (cullNorth) continue block6;
                    c1 = northWestHeight;
                    c2 = northEastHeight;
                    x1 = 0.0f;
                    x2 = 1.0f;
                    z2 = z1 = 0.001f;
                    break;
                }
                case SOUTH: {
                    if (cullSouth) continue block6;
                    c1 = southEastHeight;
                    c2 = southWestHeight;
                    x1 = 1.0f;
                    x2 = 0.0f;
                    z2 = z1 = 0.999f;
                    break;
                }
                case WEST: {
                    if (cullWest) continue block6;
                    c1 = southWestHeight;
                    c2 = northWestHeight;
                    x2 = x1 = 0.001f;
                    z1 = 1.0f;
                    z2 = 0.0f;
                    break;
                }
                case EAST: {
                    if (cullEast) continue block6;
                    c1 = northEastHeight;
                    c2 = southEastHeight;
                    x2 = x1 = 0.999f;
                    z1 = 0.0f;
                    z2 = 1.0f;
                    break;
                }
                default: {
                    continue block6;
                }
            }
            if (!this.isSideExposed(level, posX, posY, posZ, dir, Math.max(c1, c2))) continue;
            int adjX = posX + dir.getStepX();
            int adjY = posY + dir.getStepY();
            int adjZ = posZ + dir.getStepZ();
            TextureAtlasSprite sprite = sprites[1];
            boolean isOverlay = false;
            if (sprites.length > 2 && sprites[2] != null) {
                BlockPos.MutableBlockPos adjPos = this.scratchPos.set(adjX, adjY, adjZ);
                BlockState adjBlock = level.getBlockState((BlockPos)adjPos);
                if (PlatformBlockAccess.getInstance().shouldShowFluidOverlay(adjBlock, level, (BlockPos)adjPos, fluidState)) {
                    sprite = sprites[2];
                    isOverlay = true;
                }
            }
            float u1 = sprite.getU(0.0f);
            float u2 = sprite.getU(0.5f);
            float v1 = sprite.getV((1.0f - c1) * 0.5f);
            float v2 = sprite.getV((1.0f - c2) * 0.5f);
            float v3 = sprite.getV(0.5f);
            quad.setSprite(sprite);
            DefaultFluidRenderer.setVertex(quad, 0, x2, c2, z2, u2, v2);
            DefaultFluidRenderer.setVertex(quad, 1, x2, yOffset, z2, u2, v3);
            DefaultFluidRenderer.setVertex(quad, 2, x1, yOffset, z1, u1, v3);
            DefaultFluidRenderer.setVertex(quad, 3, x1, c1, z1, u1, v1);
            float br = dir.getAxis() == Direction.Axis.Z ? 0.8f : 0.6f;
            ModelQuadFacing facing = ModelQuadFacing.fromDirection(dir);
            this.updateQuad(quad, level, blockPos, lighter, dir, facing, br, colorProvider, fluidState);
            this.writeQuad(meshBuilder, collector, material, offset, quad, facing, false);
            if (isOverlay) continue;
            this.writeQuad(meshBuilder, collector, material, offset, quad, facing.getOpposite(), true);
        }
    }

    private static boolean isAlignedEquals(float a, float b) {
        return Math.abs(a - b) <= 0.011f;
    }

    private void updateQuad(ModelQuadViewMutable quad, LevelSlice level, BlockPos pos, LightPipeline lighter, Direction dir, ModelQuadFacing facing, float brightness, ColorProvider<FluidState> colorProvider, FluidState fluidState) {
        int normal = facing.isAligned() ? facing.getPackedAlignedNormal() : quad.calculateNormal();
        quad.setFaceNormal(normal);
        QuadLightData light = this.quadLightData;
        lighter.calculate(quad, pos, light, null, dir, false, false);
        colorProvider.getColors(level, pos, this.scratchPos, fluidState, quad, this.quadColors);
        for (int i = 0; i < 4; ++i) {
            this.quadColors[i] = ColorARGB.toABGR(this.quadColors[i]);
            this.brightness[i] = light.br[i] * brightness;
        }
    }

    private void writeQuad(ChunkModelBuilder builder, TranslucentGeometryCollector collector, Material material, BlockPos offset, ModelQuadView quad, ModelQuadFacing facing, boolean flip) {
        ChunkVertexEncoder.Vertex[] vertices = this.vertices;
        for (int i = 0; i < 4; ++i) {
            ChunkVertexEncoder.Vertex out = vertices[flip ? 3 - i + 1 & 3 : i];
            out.x = (float)offset.getX() + quad.getX(i);
            out.y = (float)offset.getY() + quad.getY(i);
            out.z = (float)offset.getZ() + quad.getZ(i);
            out.color = this.quadColors[i];
            out.ao = this.brightness[i];
            out.u = quad.getTexU(i);
            out.v = quad.getTexV(i);
            out.light = this.quadLightData.lm[i];
        }
        TextureAtlasSprite sprite = quad.getSprite();
        if (sprite != null) {
            builder.addSprite(sprite);
        }
        if (material.isTranslucent() && collector != null) {
            int normal = facing.isAligned() ? facing.getPackedAlignedNormal() : quad.getFaceNormal();
            if (flip) {
                normal = NormI8.flipPacked(normal);
            }
            collector.appendQuad(normal, vertices, facing);
        }
        ChunkMeshBufferBuilder vertexBuffer = builder.getVertexBuffer(facing);
        vertexBuffer.push(vertices, material);
    }

    private static void setVertex(ModelQuadViewMutable quad, int i, float x, float y, float z, float u, float v) {
        quad.setX(i, x);
        quad.setY(i, y);
        quad.setZ(i, z);
        quad.setTexU(i, u);
        quad.setTexV(i, v);
    }

    private float fluidCornerHeight(BlockAndTintGetter world, Fluid fluid, float fluidHeight, float fluidHeightX, float fluidHeightY, BlockPos blockPos) {
        if (fluidHeightY >= 1.0f || fluidHeightX >= 1.0f) {
            return 1.0f;
        }
        if (fluidHeightY > 0.0f || fluidHeightX > 0.0f) {
            float height = this.fluidHeight(world, fluid, blockPos, Direction.UP);
            if (height >= 1.0f) {
                return 1.0f;
            }
            this.modifyHeight(this.scratchHeight, this.scratchSamples, height);
        }
        this.modifyHeight(this.scratchHeight, this.scratchSamples, fluidHeight);
        this.modifyHeight(this.scratchHeight, this.scratchSamples, fluidHeightY);
        this.modifyHeight(this.scratchHeight, this.scratchSamples, fluidHeightX);
        float result = this.scratchHeight.floatValue() / (float)this.scratchSamples.intValue();
        this.scratchHeight.setValue(0.0f);
        this.scratchSamples.setValue(0);
        return result;
    }

    private void modifyHeight(MutableFloat totalHeight, MutableInt samples, float target) {
        if (target >= 0.8f) {
            totalHeight.add(target * 10.0f);
            samples.add(10);
        } else if (target >= 0.0f) {
            totalHeight.add(target);
            samples.increment();
        }
    }

    private float fluidHeight(BlockAndTintGetter world, Fluid fluid, BlockPos blockPos, Direction direction) {
        BlockState blockState = world.getBlockState(blockPos);
        FluidState fluidState = blockState.getFluidState();
        if (fluid.isSame(fluidState.getType())) {
            FluidState fluidStateUp = world.getFluidState(blockPos.above());
            if (fluid.isSame(fluidStateUp.getType())) {
                return 1.0f;
            }
            return fluidState.getOwnHeight();
        }
        if (!blockState.isSolid()) {
            return 0.0f;
        }
        return -1.0f;
    }
}

