/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.mixin.SpawnTweaks;

import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import org.huahua.pr.Config;
import org.huahua.pr.mixin.SpawnTweaks.SpawnStateAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={NaturalSpawner.class})
public abstract class NaturalSpawnerMixin {
    @Redirect(method={"spawnForChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/NaturalSpawner$SpawnState;canSpawnForCategory(Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/world/level/ChunkPos;)Z"))
    private static boolean allowSpawnsModify(NaturalSpawner.SpawnState instance, MobCategory mobCategory, ChunkPos chunkPos, ServerLevel serverLevel) {
        int MAGIC_NUMBER = 289;
        SpawnStateAccessor accessor = (SpawnStateAccessor)instance;
        int max = mobCategory.getMaxInstancesPerChunk();
        if (mobCategory == MobCategory.MONSTER) {
            MinecraftServer server = serverLevel.getServer();
            if (serverLevel == server.overworld()) {
                max = (Integer)Config.OVERWORLD_MOB_CAP.get();
            } else if (serverLevel == server.getLevel(Level.END)) {
                max = (Integer)Config.END_MOB_CAP.get();
            }
        }
        int i = max * accessor.getSpawnableChunkCount() / MAGIC_NUMBER;
        return accessor.getMobCategoryCounts().getInt((Object)mobCategory) < i && accessor.getLocalMobCapCalculator().canSpawn(mobCategory, chunkPos);
    }
}

