/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.mixin.Optimizations;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NaturalSpawner.class}, remap=false, priority=400)
public abstract class SpawnTweaksMixin {
    @Redirect(method={"isValidSpawnPostitionForType"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/NaturalSpawner;canSpawnMobAt(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/StructureManager;Lnet/minecraft/world/level/chunk/ChunkGenerator;Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/world/level/biome/MobSpawnSettings$SpawnerData;Lnet/minecraft/core/BlockPos;)Z"))
    private static boolean canSpawnMobAtModify(ServerLevel p_220437_, StructureManager p_220438_, ChunkGenerator p_220439_, MobCategory p_220440_, MobSpawnSettings.SpawnerData p_220441_, BlockPos p_220442_) {
        return true;
    }

    @Redirect(method={"getRandomSpawnMobAt"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;getBiome(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/Holder;"))
    private static Holder<Biome> getBiomeModify(ServerLevel instance, BlockPos pos) {
        return instance.getNoiseBiome(pos.getX() >> 2, pos.getY() >> 2, pos.getZ() >> 2);
    }

    @Inject(method={"spawnForChunk"}, at={@At(value="HEAD")}, cancellable=true)
    private static void allowSpawnsModify(ServerLevel serverLevel, LevelChunk p_47031_, NaturalSpawner.SpawnState p_47032_, boolean p_47033_, boolean p_47034_, boolean p_47035_, CallbackInfo ci) {
        if (serverLevel.dimension() == Level.OVERWORLD && serverLevel.getGameTime() % 3L != 0L) {
            ci.cancel();
        }
    }
}

