/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.mixin.Optimizations;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexBuffer;
import java.nio.ByteBuffer;
import org.huahua.pr.C6CClientRendersystemInit;
import org.lwjgl.opengl.GL15C;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={VertexBuffer.class}, priority=500)
public abstract class MixinVertexBuffer {
    @Unique
    private int c6c$vertexBufferSize;
    @Unique
    private int c6c$indexBufferSize;

    @Redirect(method={"uploadVertexBuffer"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;glBufferData(ILjava/nio/ByteBuffer;I)V"))
    private void optimizeVertexDataUploading(int target, ByteBuffer data, int usage) {
        if (!C6CClientRendersystemInit.doFastUpload || usage == 35044 || data.remaining() > this.c6c$vertexBufferSize) {
            this.c6c$vertexBufferSize = data.remaining();
            RenderSystem.glBufferData((int)target, (ByteBuffer)data, (int)usage);
        } else {
            GL15C.glBufferSubData((int)target, (long)0L, (ByteBuffer)data);
        }
    }

    @Redirect(method={"uploadIndexBuffer(Lcom/mojang/blaze3d/vertex/ByteBufferBuilder$Result;)V", "uploadIndexBuffer(Lcom/mojang/blaze3d/vertex/MeshData$DrawState;Ljava/nio/ByteBuffer;)Lcom/mojang/blaze3d/systems/RenderSystem$AutoStorageIndexBuffer;"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;glBufferData(ILjava/nio/ByteBuffer;I)V"))
    private void optimizeIndexDataUploading(int target, ByteBuffer data, int usage) {
        if (!C6CClientRendersystemInit.doFastUpload || usage == 35044 || data.remaining() > this.c6c$indexBufferSize) {
            this.c6c$indexBufferSize = data.remaining();
            RenderSystem.glBufferData((int)target, (ByteBuffer)data, (int)usage);
        } else {
            GL15C.glBufferSubData((int)target, (long)0L, (ByteBuffer)data);
        }
    }
}

