/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.mixin.Maid;

import com.github.tartaricacid.touhoulittlemaid.api.event.InteractMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.event.maid.SlabClickEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.huahua.pr.Content.Compact.Maid.Collection.Events.TamingEventHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityMaid.class}, remap=false)
public abstract class EntityMaidMixin
extends TamableAnimal {
    protected EntityMaidMixin(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
    }

    @Inject(method={"mobInteract"}, at={@At(value="RETURN")}, require=0, cancellable=true)
    void onMobInteract(Player playerIn, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (cir.getReturnValue() != InteractionResult.PASS) {
            return;
        }
        if (playerIn instanceof FakePlayer) {
            return;
        }
        if (this.getOwnerUUID() != null) {
            return;
        }
        ItemStack stack = playerIn.getMainHandItem();
        InteractMaidEvent event = new InteractMaidEvent(playerIn, (EntityMaid)this, stack);
        SlabClickEvent.onInteract((InteractMaidEvent)event);
        if (event.isCanceled()) {
            return;
        }
        cir.setReturnValue((Object)InteractionResult.SUCCESS);
    }

    @Inject(method={"tameMaid"}, at={@At(value="RETURN")}, require=0, cancellable=true)
    void onTameMaid(ItemStack stack, Player player, CallbackInfoReturnable<InteractionResult> cir) {
        if (cir.getReturnValue() == InteractionResult.SUCCESS && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TamingEventHandler.handleMaidTaming(serverPlayer, (LivingEntity)((EntityMaid)this));
        }
    }
}

