/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.mixin;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.MaceItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.huahua.pr.Content.TriggerSpell;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MaceItem.class}, remap=false)
public abstract class MaceItemMixin {
    @Inject(method={"lambda$knockback$0"}, at={@At(value="HEAD")})
    private static void onKnockback(Entity entity, Player player, LivingEntity livingEntity, CallbackInfo ci) {
        livingEntity.hurt(player.damageSources().magic(), (float)player.getAttributeValue(Attributes.ATTACK_DAMAGE));
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TriggerSpell.triggerSpellsOnEntity(serverPlayer, livingEntity, false);
        }
    }

    @Redirect(method={"knockback"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;inflate(D)Lnet/minecraft/world/phys/AABB;"))
    private static AABB moat$inflateWithPlayer(AABB box, double originalRadius, Level level, Player player, Entity center) {
        double newRadius = 3.5;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            newRadius += (double)serverPlayer.fallDistance * 2.0;
        }
        return box.inflate(newRadius);
    }
}

