/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.mixin;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingMultiDamgeSourceMixin {
    @Unique
    Map<DamageSource, Integer> c6c$multiDamageSources = new HashMap<DamageSource, Integer>();
    @Shadow
    protected Stack<DamageContainer> damageContainers;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void c6c$clearMultiDamageSources(CallbackInfo ci) {
        Iterator<Map.Entry<DamageSource, Integer>> iterator = this.c6c$multiDamageSources.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<DamageSource, Integer> entry = iterator.next();
            int ticks = entry.getValue() - 1;
            if (ticks <= 0) {
                iterator.remove();
                continue;
            }
            entry.setValue(ticks);
        }
    }

    @Redirect(method={"hurt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/DamageSource;is(Lnet/minecraft/tags/TagKey;)Z"))
    private boolean c6c$checkMultiDamageSource(DamageSource instance, TagKey<DamageType> damageTypeTagKey) {
        if (damageTypeTagKey != DamageTypeTags.BYPASSES_COOLDOWN || this instanceof Player) {
            return instance.is(damageTypeTagKey);
        }
        if (!this.c6c$multiDamageSources.containsKey(instance)) {
            this.c6c$multiDamageSources.put(instance, this.damageContainers.peek().getPostAttackInvulnerabilityTicks());
            return true;
        }
        return instance.is(damageTypeTagKey);
    }
}

