/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.mixin.Kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.advancements.critereon.ModEventTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.item.TransmutationLunchBagItem;
import com.github.ysbbbbbb.kaleidoscopecookery.util.ItemUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TransmutationLunchBagItem.class}, remap=false)
public class TransmutationLunchBagItemMixin {
    @Inject(method={"finishUsingItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void pr$optimizedConsumeLogic(ItemStack bag, Level level, LivingEntity entity, CallbackInfoReturnable<ItemStack> cir) {
        PotionContents potion;
        if (level.isClientSide || !TransmutationLunchBagItem.hasItems((ItemStack)bag)) {
            return;
        }
        ItemStackHandler items = TransmutationLunchBagItem.getItems((ItemStack)bag);
        int slots = items.getSlots();
        if (slots <= 0) {
            return;
        }
        RandomSource rand = level.random;
        ArrayList<Integer> nonEmpty = new ArrayList<Integer>(slots);
        for (int i = 0; i < slots; ++i) {
            if (items.getStackInSlot(i).isEmpty()) continue;
            nonEmpty.add(i);
        }
        if (nonEmpty.isEmpty()) {
            cir.setReturnValue((Object)bag);
            return;
        }
        Iterator i = nonEmpty.iterator();
        while (i.hasNext()) {
            int slot = (Integer)i.next();
            ItemStack stack = items.getStackInSlot(slot);
            FoodProperties food = (FoodProperties)stack.get(DataComponents.FOOD);
            potion = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
            if (food != null) {
                for (FoodProperties.PossibleEffect eff : food.effects()) {
                    if (!(eff.probability() > 0.0f) || !(rand.nextFloat() < eff.probability())) continue;
                    entity.addEffect(new MobEffectInstance(eff.effect()));
                }
            }
            if (potion == null) continue;
            potion.customEffects().forEach(e -> entity.addEffect(new MobEffectInstance(e)));
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int totalHunger = 0;
            float totalSaturation = 0.0f;
            int foodCount = 0;
            potion = nonEmpty.iterator();
            while (potion.hasNext()) {
                int slot = (Integer)potion.next();
                ItemStack stack = items.getStackInSlot(slot);
                FoodProperties food = (FoodProperties)stack.get(DataComponents.FOOD);
                if (food == null) continue;
                totalHunger += food.nutrition();
                totalSaturation += food.saturation();
                ++foodCount;
            }
            if (foodCount > 0) {
                int hungerGain = totalHunger / foodCount;
                float saturationGain = totalSaturation / (float)foodCount;
                FoodProperties dummy = new FoodProperties(hungerGain, saturationGain, true, 1.6f, Optional.empty(), List.of());
                player.getFoodData().eat(dummy);
            }
        }
        int consumeCount = (int)Math.ceil((double)nonEmpty.size() * 0.6);
        for (int t = 0; t < consumeCount && !nonEmpty.isEmpty(); ++t) {
            Item container;
            for (int i2 = nonEmpty.size() - 1; i2 > 0; --i2) {
                int j = rand.nextInt(i2 + 1);
                Collections.swap(nonEmpty, i2, j);
            }
            float total = 0.0f;
            Iterator j = nonEmpty.iterator();
            while (j.hasNext()) {
                int idx = (Integer)j.next();
                ItemStack s = items.getStackInSlot(idx);
                float fullness = (float)s.getCount() / 64.0f;
                float w = 0.9f - 0.3f * fullness;
                total += w;
            }
            if (total <= 0.0f) break;
            float r = rand.nextFloat() * total;
            float acc = 0.0f;
            int chosenSlot = -1;
            Iterator fullness = nonEmpty.iterator();
            while (fullness.hasNext()) {
                int idx = (Integer)fullness.next();
                ItemStack s = items.getStackInSlot(idx);
                float fullness2 = (float)s.getCount() / 64.0f;
                float w = 0.9f - 0.3f * fullness2;
                if (!(r <= (acc += w))) continue;
                chosenSlot = idx;
                break;
            }
            if (chosenSlot < 0) continue;
            ItemStack taken = items.extractItem(chosenSlot, 1, false);
            if (!taken.isEmpty() && (container = ItemUtils.getContainerItem((ItemStack)taken)) != Items.AIR) {
                ItemUtils.getItemToLivingEntity((LivingEntity)entity, (ItemStack)container.getDefaultInstance());
            }
            if (!items.getStackInSlot(chosenSlot).isEmpty()) continue;
            nonEmpty.remove((Object)chosenSlot);
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            ((ModEventTrigger)ModTrigger.EVENT.get()).trigger((LivingEntity)sp, "use_transmutation_lunch_bag");
        }
        TransmutationLunchBagItem.setItems((ItemStack)bag, (ItemStackHandler)items);
        cir.setReturnValue((Object)bag);
    }

    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")}, cancellable=true)
    private void pr$appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag, CallbackInfo ci) {
        ci.cancel();
        tooltip.add((Component)Component.translatable((String)"tooltip.kaleidoscope_cookery.transmutation_lunch_bag").withStyle(ChatFormatting.LIGHT_PURPLE));
        ItemStackHandler handler = TransmutationLunchBagItem.getItems((ItemStack)stack);
        int nonEmpty = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).isEmpty()) continue;
            ++nonEmpty;
        }
        if (nonEmpty > 0) {
            tooltip.add((Component)Component.translatable((String)"tooltip.c6c.transmutation_lunch_bag", (Object[])new Object[]{(int)Math.ceil((double)nonEmpty * 0.6)}).withStyle(ChatFormatting.LIGHT_PURPLE));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.c6c.transmutation_lunch_bag", (Object[])new Object[]{"N"}).withStyle(ChatFormatting.LIGHT_PURPLE));
        }
    }
}

