/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.mixin.IronSpell;

import io.redspace.ironsspellbooks.api.network.IClientEventEntity;
import io.redspace.ironsspellbooks.entity.mobs.IAnimatedAttacker;
import io.redspace.ironsspellbooks.entity.mobs.wizards.fire_boss.FireBossAttackGoal;
import io.redspace.ironsspellbooks.entity.mobs.wizards.fire_boss.FireBossEntity;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FireBossEntity.class}, remap=false)
public abstract class FireBossEntityMixin
extends Mob
implements IAnimatedAttacker,
IClientEventEntity {
    @Shadow
    FireBossAttackGoal attackGoal;

    protected FireBossEntityMixin(EntityType<? extends Mob> p_21368_, Level p_21369_) {
        super(p_21368_, p_21369_);
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="RETURN")}, require=0)
    public void onFinalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, SpawnGroupData pSpawnData, CallbackInfoReturnable<SpawnGroupData> cir) {
        Mob that = this;
        AttributeInstance attributeInstance = that.getAttribute(Attributes.MOVEMENT_SPEED);
        if (attributeInstance != null) {
            attributeInstance.addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"c6c", (String)"boss_speed"), 0.05, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
        if ((attributeInstance = that.getAttribute(Attributes.ENTITY_INTERACTION_RANGE)) != null) {
            attributeInstance.addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"c6c", (String)"boss_atk_range_nerf"), -0.8, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    @Redirect(method={"customServerAiStep"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/RandomSource;nextBoolean()Z"))
    public boolean lowChaneSummonKnight(RandomSource instance) {
        return instance.nextInt(5) == 0;
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    public void onHurt(DamageSource pSource, float pAmount, CallbackInfoReturnable<Boolean> cir) {
        if (this.level().isClientSide) {
            return;
        }
        float clampedDamage = Math.clamp(pAmount - 30.0f, 0.0f, 100.0f);
        boolean canParry = this.isAggressive() && !this.isImmobile() && pSource.getEntity() != null && pSource.getSourcePosition() != null && pSource.getSourcePosition().subtract(this.position()).normalize().dot(this.getForward()) >= 0.45 && !pSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY);
        float parryChance = clampedDamage * 0.01f - 0.15f;
        if (canParry && this.random.nextFloat() < parryChance) {
            if (!this.attackGoal.isActing()) {
                this.serverTriggerAnimation("offhand_parry");
            }
            this.serverTriggerEvent((byte)6);
            this.playSound((SoundEvent)SoundRegistry.FIRE_DAGGER_PARRY.get());
            cir.setReturnValue((Object)false);
        }
    }
}

