/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.mixin.IronSpell;

import io.redspace.ironsspellbooks.block.BrazierBlock;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.huahua.pr.C6C;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BrazierBlock.class}, remap=false)
public class BrazierBlockMixin
extends Block {
    @Shadow
    @Final
    private boolean soul;

    public BrazierBlockMixin(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
    }

    @Redirect(method={"getToolModifiedState"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;setValue(Lnet/minecraft/world/level/block/state/properties/Property;Ljava/lang/Comparable;)Ljava/lang/Object;"))
    public Object setValueRedirect(BlockState instance, Property property, Comparable comparable) {
        if (this.soul && comparable.equals(Boolean.TRUE)) {
            return instance.setValue(property, (Comparable)Boolean.valueOf(false));
        }
        return instance.setValue(property, comparable);
    }

    @Unique
    private void c6c$AddRuneParticle(Level pLevel, BlockPos pPos, RandomSource pRandom, BlockPos blockPos) {
        if (pRandom.nextInt(8) == 0) {
            pLevel.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)pPos.getX() + 0.5, (double)pPos.getY() + 2.0, (double)pPos.getZ() + 0.5, (double)((float)blockPos.getX() + pRandom.nextFloat()) - 0.5, (double)((float)blockPos.getY() - pRandom.nextFloat() - 1.0f), (double)((float)blockPos.getZ() + pRandom.nextFloat()) - 0.5);
        }
    }

    @Inject(method={"animateTick"}, at={@At(value="TAIL")})
    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom, CallbackInfo ci) {
        if (!this.soul) {
            return;
        }
        if (!((Boolean)pState.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            return;
        }
        this.c6c$AddRuneParticle(pLevel, pPos, pRandom, pPos.relative(Direction.EAST).relative(Direction.NORTH));
        this.c6c$AddRuneParticle(pLevel, pPos, pRandom, pPos.relative(Direction.WEST).relative(Direction.NORTH));
        this.c6c$AddRuneParticle(pLevel, pPos, pRandom, pPos.relative(Direction.EAST).relative(Direction.SOUTH));
        this.c6c$AddRuneParticle(pLevel, pPos, pRandom, pPos.relative(Direction.WEST).relative(Direction.SOUTH));
        this.c6c$AddRuneParticle(pLevel, pPos, pRandom, pPos.relative(Direction.NORTH));
        this.c6c$AddRuneParticle(pLevel, pPos, pRandom, pPos.relative(Direction.SOUTH));
        this.c6c$AddRuneParticle(pLevel, pPos, pRandom, pPos.relative(Direction.EAST));
        this.c6c$AddRuneParticle(pLevel, pPos, pRandom, pPos.relative(Direction.WEST));
    }

    @Inject(method={"entityInside"}, at={@At(value="HEAD")})
    protected void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity, CallbackInfo ci) {
        if (!this.soul) {
            return;
        }
        if (!(pLevel instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)pLevel;
        if (serverLevel.random.nextInt(30) != 0) {
            return;
        }
        if (!((Boolean)pState.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            return;
        }
        if (pEntity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)pEntity;
            if (itemEntity.getItem().is((Holder)ItemRegistry.CHAINED_BOOK)) {
                ItemStack itemStack = itemEntity.getItem().copy();
                itemStack.shrink(1);
                if (itemStack.isEmpty()) {
                    itemEntity.discard();
                } else {
                    itemEntity.setItem(itemStack);
                }
                serverLevel.setBlock(pPos, (BlockState)pState.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)), 3);
                pLevel.playSound(null, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.NEUTRAL, 2.0f, 0.9f + pLevel.random.nextFloat() * 0.2f);
                LootTable mainLoot = pLevel.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)C6C.id("scroll_low")));
                LootParams.Builder lootparams$builder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)itemEntity.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)itemEntity);
                LootParams lootparams = lootparams$builder.create(LootContextParamSets.GIFT);
                mainLoot.getRandomItems(lootparams, serverLevel.random.nextLong(), scroll -> {
                    if (!scroll.isEmpty()) {
                        ItemEntity itemEntity1 = new ItemEntity((Level)serverLevel, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), scroll);
                        itemEntity1.setPickUpDelay(30);
                        itemEntity1.setGlowingTag(true);
                        itemEntity1.setDeltaMovement(serverLevel.random.nextDouble() * 0.5 - 0.25, serverLevel.random.nextDouble() * 0.25 + 0.2, serverLevel.random.nextDouble() * 0.5 - 0.25);
                        serverLevel.addFreshEntity((Entity)itemEntity1);
                    }
                });
            }
            return;
        }
    }
}

