/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.mixin.Hostile;

import dev.xkmc.l2core.capability.player.PlayerCapabilityHolder;
import dev.xkmc.l2hostility.content.capability.player.PlayerDifficulty;
import dev.xkmc.l2hostility.content.logic.PlayerFinder;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={PlayerFinder.class}, remap=false)
public class PlayerFinderMixin {
    @Overwrite
    @Nullable
    public static Player getNearestPlayer(Level level, LivingEntity le) {
        int safeZone = (Integer)LHConfig.SERVER.newPlayerProtectRange.get();
        int sr = safeZone * safeZone;
        int lowLv = 0;
        Player lowPl = null;
        double nearDist = 0.0;
        Player nearPl = null;
        for (Player pl : level.players()) {
            double dist = pl.distanceToSqr((Entity)le);
            if (!pl.isAlive()) continue;
            PlayerDifficulty plOpt = (PlayerDifficulty)((PlayerCapabilityHolder)LHMiscs.PLAYER.type()).getOrCreate((IAttachmentHolder)pl);
            int lv = plOpt.getLevel(pl).getLevel();
            if (dist < (double)sr) {
                if (lowPl != null && lv >= lowLv) continue;
                lowPl = pl;
                lowLv = lv;
                continue;
            }
            if (nearPl != null && !(dist < nearDist)) continue;
            nearPl = pl;
            nearDist = dist;
        }
        if (lowPl != null) {
            return lowPl;
        }
        return nearPl;
    }
}

