/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.mixin.GoblinTrader;

import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import com.mrcrayfish.goblintraders.spawner.GoblinTraderSpawner;
import com.mrcrayfish.goblintraders.spawner.IGoblinData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.saveddata.SavedData;
import org.huahua.pr.Content.NewEndBiomes;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GoblinTraderSpawner.class}, remap=false)
public abstract class GoblinTraderSpawnerMixin
extends SavedData {
    @Shadow
    @Final
    private ServerLevel level;
    @Shadow
    @Final
    private EntityType<? extends AbstractGoblinEntity> type;
    @Shadow
    private int runDelay;
    @Shadow
    @Final
    private IGoblinData data;

    @Shadow
    @Nullable
    protected abstract BlockPos createSpawnPosition(BlockPos var1, int var2);

    @Shadow
    protected abstract int createRandomSpawnableDistance(int var1);

    @Shadow
    @Nullable
    protected abstract BlockPos findGround(BlockPos var1);

    @ModifyArg(method={"register"}, at=@At(value="INVOKE", target="Lcom/mrcrayfish/goblintraders/spawner/GoblinTraderSpawner$SpawnData;<init>(Lnet/minecraft/resources/ResourceKey;Ljava/util/function/Supplier;)V"))
    private static ResourceKey<Level> mod_level(ResourceKey<Level> levelKey) {
        if (levelKey.equals((Object)Level.OVERWORLD)) {
            return Level.END;
        }
        return levelKey;
    }

    @Unique
    @Nullable
    private BlockPos c6C$createSpawnPosition(BlockPos center, int range) {
        for (int i = 0; i < 40; ++i) {
            int posZ;
            int posY;
            int posX = center.getX() + this.createRandomSpawnableDistance(range);
            BlockPos pos = this.findGround(new BlockPos(posX, posY = center.getY() + this.createRandomSpawnableDistance(5), posZ = center.getZ() + this.createRandomSpawnableDistance(range)));
            if (pos == null || pos.closerThan((Vec3i)center, 5.0) || !SpawnPlacements.isSpawnPositionOk(this.type, (LevelReader)this.level, (BlockPos)pos)) continue;
            return pos;
        }
        return null;
    }

    @Inject(method={"spawnGoblin"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_spawnGoblin(CallbackInfoReturnable<Boolean> cir) {
        if (!this.level.dimension().equals(Level.END)) {
            return;
        }
        cir.cancel();
        ServerPlayer player = this.level.getRandomPlayer();
        if (player == null) {
            cir.setReturnValue((Object)false);
            return;
        }
        BlockPos playerPos = player.blockPosition();
        if (playerPos.distToCenterSqr(0.0, 64.0, 0.0) < 1048576.0) {
            cir.setReturnValue((Object)false);
            return;
        }
        BlockPos pos = this.c6C$createSpawnPosition(player.blockPosition(), 48);
        if (pos == null) {
            cir.setReturnValue((Object)false);
            return;
        }
        Holder biome = this.level.getBiome(pos);
        if (!biome.is(Biomes.THE_VOID) && !biome.is(NewEndBiomes.END_DEEP_DARK)) {
            if (biome.is(NewEndBiomes.END_CHERRY_GROVE) && (double)this.level.random.nextFloat() < 0.8) {
                cir.setReturnValue((Object)false);
                return;
            }
            AbstractGoblinEntity goblin = (AbstractGoblinEntity)this.type.spawn(this.level, pos, MobSpawnType.EVENT);
            if (goblin != null) {
                this.runDelay = this.data.getSpawnDelay();
                goblin.setDespawnDelay(this.data.getDespawnDelay());
                goblin.restrictTo(pos, 16);
                MobEffectInstance mobeffectinstance = new MobEffectInstance(MobEffects.GLOWING, -1, 0);
                goblin.addEffect(mobeffectinstance, null);
                this.setDirty();
                cir.setReturnValue((Object)true);
            }
        }
        cir.setReturnValue((Object)false);
    }
}

