/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.mixin.EnderCityTweaks;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.tracen.umapyoi.item.ItemRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net.minecraft.world.level.levelgen.structure.structures.EndCityPieces$EndCityPiece"}, remap=false)
public abstract class EndCityPieceMixin
extends TemplateStructurePiece {
    public EndCityPieceMixin(StructurePieceType p_226886_, int p_226887_, StructureTemplateManager p_226888_, ResourceLocation p_226889_, String p_226890_, StructurePlaceSettings p_226891_, BlockPos p_226892_) {
        super(p_226886_, p_226887_, p_226888_, p_226889_, p_226890_, p_226891_, p_226892_);
    }

    @Unique
    void c6C$addHostile(ServerLevelAccessor level, BlockPos blockPos, RandomSource randomSource, float notSpawnFactor) {
        switch (randomSource.nextInt((int)(4.0f * notSpawnFactor))) {
            case 0: {
                PiglinBrute entity = (PiglinBrute)EntityType.PIGLIN_BRUTE.create((Level)level.getLevel());
                if (!(entity instanceof PiglinBrute)) break;
                PiglinBrute piglinBrute = entity;
                piglinBrute.setImmuneToZombification(true);
                piglinBrute.setItemSlot(EquipmentSlot.MAINHAND, Items.NETHERITE_AXE.getDefaultInstance());
                piglinBrute.setPersistenceRequired();
                piglinBrute.setPos((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
                level.addFreshEntity((Entity)piglinBrute);
                break;
            }
            case 1: {
                Illusioner entity = (Illusioner)EntityType.ILLUSIONER.create((Level)level.getLevel());
                if (!(entity instanceof Illusioner)) break;
                Illusioner illusioner = entity;
                illusioner.setPersistenceRequired();
                illusioner.setPos((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
                level.addFreshEntity((Entity)illusioner);
                break;
            }
            case 2: {
                Vindicator entity = (Vindicator)EntityType.VINDICATOR.create((Level)level.getLevel());
                if (!(entity instanceof Vindicator)) break;
                Vindicator vindicator = entity;
                vindicator.setPersistenceRequired();
                vindicator.setPos((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
                level.addFreshEntity((Entity)vindicator);
                break;
            }
            case 3: {
                Evoker entity = (Evoker)EntityType.EVOKER.create((Level)level.getLevel());
                if (!(entity instanceof Evoker)) break;
                Evoker evoker = entity;
                evoker.setPersistenceRequired();
                evoker.setPos((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
                level.addFreshEntity((Entity)evoker);
            }
        }
    }

    @Inject(method={"handleDataMarker"}, at={@At(value="HEAD")}, cancellable=true)
    void onHandleDataMarker(String structure, BlockPos blockPos, ServerLevelAccessor level, RandomSource randomSource, BoundingBox boundingBox, CallbackInfo ci) {
        if (structure.startsWith("Elytra")) {
            ci.cancel();
            if (boundingBox.isInside((Vec3i)blockPos) && Level.isInSpawnableBounds((BlockPos)blockPos)) {
                Direction rel = this.placeSettings.getRotation().rotate(Direction.SOUTH);
                level.setBlock(blockPos.relative(rel.getOpposite()), Blocks.CRYING_OBSIDIAN.defaultBlockState(), 2);
                ItemFrame itemframe = new ItemFrame((Level)level.getLevel(), blockPos, rel);
                int rand = randomSource.nextInt(60);
                if (rand < 20) {
                    itemframe.setItem(PotionContents.createItemStack((Item)Items.POTION, (Holder)ALObjects.Potions.FLYING), false);
                } else if (rand < 40) {
                    itemframe.setItem(PotionContents.createItemStack((Item)Items.POTION, (Holder)ALObjects.Potions.STRONG_HASTE), false);
                } else if (rand < 42) {
                    itemframe.setItem(InitItems.SMART_SLAB_INIT.asItem().getDefaultInstance(), false);
                } else if (rand < 44) {
                    itemframe.setItem(InitItems.SMART_SLAB_EMPTY.asItem().getDefaultInstance(), false);
                } else if (rand < 45) {
                    itemframe.setItem(Items.DIAMOND_BLOCK.asItem().getDefaultInstance(), false);
                } else if (rand < 46) {
                    itemframe.setItem(ItemRegistry.STAMINA_HIGH_ITEM.asItem().getDefaultInstance(), false);
                } else if (rand < 47) {
                    itemframe.setItem(ItemRegistry.WISDOM_HIGH_ITEM.asItem().getDefaultInstance(), false);
                } else if (rand < 48) {
                    itemframe.setItem(ItemRegistry.SPEED_HIGH_ITEM.asItem().getDefaultInstance(), false);
                } else if (rand < 49) {
                    itemframe.setItem(ItemRegistry.STRENGTH_HIGH_ITEM.asItem().getDefaultInstance(), false);
                } else if (rand < 50) {
                    itemframe.setItem(ItemRegistry.MENTALITY_HIGH_ITEM.asItem().getDefaultInstance(), false);
                } else if (rand < 60) {
                    itemframe.setItem(Items.NETHERITE_BLOCK.getDefaultInstance(), false);
                }
                level.addFreshEntity((Entity)itemframe);
                this.c6C$addHostile(level, blockPos.relative(rel).below(), randomSource, 1.5f);
            }
        } else if (structure.startsWith("Chest")) {
            BlockState chest;
            ci.cancel();
            BlockPos below = blockPos.below();
            if (boundingBox.isInside((Vec3i)below)) {
                RandomizableContainer.setBlockEntityLootTable((BlockGetter)level, (RandomSource)randomSource, (BlockPos)below, (ResourceKey)BuiltInLootTables.END_CITY_TREASURE);
            }
            if ((chest = level.getBlockState(below)).hasProperty((Property)ChestBlock.FACING)) {
                BlockPos front = blockPos.relative((Direction)chest.getValue((Property)ChestBlock.FACING));
                this.c6C$addHostile(level, front, randomSource, 4.0f);
            }
        }
    }
}

