/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.mixin.EndTweaks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TheEndGatewayBlockEntity.class}, remap=false)
public abstract class TheEndGatewayBlockEntityMixin {
    @Shadow
    private BlockPos exitPortal;
    @Unique
    public long c6C$nextRandomizeTime = 0L;

    @Shadow
    private static boolean isChunkEmpty(ServerLevel p_155816_, Vec3 p_155817_) {
        return false;
    }

    @Overwrite
    private static Vec3 findExitPortalXZPosTentative(@NotNull ServerLevel serverLevel, BlockPos blockPos) {
        Vec3 vec3 = new Vec3((double)blockPos.getX(), 0.0, (double)blockPos.getZ()).normalize();
        Vec3 exit = vec3.scale((double)serverLevel.getRandom().nextInt(1600, 300000));
        int j = 16;
        while (!TheEndGatewayBlockEntityMixin.isChunkEmpty(serverLevel, exit) && j-- > 0) {
            exit = exit.add(vec3.scale(-16.0));
        }
        int k = 16;
        while (TheEndGatewayBlockEntityMixin.isChunkEmpty(serverLevel, exit) && k-- > 0) {
            exit = exit.add(vec3.scale(16.0));
        }
        return exit;
    }

    @Inject(method={"getPortalPosition"}, at={@At(value="HEAD")})
    void getPortalPosition(ServerLevel serverLevel, BlockPos p_350271_, CallbackInfoReturnable<Vec3> cir) {
        int coolDown = 6000;
        long gameTime = serverLevel.getGameTime();
        if (this.exitPortal == null) {
            this.c6C$nextRandomizeTime = gameTime + 6000L;
            return;
        }
        if ((long)this.exitPortal.getX() * (long)this.exitPortal.getX() + (long)this.exitPortal.getZ() * (long)this.exitPortal.getZ() > 0x100000L && (gameTime >= this.c6C$nextRandomizeTime || this.c6C$nextRandomizeTime < gameTime - 6000L)) {
            this.exitPortal = null;
            this.c6C$nextRandomizeTime = gameTime + 6000L;
        }
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    protected void onSaveAdditional(CompoundTag p_187527_, HolderLookup.Provider p_324553_, CallbackInfo ci) {
        p_187527_.putLong("NextRandomizeTime", this.c6C$nextRandomizeTime);
    }

    @Inject(method={"loadAdditional"}, at={@At(value="TAIL")})
    protected void onLoadAdditional(CompoundTag p_155840_, HolderLookup.Provider p_323480_, CallbackInfo ci) {
        this.c6C$nextRandomizeTime = p_155840_.contains("NextRandomizeTime") ? p_155840_.getLong("NextRandomizeTime") : 0L;
    }
}

