/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.Content;

import io.redspace.ironsspellbooks.api.events.SpellOnCastEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.network.SyncManaPacket;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@EventBusSubscriber(modid="c6c")
public class TriggerSpell {
    static long lastCastTime = 0L;

    public static List<ItemStack> getPlayerSpells(@NotNull Player player) {
        Optional curiosItemHandler = CuriosApi.getCuriosInventory((LivingEntity)player);
        if (curiosItemHandler.isEmpty()) {
            return List.of();
        }
        ICuriosItemHandler curios = (ICuriosItemHandler)curiosItemHandler.get();
        List slots = curios.findCurios(new String[]{"spell"});
        return slots.stream().map(SlotResult::stack).filter(stack -> !stack.isEmpty()).toList();
    }

    @SubscribeEvent
    public static void OnEntityHurt(LivingDamageEvent.Post event) {
        if (event.getNewDamage() <= 0.0f) {
            return;
        }
        LivingEntity target = event.getEntity();
        if (target instanceof Animal || target instanceof Player) {
            return;
        }
        long time = target.level().getGameTime();
        if (time == lastCastTime) {
            return;
        }
        lastCastTime = time;
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        TriggerSpell.triggerSpellsOnEntity(serverPlayer, target, true);
    }

    public static void triggerSpellsOnEntity(ServerPlayer serverPlayer, LivingEntity targetEntity, boolean costMana) {
        List<ItemStack> spellItems = TriggerSpell.getPlayerSpells((Player)serverPlayer);
        for (ItemStack spellItem : spellItems) {
            if (!(spellItem.getItem() instanceof Scroll)) continue;
            MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
            SpellData spellSlot = ISpellContainer.getOrCreate((ItemStack)spellItem).getSpellAtIndex(0);
            AbstractSpell spell = spellSlot.getSpell();
            int spellLevel = spellSlot.getLevel();
            int manaCost = spell.getManaCost(spellLevel);
            if (magicData.getMana() < (float)manaCost * 0.5f) {
                return;
            }
            magicData.setAdditionalCastData((ICastData)new TargetEntityCastData(targetEntity));
            SpellOnCastEvent castEvent = new SpellOnCastEvent((Player)serverPlayer, spell.getSpellId(), spellLevel, manaCost, spell.getSchoolType(), CastSource.SPELLBOOK);
            NeoForge.EVENT_BUS.post((Event)castEvent);
            if ((!serverPlayer.isCreative() || ((Boolean)ServerConfigs.CREATIVE_MANA_COST.get()).booleanValue()) && costMana) {
                float newMana = Math.max(magicData.getMana() - (float)castEvent.getManaCost(), 0.0f);
                magicData.setMana(newMana);
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncManaPacket(magicData), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            spell.onCast(serverPlayer.level(), spellSlot.getLevel(), (LivingEntity)serverPlayer, CastSource.SCROLL, magicData);
        }
    }
}

