/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.Content;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;
import org.huahua.pr.Content.NewEndBiomes;
import org.jetbrains.annotations.NotNull;

public class NewEndBiomeSource
extends BiomeSource {
    public static final MapCodec<NewEndBiomeSource> CODEC = RecordCodecBuilder.mapCodec(p_255555_ -> p_255555_.group((App)RegistryOps.retrieveElement((ResourceKey)Biomes.THE_END), (App)RegistryOps.retrieveElement((ResourceKey)Biomes.END_HIGHLANDS), (App)RegistryOps.retrieveElement((ResourceKey)Biomes.END_MIDLANDS), (App)RegistryOps.retrieveElement((ResourceKey)Biomes.SMALL_END_ISLANDS), (App)RegistryOps.retrieveElement((ResourceKey)Biomes.END_BARRENS), (App)RegistryOps.retrieveElement(NewEndBiomes.END_BADLANDS), (App)RegistryOps.retrieveElement(NewEndBiomes.END_MANGROVE_SWAMP), (App)RegistryOps.retrieveElement(NewEndBiomes.END_CHERRY_GROVE), (App)RegistryOps.retrieveElement(NewEndBiomes.END_DEEP_DARK), (App)RegistryOps.retrieveElement(NewEndBiomes.END_FLOWER_FOREST), (App)RegistryOps.retrieveElement(NewEndBiomes.END_ICE_SPIKES), (App)RegistryOps.retrieveElement(NewEndBiomes.END_WARPED_FOREST)).apply((Applicative)p_255555_, p_255555_.stable(NewEndBiomeSource::new)));
    private final Holder<Biome> end;
    private final Holder<Biome> highlands;
    private final Holder<Biome> midlands;
    private final Holder<Biome> islands;
    private final Holder<Biome> barrens;
    private final Holder<Biome> end_badlands;
    private final Holder<Biome> end_mangrove_swamp;
    private final Holder<Biome> end_cherryGrove;
    private final Holder<Biome> end_deep_dark;
    private final Holder<Biome> end_flower_forest;
    private final Holder<Biome> end_ice_spikes;
    private final Holder<Biome> end_warped_forest;

    public static NewEndBiomeSource create(HolderGetter<Biome> p_256561_) {
        return new NewEndBiomeSource((Holder<Biome>)p_256561_.getOrThrow(Biomes.THE_END), (Holder<Biome>)p_256561_.getOrThrow(Biomes.END_HIGHLANDS), (Holder<Biome>)p_256561_.getOrThrow(Biomes.END_MIDLANDS), (Holder<Biome>)p_256561_.getOrThrow(Biomes.SMALL_END_ISLANDS), (Holder<Biome>)p_256561_.getOrThrow(Biomes.END_BARRENS), (Holder<Biome>)p_256561_.getOrThrow(NewEndBiomes.END_BADLANDS), (Holder<Biome>)p_256561_.getOrThrow(NewEndBiomes.END_MANGROVE_SWAMP), (Holder<Biome>)p_256561_.getOrThrow(NewEndBiomes.END_CHERRY_GROVE), (Holder<Biome>)p_256561_.getOrThrow(NewEndBiomes.END_DEEP_DARK), (Holder<Biome>)p_256561_.getOrThrow(NewEndBiomes.END_FLOWER_FOREST), (Holder<Biome>)p_256561_.getOrThrow(NewEndBiomes.END_ICE_SPIKES), (Holder<Biome>)p_256561_.getOrThrow(NewEndBiomes.END_WARPED_FOREST));
    }

    public NewEndBiomeSource(Holder<Biome> p_220678_, Holder<Biome> p_220679_, Holder<Biome> p_220680_, Holder<Biome> p_220681_, Holder<Biome> p_220682_, Holder<Biome> end_badlands, Holder<Biome> end_mangrove_swamp, Holder<Biome> cherryGrove, Holder<Biome> end_deep_dark, Holder<Biome> end_flower_forest, Holder<Biome> end_ice_spikes, Holder<Biome> end_warped_forest) {
        this.end = p_220678_;
        this.highlands = p_220679_;
        this.midlands = p_220680_;
        this.islands = p_220681_;
        this.barrens = p_220682_;
        this.end_badlands = end_badlands;
        this.end_mangrove_swamp = end_mangrove_swamp;
        this.end_cherryGrove = cherryGrove;
        this.end_deep_dark = end_deep_dark;
        this.end_flower_forest = end_flower_forest;
        this.end_ice_spikes = end_ice_spikes;
        this.end_warped_forest = end_warped_forest;
    }

    @NotNull
    protected Stream<Holder<Biome>> collectPossibleBiomes() {
        return Stream.of(this.end, this.highlands, this.midlands, this.islands, this.barrens, this.end_badlands, this.end_mangrove_swamp, this.end_cherryGrove, this.end_deep_dark, this.end_flower_forest, this.end_ice_spikes, this.end_warped_forest);
    }

    @NotNull
    protected MapCodec<? extends BiomeSource> codec() {
        return CODEC;
    }

    @NotNull
    public Holder<Biome> getNoiseBiome(int qx, int qy, int qz, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Climate.Sampler sampler) {
        int sz;
        int bx = QuartPos.toBlock((int)qx);
        int by = QuartPos.toBlock((int)qy);
        int bz = QuartPos.toBlock((int)qz);
        int sx = SectionPos.blockToSectionCoord((int)bx);
        if ((long)sx * (long)sx + (long)(sz = SectionPos.blockToSectionCoord((int)bz)) * (long)sz <= 4096L) {
            return this.end;
        }
        int cx = (sx * 2 + 1) * 8;
        int cz = (sz * 2 + 1) * 8;
        DensityFunction.SinglePointContext samplePoint = new DensityFunction.SinglePointContext(cx, by, cz);
        double erosion = sampler.erosion().compute((DensityFunction.FunctionContext)samplePoint);
        if (erosion < -0.0625) {
            return erosion < -0.21875 ? this.islands : this.barrens;
        }
        DensityFunction.SinglePointContext samplePoint2 = new DensityFunction.SinglePointContext(bx, by, bz);
        double humid = sampler.humidity().compute((DensityFunction.FunctionContext)samplePoint2);
        if (humid > 0.3) {
            return erosion < 0.1 ? this.midlands : this.highlands;
        }
        double temp = sampler.temperature().compute((DensityFunction.FunctionContext)samplePoint2);
        if (temp < -0.4) {
            return this.end_ice_spikes;
        }
        if (temp < -0.3) {
            return this.end_cherryGrove;
        }
        if (temp < 0.15) {
            return this.end_flower_forest;
        }
        if (temp < 0.25) {
            return this.end_mangrove_swamp;
        }
        if (temp < 0.35) {
            return this.end_badlands;
        }
        if (temp < 0.7) {
            return this.end_warped_forest;
        }
        return this.end_deep_dark;
    }

    @Nullable
    public Pair<BlockPos, Holder<Biome>> findClosestBiome3d(@NotNull BlockPos pos, int radius, int horizontalStep, int verticalStep, Predicate<Holder<Biome>> biomePredicate, Climate.Sampler sampler, LevelReader level) {
        Set set = this.possibleBiomes().stream().filter(biomePredicate).collect(Collectors.toUnmodifiableSet());
        if (set.isEmpty()) {
            return null;
        }
        int i = Math.floorDiv(radius * 2, horizontalStep);
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.spiralAround((BlockPos)BlockPos.ZERO, (int)i, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int j = pos.getX() + blockpos$mutableblockpos.getX() * horizontalStep;
            int k = pos.getZ() + blockpos$mutableblockpos.getZ() * horizontalStep;
            int l = QuartPos.fromBlock((int)j);
            int i1 = QuartPos.fromBlock((int)k);
            int k1 = QuartPos.fromBlock((int)64);
            Holder<Biome> holder = this.getNoiseBiome(l, k1, i1, sampler);
            if (!set.contains(holder)) continue;
            return Pair.of((Object)new BlockPos(j, 96, k), holder);
        }
        return null;
    }
}

