/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.Content.Items;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import org.jetbrains.annotations.NotNull;

public class RecallPotionItem
extends Item {
    private static final int DRINK_DURATION = 100;

    public RecallPotionItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity entity) {
        Player player;
        ServerPlayer serverplayer;
        DimensionTransition dimensiontransition;
        super.finishUsingItem(itemStack, level, entity);
        itemStack.consume(1, entity);
        if (entity instanceof ServerPlayer && (dimensiontransition = (serverplayer = (ServerPlayer)entity).findRespawnPositionAndUseSpawnBlock(false, DimensionTransition.DO_NOTHING)) != null) {
            ServerLevel targetLevel = dimensiontransition.newLevel();
            if (level.getServer().isLevelEnabled((Level)targetLevel) && (targetLevel.dimension() == level.dimension() || serverplayer.canChangeDimensions(level, (Level)targetLevel))) {
                serverplayer.changeDimension(dimensiontransition);
            }
        }
        if (itemStack.isEmpty()) {
            return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        }
        if (entity instanceof Player && !(player = (Player)entity).hasInfiniteMaterials()) {
            ItemStack itemstack = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            if (!player.getInventory().add(itemstack)) {
                player.drop(itemstack, false);
            }
        }
        return itemStack;
    }

    public int getUseDuration(ItemStack p_41360_, LivingEntity p_345163_) {
        return 100;
    }

    public UseAnim getUseAnimation(ItemStack p_41358_) {
        return UseAnim.DRINK;
    }

    public SoundEvent getDrinkingSound() {
        return SoundEvents.HONEY_DRINK;
    }

    public SoundEvent getEatingSound() {
        return SoundEvents.HONEY_DRINK;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand interactionHand) {
        ItemStack itemstack = player.getItemInHand(interactionHand);
        if (level.dimension() == Level.END) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)interactionHand);
    }
}

