/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.Content.Items;

import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.NeutralWizard;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import io.redspace.ironsspellbooks.registries.PoiTypeRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.huahua.pr.C6C;

public class AbyssalTicketItem
extends Item {
    public AbyssalTicketItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ServerLevel serverlevel;
        ItemStack itemStack;
        block10: {
            block9: {
                if (player instanceof FakePlayer) {
                    return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
                }
                itemStack = player.getItemInHand(hand);
                if (!(level instanceof ServerLevel)) break block9;
                serverlevel = (ServerLevel)level;
                if (player instanceof ServerPlayer) break block10;
            }
            player.swing(hand);
            return InteractionResultHolder.consume((Object)itemStack);
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        player.getCooldowns().addCooldown((Item)C6C.ABYSSAL_TICKET.get(), 120);
        BlockPos playerBlockPos = player.blockPosition();
        PoiManager poimanager = serverlevel.getPoiManager();
        Optional keystone = poimanager.findClosest(poi -> Objects.equals(poi.getKey(), PoiTypeRegistry.CINDEROUS_KEYSTONE_POI.getKey()), playerBlockPos, 22, PoiManager.Occupancy.ANY);
        if (keystone.isPresent() && playerBlockPos.getY() + 2 >= ((BlockPos)keystone.get()).getY()) {
            BlockPos keystonePos = (BlockPos)keystone.get();
            List<Entity> summoned = this.summonEnemies(level, keystonePos, serverPlayer);
            if (summoned == null) {
                serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"item.c6c.abyssal_ticket.failed").withStyle(ChatFormatting.GOLD)));
                this.tollEffects(serverlevel, player.position(), false);
            } else {
                if (!player.getAbilities().instabuild) {
                    Vec3 particlePos = player.getEyePosition().add(player.getForward().scale(0.6)).subtract(0.0, 0.3, 0.0);
                    MagicManager.spawnParticles((Level)serverlevel, (ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, itemStack), (double)particlePos.x, (double)particlePos.y, (double)particlePos.z, (int)9, (double)0.15, (double)0.15, (double)0.15, (double)0.08, (boolean)false);
                    itemStack.shrink(1);
                    player.setItemInHand(hand, itemStack);
                }
                this.tollEffects(serverlevel, player.position(), true);
            }
        } else {
            serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"item.c6c.abyssal_ticket.failed").withStyle(ChatFormatting.GOLD)));
            this.tollEffects(serverlevel, player.position(), false);
        }
        player.swing(hand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    private void tollEffects(ServerLevel serverLevel, Vec3 usePosition, boolean success) {
        serverLevel.playSound(null, usePosition.x, usePosition.y, usePosition.z, (Holder)(success ? SoundRegistry.SOULCALLER_TOLL_SUCCESS : SoundRegistry.SOULCALLER_TOLL_FAILURE), SoundSource.PLAYERS, 6.0f, 1.0f);
        MagicManager.spawnParticles((Level)serverLevel, (ParticleOptions)new BlastwaveParticleOptions(0.2f, 0.6f, 1.0f, 16.0f), (double)usePosition.x, (double)usePosition.y, (double)usePosition.z, (int)0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)false);
    }

    private List<Entity> summonEnemies(Level level, BlockPos center, ServerPlayer player) {
        ArrayList<BlockPos> summonPositions = new ArrayList<BlockPos>();
        for (int i = 0; i < 16 && summonPositions.size() < 3; ++i) {
            BlockPos spawnPos = new BlockPos(Mth.nextInt((RandomSource)level.random, (int)(center.getX() - 8), (int)(center.getX() + 8)), center.getY() + 1, Mth.nextInt((RandomSource)level.random, (int)(center.getZ() - 8), (int)(center.getZ() + 8)));
            if (!level.getBlockState(spawnPos).isAir() || !level.getBlockState(spawnPos.above()).isAir() || !level.getBlockState(spawnPos.below()).isSolid() && !level.getBlockState(spawnPos.below(2)).isSolid() && !level.getBlockState(spawnPos.below(3)).isSolid()) continue;
            summonPositions.add(spawnPos);
        }
        if (summonPositions.size() != 3) {
            return null;
        }
        ArrayList<Entity> spawned = new ArrayList<Entity>();
        List<EntityType> SUMMONABLE_TYPES = List.of((EntityType)EntityRegistry.APOTHECARIST.get(), (EntityType)EntityRegistry.PRIEST.get(), (EntityType)EntityRegistry.PYROMANCER.get(), (EntityType)EntityRegistry.CRYOMANCER.get(), (EntityType)EntityRegistry.NECROMANCER.get(), (EntityType)EntityRegistry.ARCHEVOKER.get());
        PlayerTeam team = AbyssalTicketItem.getOrCreateNoFFTeam((ServerLevel)level);
        for (BlockPos pos : summonPositions) {
            Mob entity = (Mob)SUMMONABLE_TYPES.get(level.random.nextInt(SUMMONABLE_TYPES.size())).create(level);
            if (entity == null) continue;
            entity.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.6, level.random.nextFloat() * 360.0f, 0.0f);
            entity.finalizeSpawn((ServerLevelAccessor)((ServerLevel)level), level.getCurrentDifficultyAt(pos), MobSpawnType.MOB_SUMMONED, null);
            if (entity instanceof NeutralWizard) {
                NeutralWizard neutralWizard = (NeutralWizard)entity;
                neutralWizard.increaseAngerLevel(10, true);
            }
            entity.setTarget((LivingEntity)player);
            entity.setAggressive(true);
            level.addFreshEntity((Entity)entity);
            level.getScoreboard().addPlayerToTeam(entity.getScoreboardName(), team);
            spawned.add((Entity)entity);
        }
        return spawned;
    }

    private static PlayerTeam getOrCreateNoFFTeam(ServerLevel level) {
        String teamName;
        ServerScoreboard sb = level.getScoreboard();
        PlayerTeam team = sb.getPlayerTeam(teamName = "c6c_summoned_enemies");
        if (team == null) {
            team = sb.addPlayerTeam(teamName);
        }
        team.setAllowFriendlyFire(false);
        team.setSeeFriendlyInvisibles(true);
        return team;
    }
}

