/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.Content.Compact.Maid.Collection.Integration;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.fml.ModList;

public class TouhouLittleMaidCompat {
    public static final String TLM_MOD_ID = "touhou_little_maid";
    private static Boolean isTLMLoaded = null;

    public static boolean isTouhouLittleMaidLoaded() {
        if (isTLMLoaded == null) {
            isTLMLoaded = ModList.get().isLoaded(TLM_MOD_ID);
        }
        return isTLMLoaded;
    }

    public static boolean isTouhouLittleMaidEntity(Entity entity) {
        if (!TouhouLittleMaidCompat.isTouhouLittleMaidLoaded()) {
            return false;
        }
        ResourceLocation entityTypeId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        if (entityTypeId.getNamespace().equals(TLM_MOD_ID) && entityTypeId.getPath().equals("maid")) {
            return true;
        }
        String className = entity.getClass().getName();
        return className.contains("touhoulittlemaid.entity.passive.EntityMaid") || className.contains("EntityMaid");
    }

    public static String getMaidType(Entity entity) {
        if (!TouhouLittleMaidCompat.isTouhouLittleMaidEntity(entity)) {
            return "unknown";
        }
        CompoundTag nbt = new CompoundTag();
        entity.saveWithoutId(nbt);
        if (nbt.contains("model_id")) {
            String modelId = nbt.getString("model_id");
            if (modelId.startsWith("touhou_little_maid:")) {
                return modelId.substring(TLM_MOD_ID.length() + 1);
            }
            return modelId;
        }
        return "generic_maid";
    }
}

