/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.Content.Compact.Maid.Collection.Data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class PlayerMaidData
implements INBTSerializable<CompoundTag> {
    static Set<String> specialMaidTypes = new HashSet<String>(List.of("winefox"));
    private int totalTamedCount = 0;
    private Map<String, Integer> tamedMaidTypes = new HashMap<String, Integer>();

    public void addTamedMaid(String maidType, UUID maidUUID) {
        ++this.totalTamedCount;
        for (String specialType : specialMaidTypes) {
            if (!maidType.contains(specialType)) continue;
            this.tamedMaidTypes.put(specialType, this.tamedMaidTypes.getOrDefault(specialType, 0) + 1);
            break;
        }
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("totalTamedCount", this.totalTamedCount);
        CompoundTag specialMaids = new CompoundTag();
        for (Map.Entry<String, Integer> entry : this.tamedMaidTypes.entrySet()) {
            specialMaids.putInt(entry.getKey(), entry.getValue().intValue());
        }
        tag.put("specialMaidTypes", (Tag)specialMaids);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.totalTamedCount = tag.getInt("totalTamedCount");
        CompoundTag specialMaids = tag.getCompound("specialMaidTypes");
        for (String specialType : specialMaidTypes) {
            if (!specialMaids.contains(specialType)) continue;
            this.tamedMaidTypes.put(specialType, specialMaids.getInt(specialType));
        }
    }

    public int getTotalTamedCount() {
        return this.totalTamedCount;
    }

    public int getTamedCountByType(String maidType) {
        return this.tamedMaidTypes.getOrDefault(maidType, 0);
    }
}

