/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.Content.Compact.Maid.Collection.Advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.huahua.pr.Content.Compact.Maid.Collection.Data.PlayerMaidData;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class C6CTriggerSystem {
    public static final DeferredRegister<CriterionTrigger<?>> TRIGGERS = DeferredRegister.create((ResourceKey)Registries.TRIGGER_TYPE, (String)"c6c");
    public static final DeferredHolder<CriterionTrigger<?>, MaidCollectionTrigger> MAID_COLLECTION_TRIGGER = TRIGGERS.register("maid_collection", MaidCollectionTrigger::new);
    public static final DeferredHolder<CriterionTrigger<?>, ComboUnlockTrigger> COMBO_UNLOCK_TRIGGER = TRIGGERS.register("combo_unlock", ComboUnlockTrigger::new);

    public static class MaidCollectionTrigger
    extends SimpleCriterionTrigger<TriggerInstance> {
        public Codec<TriggerInstance> codec() {
            return TriggerInstance.CODEC;
        }

        public void trigger(ServerPlayer player, PlayerMaidData playerData) {
            this.trigger(player, instance -> instance.matches(playerData));
        }

        public static Criterion<TriggerInstance> hasCollectedMaids(int minCount) {
            return new Criterion((CriterionTrigger)MAID_COLLECTION_TRIGGER.get(), (CriterionTriggerInstance)new TriggerInstance(Optional.empty(), minCount, ""));
        }

        public static Criterion<TriggerInstance> hasCollectedMaids(int minCount, String maidType) {
            return new Criterion((CriterionTrigger)MAID_COLLECTION_TRIGGER.get(), (CriterionTriggerInstance)new TriggerInstance(Optional.empty(), minCount, maidType));
        }

        public static class TriggerInstance
        implements SimpleCriterionTrigger.SimpleInstance {
            public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)Codec.INT.optionalFieldOf("min_count", (Object)1).forGetter(t -> t.minCount), (App)Codec.STRING.optionalFieldOf("maid_type", (Object)"any").forGetter(t -> t.requiredMaidIType)).apply((Applicative)instance, TriggerInstance::new));
            private final Optional<ContextAwarePredicate> player;
            private final int minCount;
            private final String requiredMaidIType;

            public TriggerInstance(Optional<ContextAwarePredicate> player, int minCount, String maidType) {
                this.player = player;
                this.minCount = minCount;
                this.requiredMaidIType = maidType;
            }

            public boolean matches(PlayerMaidData playerData) {
                if (this.requiredMaidIType.isEmpty()) {
                    return playerData.getTotalTamedCount() >= this.minCount;
                }
                return playerData.getTamedCountByType(this.requiredMaidIType) >= this.minCount;
            }

            public Optional<ContextAwarePredicate> player() {
                return this.player;
            }
        }
    }

    public static class ComboUnlockTrigger
    extends SimpleCriterionTrigger<TriggerInstance> {
        public Codec<TriggerInstance> codec() {
            return TriggerInstance.CODEC;
        }

        public void trigger(ServerPlayer player, String maidId) {
            this.trigger(player, instance -> instance.matches(maidId));
        }

        public static Criterion<TriggerInstance> hasUnlockedMaid(boolean exactly, String maidId) {
            return new Criterion((CriterionTrigger)COMBO_UNLOCK_TRIGGER.get(), (CriterionTriggerInstance)new TriggerInstance(Optional.empty(), exactly, maidId));
        }

        public static class TriggerInstance
        implements SimpleCriterionTrigger.SimpleInstance {
            public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ContextAwarePredicate.CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)Codec.BOOL.optionalFieldOf("exact_match", (Object)false).forGetter(t -> t.exactMatch), (App)Codec.STRING.fieldOf("maid_id").forGetter(t -> t.requiredMaidIds)).apply((Applicative)instance, TriggerInstance::new));
            private final Optional<ContextAwarePredicate> player;
            private final String requiredMaidIds;
            private final boolean exactMatch;

            public TriggerInstance(Optional<ContextAwarePredicate> player, boolean exactly, String maidId) {
                this.player = player;
                this.requiredMaidIds = maidId;
                this.exactMatch = exactly;
            }

            public boolean matches(String maidId) {
                if (maidId.contains(":")) {
                    maidId = maidId.split(":")[1];
                }
                if (this.exactMatch) {
                    return this.requiredMaidIds.equals(maidId);
                }
                return maidId.contains(this.requiredMaidIds);
            }

            public Optional<ContextAwarePredicate> player() {
                return this.player;
            }
        }
    }
}

