/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.Content.Compact.Maid.Collection.Advancements;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.huahua.pr.Content.Compact.Maid.Collection.Advancements.C6CAdvancements;
import org.huahua.pr.Content.Compact.Maid.Collection.Advancements.C6CTriggerSystem;

public class C6CAdvancement {
    static final ResourceLocation BACKGROUND = ResourceLocation.parse((String)"minecraft:textures/gui/advancements/backgrounds/adventure.png");
    static final String LANG = "advancement.c6c.";
    static final String SECRET_SUFFIX = "\n\u00a77(\u9690\u85cf\u6210\u5c31)";
    private final Advancement.Builder mcBuilder = Advancement.Builder.advancement();
    private C6CAdvancement parent;
    private final Builder createBuilder = new Builder();
    AdvancementHolder datagenResult;
    private String id;
    private String title;
    private String description;

    public C6CAdvancement(String id, UnaryOperator<Builder> b) {
        this.id = id;
        b.apply(this.createBuilder);
        if (this.createBuilder.type == TaskType.SECRET) {
            this.description = this.description + SECRET_SUFFIX;
        }
        C6CAdvancements.ENTRIES.add(this);
    }

    public String id() {
        return this.id;
    }

    private String titleKey() {
        return LANG + this.id;
    }

    private String descriptionKey() {
        return this.titleKey() + ".desc";
    }

    public void save(Consumer<AdvancementHolder> t, HolderLookup.Provider registries) {
        if (this.parent != null) {
            this.mcBuilder.parent(this.parent.datagenResult);
        }
        this.mcBuilder.display(this.createBuilder.icon, (Component)Component.translatable((String)this.titleKey()), (Component)Component.translatable((String)this.descriptionKey()).withStyle(s -> s.withColor(14393875)), (ResourceLocation)(this.id.equals("root") ? BACKGROUND : null), this.createBuilder.type.advancementType, this.createBuilder.type.toast, this.createBuilder.type.announce, this.createBuilder.type.hide);
        this.datagenResult = this.mcBuilder.save(t, "c6c:" + this.id);
    }

    public void provideLang(BiConsumer<String, String> consumer) {
        consumer.accept(this.titleKey(), this.title);
        consumer.accept(this.descriptionKey(), this.description);
    }

    public class Builder {
        private TaskType type = TaskType.NORMAL;
        private ItemStack icon;

        public Builder special(TaskType type) {
            this.type = type;
            return this;
        }

        public Builder after(C6CAdvancement other) {
            C6CAdvancement.this.parent = other;
            return this;
        }

        public Builder icon(ItemLike item) {
            return this.icon(new ItemStack(item));
        }

        public Builder icon(ItemStack stack) {
            this.icon = stack;
            return this;
        }

        public Builder title(String title) {
            C6CAdvancement.this.title = title;
            return this;
        }

        public Builder description(String description) {
            C6CAdvancement.this.description = description;
            return this;
        }

        public final Builder specMaidCollection(boolean exactly, String ... maids) {
            for (String maid : maids) {
                C6CAdvancement.this.mcBuilder.addCriterion(String.valueOf(maid), C6CTriggerSystem.ComboUnlockTrigger.hasUnlockedMaid(exactly, maid));
            }
            return this;
        }

        public Builder maidCountRequire(int count) {
            C6CAdvancement.this.mcBuilder.addCriterion("count_requirement", C6CTriggerSystem.MaidCollectionTrigger.hasCollectedMaids(count));
            return this;
        }

        public Builder maidCountRequire(int count, String maidType) {
            C6CAdvancement.this.mcBuilder.addCriterion("count_requirement", C6CTriggerSystem.MaidCollectionTrigger.hasCollectedMaids(count, maidType));
            return this;
        }

        public Builder awardedForFree() {
            C6CAdvancement.this.mcBuilder.addCriterion("free", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[0]));
            return this;
        }
    }

    public static enum TaskType {
        SILENT(AdvancementType.TASK, false, false, false),
        NORMAL(AdvancementType.TASK, true, false, false),
        NOISY(AdvancementType.TASK, true, true, false),
        PRO(AdvancementType.CHALLENGE, true, true, false),
        EXPERT(AdvancementType.GOAL, true, true, false),
        SECRET(AdvancementType.GOAL, true, true, true);

        private final AdvancementType advancementType;
        private final boolean toast;
        private final boolean announce;
        private final boolean hide;

        private TaskType(AdvancementType advancementType, boolean toast, boolean announce, boolean hide) {
            this.advancementType = advancementType;
            this.toast = toast;
            this.announce = announce;
            this.hide = hide;
        }
    }
}

