/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.Content.Compact.Maid.Behaviours;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableMap;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.crank.HandCrankBlockEntity;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.huahua.pr.Content.Compact.Maid.HandCrankMaidInterface;

public class UseCrankBehaviour
extends MaidCheckRateTask {
    private final float closeEnoughDist = 2.5f;
    private int lastFavorability = -1;

    public UseCrankBehaviour() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)InitEntities.TARGET_POS.get()), (Object)MemoryStatus.VALUE_ABSENT));
        this.setMaxCheckRate(3);
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid maid) {
        if (super.checkExtraStartConditions(worldIn, maid) && maid.canBrainMoving()) {
            BlockPos crankPos = this.findCrank(worldIn, maid);
            if (crankPos != null && maid.isWithinRestriction(crankPos)) {
                BlockEntity blockEntity = worldIn.getBlockEntity(crankPos);
                if (blockEntity instanceof HandCrankBlockEntity) {
                    double d = crankPos.distToCenterSqr((Position)maid.position());
                    Objects.requireNonNull(this);
                    if (d < Math.pow(2.5, 2.0)) {
                        BlockState blockState = worldIn.getBlockState(crankPos);
                        Direction direction = (Direction)blockState.getValue((Property)DirectionalKineticBlock.FACING);
                        maid.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(crankPos));
                        maid.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(crankPos.relative(direction), 0.6f, 1));
                        BlockPosTracker tracker = new BlockPosTracker(crankPos);
                        maid.getBrain().setMemory((MemoryModuleType)InitEntities.TARGET_POS.get(), (Object)tracker);
                        return true;
                    }
                }
                BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)maid, (BlockPos)crankPos, (float)0.6f, (int)1);
                this.setNextCheckTickCount(4);
            } else {
                maid.getBrain().eraseMemory((MemoryModuleType)InitEntities.TARGET_POS.get());
            }
        }
        return false;
    }

    protected void start(ServerLevel level, EntityMaid maid, long gameTime) {
        maid.getBrain().getMemory((MemoryModuleType)InitEntities.TARGET_POS.get()).ifPresent(target -> {
            BlockPos crankPos = target.currentBlockPosition();
            BlockEntity blockEntity = level.getBlockEntity(crankPos);
            if (blockEntity instanceof HandCrankBlockEntity) {
                HandCrankBlockEntity handCrankBlockEntity = (HandCrankBlockEntity)blockEntity;
                this.turn(handCrankBlockEntity, (Level)level, maid);
                maid.swing(InteractionHand.MAIN_HAND);
            }
        });
        maid.getBrain().eraseMemory((MemoryModuleType)InitEntities.TARGET_POS.get());
    }

    @Nullable
    private BlockPos findCrank(ServerLevel world, EntityMaid maid) {
        BlockPos blockPos = maid.blockPosition();
        Block target = (Block)AllBlocks.HAND_CRANK.get();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(blockPos.getX(), blockPos.getY(), blockPos.getZ());
        for (int y = -1; y <= 1; ++y) {
            for (int x = -3; x <= 3; ++x) {
                for (int z = -3; z <= 3; ++z) {
                    mutablePos.set(blockPos.getX() + x, blockPos.getY() + y, blockPos.getZ() + z);
                    BlockState blockState = world.getBlockState((BlockPos)mutablePos);
                    if (!blockState.is(target)) continue;
                    return mutablePos.immutable();
                }
            }
        }
        return null;
    }

    public void turn(HandCrankBlockEntity handCrankBlockEntity, Level level, EntityMaid maid) {
        boolean update = false;
        boolean backwards = false;
        int favorability = maid.getFavorability();
        if (handCrankBlockEntity.getGeneratedSpeed() == 0.0f || handCrankBlockEntity.backwards != backwards || this.lastFavorability != favorability) {
            update = true;
        }
        this.lastFavorability = favorability;
        int ticks = 20;
        int stressProvide = 128 + favorability * 5;
        handCrankBlockEntity.inUse = ticks;
        if (handCrankBlockEntity instanceof HandCrankMaidInterface) {
            HandCrankMaidInterface handCrankMaidInterface = (HandCrankMaidInterface)handCrankBlockEntity;
            handCrankMaidInterface.c6C$setMaidStress(stressProvide);
            handCrankMaidInterface.c6C$setMaidTick(ticks);
        }
        handCrankBlockEntity.backwards = backwards;
        if (update && !level.isClientSide) {
            handCrankBlockEntity.updateGeneratedRotation();
        }
    }
}

