/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.Content.Compact.L2;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBroom;
import dev.xkmc.l2core.capability.player.PlayerCapabilityHolder;
import dev.xkmc.l2hostility.content.capability.player.PlayerDifficulty;
import dev.xkmc.l2hostility.content.logic.LevelEditor;
import dev.xkmc.l2hostility.events.HostilityInitEvent;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.huahua.pr.C6CTags;
import org.huahua.pr.Config;
import org.huahua.pr.mixin.MobAccessor;

@EventBusSubscriber(modid="c6c")
public class L2Events {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntitySpawn(FinalizeSpawnEvent event) {
        Mob le = event.getEntity();
        if (le instanceof Mob) {
            Mob mob = le;
            if (event.getSpawnType() == MobSpawnType.TRIAL_SPAWNER) {
                ((MobAccessor)mob).setSpawnType(MobSpawnType.TRIAL_SPAWNER);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (serverLevel.dimension() != Level.END) {
            return;
        }
        BlockPos pos = player.blockPosition();
        float distance = (float)pos.distToLowCornerSqr(0.0, 0.0, 0.0);
        int end_void_start = (Integer)Config.END_VOID_START.get();
        if (end_void_start >= 960) {
            return;
        }
        if (distance > (float)(end_void_start * end_void_start) && distance < 921600.0f) {
            Entity vehicle = player.getVehicle();
            if (vehicle instanceof EntityBroom) {
                EntityBroom broom = (EntityBroom)vehicle;
                List passengers = broom.getPassengers();
                for (Entity passenger : passengers) {
                    if (passenger instanceof Player) {
                        Player p = (Player)passenger;
                        p.stopRiding();
                    }
                    if (!(passenger instanceof LivingEntity)) continue;
                    LivingEntity le = (LivingEntity)passenger;
                    MobEffectInstance effectInstance = new MobEffectInstance(MobEffects.SLOW_FALLING, 200, 0, false, false, true);
                    le.addEffect(effectInstance);
                    if (le instanceof Player) continue;
                    le.setPos(4.0, 200.0, 0.0);
                }
                broom.setPos(8.0, 200.0, 0.0);
            }
            DimensionTransition dimensiontransition = new DimensionTransition(serverLevel, new Vec3(0.0, 200.0, 0.0), player.getDeltaMovement(), player.getYRot(), player.getXRot(), DimensionTransition.PLAY_PORTAL_SOUND);
            player.changeDimension(dimensiontransition);
        }
    }

    static boolean shouldApplyHostile(LivingEntity entity) {
        Mob mob;
        if (entity instanceof Mob && (mob = (Mob)entity).getSpawnType() == MobSpawnType.TRIAL_SPAWNER) {
            return true;
        }
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity.getType().is(C6CTags.APPLY_L2_HOSTILITY)) {
                return true;
            }
            if (serverLevel.dimension() == Level.END) {
                return entity.blockPosition().distToCenterSqr(0.0, 0.0, 0.0) >= 1048576.0;
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onHostileInit(HostilityInitEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        if (!L2Events.shouldApplyHostile(entity)) {
            event.setCanceled(true);
        }
    }

    public static void readjustPlayerDifficulty(Player player) {
        PlayerDifficulty playerDiff = (PlayerDifficulty)((PlayerCapabilityHolder)LHMiscs.PLAYER.type()).getOrCreate((IAttachmentHolder)player);
        LevelEditor levelEditor = playerDiff.getLevelEditor(player);
        int targetLevel = Math.max(switch (playerDiff.maxRankKilled) {
            case 0 -> 10;
            case 1 -> 15;
            case 2 -> 25;
            case 3 -> 45;
            case 4 -> 75;
            case 5 -> 115;
            default -> 115 + (playerDiff.maxRankKilled - 5) * 50;
        }, levelEditor.getBase() / 2);
        levelEditor.setBase(Math.max(1, targetLevel));
    }

    public static void resetPlayerDifficulty(Player player) {
        PlayerDifficulty playerDiff = (PlayerDifficulty)((PlayerCapabilityHolder)LHMiscs.PLAYER.type()).getOrCreate((IAttachmentHolder)player);
        LevelEditor levelEditor = playerDiff.getLevelEditor(player);
        levelEditor.setBase(1);
    }
}

