/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.Content.Compact.Create;

import com.simibubi.create.api.behaviour.spouting.BlockSpoutingBehaviour;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.huahua.pr.Content.Compact.Create.RecipeTypes;
import org.huahua.pr.Content.Compact.Create.WateringRecipe;

public enum WateringBehaviour implements BlockSpoutingBehaviour
{
    INSTANCE;


    public static boolean getRecipe(Level level, BlockState state) {
        for (RecipeHolder recipe : level.getRecipeManager().getAllRecipesFor(RecipeTypes.WATERING.getType())) {
            WateringRecipe wateringRecipe = (WateringRecipe)recipe.value();
            if (!wateringRecipe.testTargetBlock(state)) continue;
            return true;
        }
        return false;
    }

    private static WateringRecipe getRecipe(Level level, FluidStack availableFluid, BlockState state) {
        for (RecipeHolder recipe : level.getRecipeManager().getAllRecipesFor(RecipeTypes.WATERING.getType())) {
            SizedFluidIngredient requiredFluid;
            WateringRecipe wateringRecipe = (WateringRecipe)recipe.value();
            if (!wateringRecipe.testTargetBlock(state) || !(requiredFluid = wateringRecipe.getRequiredFluid()).test(availableFluid)) continue;
            return wateringRecipe;
        }
        return null;
    }

    public int fillBlock(Level level, BlockPos pos, SpoutBlockEntity spout, FluidStack availableFluid, boolean simulate) {
        Fluid fluid = availableFluid.getFluid();
        if (fluid == null) {
            return 0;
        }
        BlockState state = level.getBlockState(pos);
        WateringRecipe recipe = WateringBehaviour.getRecipe(level, availableFluid, state);
        if (recipe == null) {
            return 0;
        }
        SizedFluidIngredient requiredFluid = recipe.getRequiredFluid();
        if (!requiredFluid.test(availableFluid)) {
            return 0;
        }
        if (!simulate) {
            List results = recipe.rollResults(level.getRandom());
            if (results.isEmpty()) {
                return 0;
            }
            ItemStack result = (ItemStack)results.get(0);
            Item bottleItem = result.getItem();
            if (bottleItem instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)bottleItem;
                Block targetBlock = blockItem.getBlock();
                level.setBlockAndUpdate(pos, targetBlock.defaultBlockState());
            }
        }
        return requiredFluid.amount();
    }
}

