/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.Content.Client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.huahua.pr.Content.GearRarity;
import org.huahua.pr.Content.ModAttachments;
import org.joml.Matrix4f;

public class ItemBorders {
    public static void renderBorder(PoseStack poseStack, Slot slot) {
        ItemBorders.render(poseStack, slot.getItem(), slot.x, slot.y);
    }

    public static void drawGradientRect(Matrix4f mat, int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        ItemBorders.drawGradientRect(mat, (VertexConsumer)bufferBuilder, left, top, right, bottom, zLevel, startColor, endColor);
        MeshData built = bufferBuilder.build();
        if (built != null) {
            BufferUploader.drawWithShader((MeshData)built);
        }
        RenderSystem.disableBlend();
    }

    public static void drawGradientRect(Matrix4f mat, VertexConsumer vertexConsumer, int left, int top, int right, int bottom, int zLevel, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        vertexConsumer.addVertex(mat, (float)right, (float)top, (float)zLevel).setColor(startRed, startGreen, startBlue, startAlpha);
        vertexConsumer.addVertex(mat, (float)left, (float)top, (float)zLevel).setColor(startRed, startGreen, startBlue, startAlpha);
        vertexConsumer.addVertex(mat, (float)left, (float)bottom, (float)zLevel).setColor(endRed, endGreen, endBlue, endAlpha);
        vertexConsumer.addVertex(mat, (float)right, (float)bottom, (float)zLevel).setColor(endRed, endGreen, endBlue, endAlpha);
    }

    private static void render(PoseStack poseStack, ItemStack stack, int x, int y) {
        if (stack.isEmpty()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null) {
            return;
        }
        if (!stack.has(ModAttachments.GEAR_RARITY)) {
            return;
        }
        GearRarity gearRarity = (GearRarity)((Object)stack.get(ModAttachments.GEAR_RARITY));
        if (gearRarity == null) {
            return;
        }
        int color = gearRarity.toTextColor().getValue() & 0xFFFFFF;
        int y_start = 4 + 2 * (GearRarity.values().length - 1 - gearRarity.ordinal());
        int trans = gearRarity.ordinal() * 21 + 21;
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 100.0f);
        int startColor = color | trans << 24;
        ItemBorders.drawGradientRect(poseStack.last().pose(), -1, x, y + y_start, x + 16, y + 16, color, startColor);
        ItemBorders.drawGradientRect(poseStack.last().pose(), -1, x, y + 15, x + 16, y + 16, color | 0xFF000000, color | 0xFF000000);
        poseStack.popPose();
    }
}

