/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.Content.Affixs.LootFunctions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.huahua.pr.Content.Affixs.AffixPools;
import org.huahua.pr.Content.Affixs.LootFunctions.LootFunctionRegistry;

public class RandomizeEquipmentsFunction
extends LootItemConditionalFunction {
    final NumberProvider qualityRange;
    public static final MapCodec<RandomizeEquipmentsFunction> CODEC = RecordCodecBuilder.mapCodec(builder -> RandomizeEquipmentsFunction.commonFields((RecordCodecBuilder.Instance)builder).and((App)NumberProviders.CODEC.fieldOf("quality").forGetter(f -> f.qualityRange)).apply((Applicative)builder, RandomizeEquipmentsFunction::new));

    protected RandomizeEquipmentsFunction(List<LootItemCondition> p_298706_, NumberProvider qualityRange) {
        super(p_298706_);
        this.qualityRange = qualityRange;
    }

    public LootItemFunctionType getType() {
        return LootFunctionRegistry.RANDOMIZE_EQUIPMENTS_FUNCTION.get();
    }

    protected ItemStack run(ItemStack itemStack, LootContext lootContext) {
        int extraAffix;
        float quality = this.qualityRange.getFloat(lootContext);
        int n = extraAffix = quality > 0.75f ? 1 : 0;
        if (itemStack.is(ItemTags.HEAD_ARMOR)) {
            AffixPools.applyRandomAffixes(itemStack, lootContext, quality, 1, 1 + extraAffix);
        }
        if (itemStack.is(ItemTags.CHEST_ARMOR)) {
            AffixPools.applyRandomAffixes(itemStack, lootContext, quality, 2, 2 + extraAffix);
        }
        if (itemStack.is(ItemTags.LEG_ARMOR)) {
            AffixPools.applyRandomAffixes(itemStack, lootContext, quality, 2, 2 + extraAffix);
        }
        if (itemStack.is(ItemTags.FOOT_ARMOR)) {
            AffixPools.applyRandomAffixes(itemStack, lootContext, quality, 1, 1 + extraAffix);
        }
        return itemStack;
    }
}

