/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.Content.Affixs;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.storage.loot.LootContext;
import org.huahua.pr.Content.GearRarity;
import org.huahua.pr.Content.ModAttachments;

public final class AffixPools {
    public static final List<AffixSpec> PRIMARY = List.of(new AffixSpec("minecraft:generic.attack_damage", "Primary_AD", AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 1.5f), new AffixSpec("irons_spellbooks:spell_power", "Primary_SpellPower", AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 0.75f), new AffixSpec("minecraft:generic.max_health", "Primary_MaxHealth", AttributeModifier.Operation.ADD_MULTIPLIED_BASE, 1.5f), new AffixSpec("irons_spellbooks:spell_resist", "Primary_SpellResist", AttributeModifier.Operation.ADD_VALUE, 0.1f), new AffixSpec("minecraft:player.mining_efficiency", "Primary_MiningEff", AttributeModifier.Operation.ADD_VALUE, 5.0f));
    public static final List<AffixSpec> SECONDARY = List.of(new AffixSpec("apothic_attributes:armor_pierce", "Sec_ArmorPierce", AttributeModifier.Operation.ADD_VALUE, 3.0f), new AffixSpec("apothic_attributes:armor_shred", "Sec_ArmorShred", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 0.15f), new AffixSpec("apothic_attributes:healing_received", "Sec_HealingRecv", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 0.5f), new AffixSpec("apothic_attributes:life_steal", "Sec_LifeSteal", AttributeModifier.Operation.ADD_VALUE, 0.1f), new AffixSpec("apothic_attributes:overheal", "Sec_Overheal", AttributeModifier.Operation.ADD_VALUE, 0.1f), new AffixSpec("irons_spellbooks:max_mana", "Sec_MaxMana", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 0.2f), new AffixSpec("irons_spellbooks:mana_regen", "Sec_ManaRegen", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 0.2f), new AffixSpec("irons_spellbooks:fire_spell_power", "Sec_FirePower", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 1.0f), new AffixSpec("irons_spellbooks:ice_spell_power", "Sec_IcePower", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 1.0f), new AffixSpec("irons_spellbooks:lightning_spell_power", "Sec_LightningPower", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 1.0f), new AffixSpec("irons_spellbooks:holy_spell_power", "Sec_HolyPower", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 1.0f), new AffixSpec("irons_spellbooks:ender_spell_power", "Sec_EnderPower", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 1.0f), new AffixSpec("irons_spellbooks:blood_spell_power", "Sec_BloodPower", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 1.0f), new AffixSpec("irons_spellbooks:evocation_spell_power", "Sec_EvocationPower", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 1.0f), new AffixSpec("irons_spellbooks:nature_spell_power", "Sec_NaturePower", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 1.0f), new AffixSpec("irons_spellbooks:eldritch_spell_power", "Sec_EldritchPower", AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL, 1.0f));

    private AffixPools() {
    }

    public static void applyRandomAffixes(ItemStack stack, LootContext ctx, float quality, int minSecondaries, int maxSecondaries) {
        if (quality <= 0.01f) {
            return;
        }
        RandomSource rand = ctx.getRandom();
        HolderGetter.Provider resolver = ctx.getResolver();
        HolderGetter attrLookup = resolver.lookupOrThrow(Registries.ATTRIBUTE);
        ItemAttributeModifiers mods = new ItemAttributeModifiers(List.of(), true);
        AffixSpec primary = PRIMARY.get(rand.nextInt(PRIMARY.size()));
        mods = AffixPools.addOne(mods, primary, quality, (HolderGetter<Attribute>)attrLookup, stack, rand);
        int secCount = rand.nextInt(maxSecondaries - minSecondaries + 1) + minSecondaries;
        secCount = Math.min(secCount, SECONDARY.size());
        for (int i = 0; i < secCount; ++i) {
            AffixSpec spec = SECONDARY.get(rand.nextInt(SECONDARY.size()));
            mods = AffixPools.addOne(mods, spec, quality, (HolderGetter<Attribute>)attrLookup, stack, rand);
        }
        stack.set(ModAttachments.AFFIX_MODIFIERS, (Object)mods);
        AffixPools.setQuality(stack, quality);
    }

    private static ItemAttributeModifiers addOne(ItemAttributeModifiers mods, AffixSpec spec, float quality, HolderGetter<Attribute> attrLookup, ItemStack stack, RandomSource randomSource) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ATTRIBUTE, (ResourceLocation)spec.attributeId);
        Optional attr = attrLookup.get(key);
        if (attr.isEmpty()) {
            return mods;
        }
        double amount = (double)(spec.max * quality) * (0.3 + 0.7 * (double)randomSource.nextFloat());
        double rounded = (double)Math.round(amount * 100000.0) / 100000.0;
        ResourceLocation modifierId = ResourceLocation.fromNamespaceAndPath((String)"c6c", (String)UUID.randomUUID().toString());
        AttributeModifier modifier = new AttributeModifier(modifierId, rounded, spec.operation);
        return mods.withModifierAdded((Holder)attr.get(), modifier, EquipmentSlotGroup.ARMOR);
    }

    static void setQuality(ItemStack itemStack, float quality) {
        GearRarity gearRarity = quality < 0.1f ? GearRarity.COMMON : (quality < 0.2f ? GearRarity.UNCOMMON : (quality < 0.3f ? GearRarity.RARE : (quality < 0.6f ? GearRarity.EPIC : (quality < 1.0f ? GearRarity.LEGENDARY : GearRarity.MYTHIC))));
        itemStack.set((DataComponentType)ModAttachments.GEAR_RARITY.get(), (Object)gearRarity);
        itemStack.set(DataComponents.RARITY, (Object)(switch (gearRarity) {
            case GearRarity.COMMON -> Rarity.COMMON;
            case GearRarity.UNCOMMON -> Rarity.UNCOMMON;
            case GearRarity.RARE -> Rarity.RARE;
            case GearRarity.EPIC -> Rarity.EPIC;
            case GearRarity.LEGENDARY -> Rarity.EPIC;
            case GearRarity.MYTHIC -> Rarity.EPIC;
            default -> Rarity.COMMON;
        }));
    }

    public static final class AffixSpec {
        public final ResourceLocation attributeId;
        public final String name;
        public final AttributeModifier.Operation operation;
        public final float max;

        public AffixSpec(String attributeId, String name, AttributeModifier.Operation operation, float max) {
            this.attributeId = ResourceLocation.tryParse((String)attributeId);
            this.name = name.toLowerCase();
            this.operation = operation;
            this.max = max;
        }
    }
}

