/*
 * Decompiled with CFR 0.152.
 */
package org.huahua.pr.Content.AdvancementReward;

import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.huahua.pr.C6C;
import org.huahua.pr.Content.AdvancementReward.CODECS.AttributeReward;
import org.huahua.pr.Content.AdvancementReward.CODECS.EffectReward;
import org.huahua.pr.Content.AdvancementReward.CODECS.RewardDefinition;
import org.huahua.pr.Content.AdvancementReward.RewardRegistries;

public class RewardManager {
    public static void checkAndApplyAllCompletedRewards(ServerPlayer player) {
        Registry<RewardDefinition> rewards = RewardRegistries.rewardRegistry(player.registryAccess());
        rewards.forEach(reward -> {
            ResourceKey<Advancement> advancementResourceKey = reward.advancement();
            AdvancementHolder advancement = player.server.getAdvancements().get(advancementResourceKey.location());
            if (advancement == null) {
                return;
            }
            boolean isCompleted = player.getAdvancements().getOrStartProgress(advancement).isDone();
            if (!isCompleted) {
                return;
            }
            if (reward.hasEffectReward()) {
                RewardManager.applyEffectReward(player, reward.effectReward().get());
            }
            if (reward.hasAttributeReward()) {
                RewardManager.applyAttributeReward(player, reward.attributeReward().get());
            }
        });
    }

    private static void applyAttributeReward(ServerPlayer player, AttributeReward reward) {
        AttributeInstance attributeInstance = player.getAttribute(reward.attribute());
        if (attributeInstance == null) {
            C6C.LOGGER.warn("\u73a9\u5bb6\u6ca1\u6709\u5c5e\u6027: {}", reward.attribute());
            return;
        }
        ResourceLocation modifierId = ResourceLocation.fromNamespaceAndPath((String)"c6c", (String)reward.modifier());
        AttributeModifier modifier = new AttributeModifier(modifierId, reward.amount(), reward.operation());
        if (!attributeInstance.hasModifier(modifierId)) {
            attributeInstance.addPermanentModifier(modifier);
        }
    }

    private static void applyEffectReward(ServerPlayer player, EffectReward reward) {
        Optional effectOpt = BuiltInRegistries.MOB_EFFECT.getOptional(reward.effect());
        if (effectOpt.isEmpty()) {
            return;
        }
        MobEffect effect = (MobEffect)effectOpt.get();
        int duration = -1;
        MobEffectInstance effectInstance = new MobEffectInstance(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)effect), duration, reward.amplifier(), false, false, reward.showIcon());
        player.addEffect(effectInstance);
    }
}

