/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.gl.image;

import net.irisshaders.iris.gl.IrisRenderSystem;
import net.irisshaders.iris.gl.framebuffer.GlFramebuffer;
import net.irisshaders.iris.gl.image.GlImage;
import net.irisshaders.iris.gl.texture.ShaderDataType;

public abstract class ImageClearPass {
    protected final GlFramebuffer framebuffer = new GlFramebuffer();

    private ImageClearPass(GlImage image) {
        this.framebuffer.addColorAttachment(0, image.getId());
    }

    public static ImageClearPass create(GlImage image) {
        return switch (image.getInternalFormat().getShaderDataType()) {
            default -> throw new MatchException(null, null);
            case ShaderDataType.FLOAT -> new Float(image);
            case ShaderDataType.INT -> new Int(image);
            case ShaderDataType.UINT -> new UInt(image);
        };
    }

    public abstract void execute();

    public void destroy() {
        this.framebuffer.destroy();
    }

    private static class Float
    extends ImageClearPass {
        public Float(GlImage image) {
            super(image);
        }

        @Override
        public void execute() {
            IrisRenderSystem.clearBufferfv(this.framebuffer.getId(), 6144, 0, new float[]{0.0f, 0.0f, 0.0f, 0.0f});
        }
    }

    private static class Int
    extends ImageClearPass {
        public Int(GlImage image) {
            super(image);
        }

        @Override
        public void execute() {
            IrisRenderSystem.clearBufferiv(this.framebuffer.getId(), 6144, 0, new int[]{0, 0, 0, 0});
        }
    }

    private static class UInt
    extends ImageClearPass {
        public UInt(GlImage image) {
            super(image);
        }

        @Override
        public void execute() {
            IrisRenderSystem.clearBufferuiv(this.framebuffer.getId(), 6144, 0, new int[]{0, 0, 0, 0});
        }
    }
}

