/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.compat.sodium.mixin;

import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSectionManager;
import net.caffeinemc.mods.sodium.client.render.chunk.TaskQueueType;
import net.caffeinemc.mods.sodium.client.render.chunk.data.BuiltSectionInfo;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.CoordinateSectionVisitor;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.SortedRenderLists;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.TreeSectionCollector;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegionManager;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortBehavior;
import net.caffeinemc.mods.sodium.client.render.chunk.tree.RemovableMultiForest;
import net.caffeinemc.mods.sodium.client.render.viewport.Viewport;
import net.irisshaders.iris.mixinterface.ShadowRenderRegion;
import net.irisshaders.iris.shadows.ShadowRenderingState;
import net.minecraft.client.Camera;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RenderSectionManager.class}, remap=false)
public abstract class MixinRenderSectionManagerShadow {
    @Shadow(remap=false)
    @NotNull
    private SortedRenderLists renderLists;
    @Shadow(remap=false)
    private boolean needsGraphUpdate;
    @Shadow
    @Final
    private RenderRegionManager regions;
    @Shadow
    private int frame;
    @Unique
    @NotNull
    private SortedRenderLists shadowRenderLists = SortedRenderLists.empty();
    @Unique
    private boolean shadowNeedsRenderListUpdate = true;
    @Unique
    private boolean renderListStateIsShadow = false;
    @Shadow
    @Final
    private RemovableMultiForest renderableSectionTree;
    @Shadow
    @Final
    private Long2ReferenceMap<RenderSection> sectionByPosition;
    @Shadow
    @Final
    private SortBehavior sortBehavior;

    @Inject(method={"needsUpdate"}, at={@At(value="HEAD")})
    private void notifyChangedCamera(CallbackInfoReturnable<Boolean> cir) {
        this.shadowNeedsRenderListUpdate = true;
    }

    @Inject(method={"update"}, at={@At(target="Lnet/caffeinemc/mods/sodium/client/render/chunk/RenderSectionManager;createTerrainRenderList(Lnet/minecraft/client/Camera;Lnet/caffeinemc/mods/sodium/client/render/viewport/Viewport;IZ)Z", value="INVOKE")})
    private void updateRenderLists(Camera camera, Viewport viewport, boolean spectator, CallbackInfo ci) {
        this.shadowNeedsRenderListUpdate |= this.needsGraphUpdate;
    }

    @Shadow(remap=false)
    public abstract int getVisibleChunkCount();

    @Shadow(remap=false)
    public abstract int getTotalSections();

    @Shadow
    protected abstract float getRenderDistance();

    @Inject(method={"createTerrainRenderList"}, at={@At(value="HEAD")}, cancellable=true)
    private void updateShadowRenderLists(Camera camera, Viewport viewport, int frame, boolean spectator, CallbackInfoReturnable<Boolean> ci) {
        if (!ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            if (this.renderListStateIsShadow) {
                for (RenderRegion region : this.regions.getLoadedRegions()) {
                    ((ShadowRenderRegion)region).swapToRegularRenderList();
                }
                this.renderListStateIsShadow = false;
            }
            return;
        }
        TaskQueueType importantRebuildQueueType = SodiumClientMod.options().performance.chunkBuildDeferMode.getImportantRebuildQueueType();
        if (this.shadowNeedsRenderListUpdate) {
            if (!this.renderListStateIsShadow) {
                for (RenderRegion region : this.regions.getLoadedRegions()) {
                    ((ShadowRenderRegion)region).swapToShadowRenderList();
                }
                this.renderListStateIsShadow = true;
            }
            TaskQueueType importantSortQueueType = this.sortBehavior.getDeferMode().getImportantRebuildQueueType();
            TreeSectionCollector visitor = new TreeSectionCollector(frame, importantRebuildQueueType, importantSortQueueType, this.sectionByPosition);
            this.renderableSectionTree.prepareForTraversal();
            this.renderableSectionTree.traverse((CoordinateSectionVisitor)visitor, viewport, this.getRenderDistance());
            this.shadowRenderLists = visitor.createRenderLists(viewport);
            this.shadowNeedsRenderListUpdate = false;
            ci.setReturnValue((Object)visitor.needsRevisitForPendingUpdates());
        }
    }

    @Inject(method={"updateSectionInfo"}, at={@At(value="HEAD")})
    private void updateSectionInfo(RenderSection render, BuiltSectionInfo info, CallbackInfoReturnable<Boolean> cir) {
        this.shadowNeedsRenderListUpdate = true;
    }

    @Inject(method={"onSectionRemoved"}, at={@At(value="HEAD")})
    private void onSectionRemoved(int x, int y, int z, CallbackInfo ci) {
        this.shadowNeedsRenderListUpdate = true;
    }

    @Redirect(method={"getRenderLists", "getVisibleChunkCount", "renderLayer"}, at=@At(value="FIELD", target="Lnet/caffeinemc/mods/sodium/client/render/chunk/RenderSectionManager;renderLists:Lnet/caffeinemc/mods/sodium/client/render/chunk/lists/SortedRenderLists;"), remap=false)
    private SortedRenderLists useShadowRenderList(RenderSectionManager instance) {
        return ShadowRenderingState.areShadowsCurrentlyBeingRendered() ? this.shadowRenderLists : this.renderLists;
    }

    @Inject(method={"getVisibleChunkCount"}, at={@At(value="HEAD")}, cancellable=true)
    private void iris$useShadowList(CallbackInfoReturnable<Integer> cir) {
        if (ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            int sections = 0;
            for (ChunkRenderList renderList : this.shadowRenderLists) {
                sections += renderList.getSectionsWithGeometryCount();
            }
            cir.setReturnValue((Object)sections);
        }
    }
}

