
let $EnchantmentCategory = Java.loadClass('net.minecraft.world.item.enchantment.EnchantmentCategory')
let $ModernKineticGunItem = Java.loadClass('com.tacz.guns.item.ModernKineticGunItem')
let $TimelessAPI = Java.loadClass("com.tacz.guns.api.TimelessAPI")
let $Integer = Java.loadClass('java.lang.Integer')

// tacz的枪械通用附魔类别
let tacz_common = $EnchantmentCategory.create('TACZC', (item) => item instanceof $ModernKineticGunItem)
let un = $EnchantmentCategory.create('UN', (item) => !Enchantmentblacklist.includes(item.id))

let Enchantmentblacklist = [
    "tacz:modern_kinetic_gun",
    "touhou_little_maid:ultramarine_orb_elixir"
]

StartupEvents.registry("enchantment", e => {

    e.create("mryh:tactical_enhancement")
        .category(tacz_common)
        .minLevel(1)
        .maxLevel(5)
        .veryRare()
        .displayName("增强射击战术")

    e.create("mryh:slowing_bullets")
        .category(tacz_common)
        .minLevel(1)
        .maxLevel(5)
        .veryRare()
        .displayName("减速射击战术")
    e.create("mryh:onekill_bullets")
        .category(tacz_common)
        .minLevel(1)
        .maxLevel(5)
        .veryRare()
        .displayName("湮灭射击战术")
    e.create("mryh:boom_bullets")
        .category(tacz_common)
        .minLevel(1)
        .maxLevel(5)
        .veryRare()
        .displayName("爆裂射击战术")
    e.create("mryh:phantom_enhancement")
        .category(tacz_common)
        .minLevel(1)
        .maxLevel(5)
        .veryRare()
        .displayName("幻影射击战术")
    e.create("mryh:spore_kill_bullets")
        .category(tacz_common)
        .minLevel(1)
        .maxLevel(5)
        .veryRare()
        .displayName("冷冻射击战术")
    /*
e.create("mryh:infinite_enhancement")
    .displayName("无限射击战术")
    */
    e.create("mryh:unbreakable")
        .category(un)
        .displayName("无法破坏")
})


EnchantJSEvent.modification(e => {
    e.modify('mryh:boom_bullets', (enchant) => {
        enchant.setCanApplyAtEnchantingTableFn(i => {
            let gunType = "unknown"
            if (i.item instanceof $ModernKineticGunItem) {
                let GunId = i.nbt.getString("GunId")
                $TimelessAPI.getCommonGunIndex(GunId).ifPresent(gun => {
                    gunType = gun.getType();
                });
            }
            switch (gunType) {
                case "sniper":
                    return true
                case "mg":
                    return true
                default:
                    return false
            }
        })
        enchant.setCanEnchantFn(i => {
            let gunType = "unknown"
            if (i.item instanceof $ModernKineticGunItem) {
                let GunId = i.nbt.getString("GunId")
                $TimelessAPI.getCommonGunIndex(GunId).ifPresent(gun => {
                    gunType = gun.getType();
                });
            }
            switch (gunType) {
                case "sniper":
                    return true
                case "mg":
                    return true
                default:
                    return false
            }
        })
    })
    e.modify('mryh:onekill_bullets', (enchant) => {
        enchant.setCanApplyAtEnchantingTableFn(i => {
            let gunType = "unknown"
            if (i.item instanceof $ModernKineticGunItem) {
                let GunId = i.nbt.getString("GunId")
                $TimelessAPI.getCommonGunIndex(GunId).ifPresent(gun => {
                    gunType = gun.getType();
                });
            }
            switch (gunType) {
                case "sniper":
                    return true
                default:
                    return false
            }
        })
        enchant.setCanEnchantFn(i => {
            let gunType = "unknown"
            if (i.item instanceof $ModernKineticGunItem) {
                let GunId = i.nbt.getString("GunId")
                $TimelessAPI.getCommonGunIndex(GunId).ifPresent(gun => {
                    gunType = gun.getType();
                });
            }
            switch (gunType) {
                case "sniper":
                    return true
                default:
                    return false
            }
        })
    })
    e.modify('mryh:spore_kill_bullets', (enchant) => {
        enchant.setCanApplyAtEnchantingTableFn(i => {
            let gunType = "unknown"
            if (i.item instanceof $ModernKineticGunItem) {
                let GunId = i.nbt.getString("GunId")
                $TimelessAPI.getCommonGunIndex(GunId).ifPresent(gun => {
                    gunType = gun.getType();
                });
            }
            switch (gunType) {
                case "sniper":
                    return true
                default:
                    return false
            }
        })
        enchant.setCanEnchantFn(i => {
            let gunType = "unknown"
            if (i.item instanceof $ModernKineticGunItem) {
                let GunId = i.nbt.getString("GunId")
                $TimelessAPI.getCommonGunIndex(GunId).ifPresent(gun => {
                    gunType = gun.getType();
                });
            }
            switch (gunType) {
                case "sniper":
                    return true
                default:
                    return false
            }
        })
        /*
        e.modify('mryh:phantom_enhancement', (enchant) => {
            enchant.setCanEnchantFn(i => {
                let Gunenchant = false
                Gunenchant = i.hasEnchantment('mryh:infinite_enhancement', 1)
                if (Gunenchant) {
                    return false
                } else {
                    return true
                }
            })
        })
        e.modify('mryh:infinite_enhancement', (enchant) => {
            enchant.setCanEnchantFn(i => {
                let Gunenchant = false
                Gunenchant = i.hasEnchantment('mryh:phantom_enhancement', 1)
                if (Gunenchant) {
                    return false
                } else {
                    return true
                }
            })
        })
            */
        e.modify('mryh:unbreakable', (enchant) => {
            enchant.setCanEnchantFn(i => {
                return i.id != 'touhou_little_maid:ultramarine_orb_elixir'
            })
        })
    })
})


ItemEvents.modification(event => {
    event.modify("tacz:modern_kinetic_gun", item => {
        item.setRealIsEnchantable(stack => true)
        item.setRealGetEnchantmentValueFn(stack => {
            return 50
        })
    })
})


/*
ItemEvents.modification(e => {
 
    e.modify('tacz:modern_kinetic_gun', item => {
 
        // 忆然：给枪械附魔能力
        item.setEnchantmentValueFunction((stack) => {
 
            let value
 
            $TimelessAPI.getCommonGunIndex(item.getGunId(stack)).ifPresent(index => {
 
                // 筛选枪械类型
                switch (index.getType()) {
                    // 霰弹枪
                    case "shotgun":
                        return value = 10
                    // 未指定类型
                    default:
                        return value = 1
                }
 
            })
 
            return $Integer.valueOf(String(value))
 
        })
    })
 
})
*/