let $ModifyAttributeEventJS = Java.loadClass("net.liopyu.entityjs.events.ModifyAttributeEventJS")
let $ItemAttributeModifierEvent = Java.loadClass("net.minecraftforge.event.ItemAttributeModifierEvent")
let $EntityAttributeModificationEvent = Java.loadClass("net.minecraftforge.event.entity.EntityAttributeModificationEvent")
let $RangedAttribute = Java.loadClass("net.minecraft.world.entity.ai.attributes.RangedAttribute")

StartupEvents.registry('attribute', e => {
    let simpleCreateCustomAttribute =
        (attrname, basic, min, max) => {
            e.createCustom('mryh:' + attrname, () =>
                new $RangedAttribute('attribute.occupation.' + attrname, basic, min, max)
            )
        }
    simpleCreateCustomAttribute('police', 0, 0, 10)
    simpleCreateCustomAttribute('veteran', 0, 0, 10)
    simpleCreateCustomAttribute('firemen', 0, 0, 10)
    simpleCreateCustomAttribute('cooks', 0, 0, 10)
    simpleCreateCustomAttribute('doctor', 0, 0, 10)
    simpleCreateCustomAttribute('technician', 0, 0, 10)
})
ForgeModEvents.onEvent($EntityAttributeModificationEvent, e => {
    /**@type {(attr:$Attribute_,entitylist:$EntityType_<T>[])} */
    let addAttribute = (attr, entitylist) => {
        entitylist.forEach(entity => {
            if (!e.has(entity, attr)) e.add(entity, attr)
        })
    }
    addAttribute('mryh:police', ['player'])
    addAttribute('mryh:veteran', ['player'])
    addAttribute('mryh:firemen', ['player'])
    addAttribute('mryh:cooks', ['player'])
    addAttribute('mryh:doctor', ['player'])
    addAttribute('mryh:technician', ['player'])
})