let $ResourceKey=Java.loadClass('net.minecraft.resources.ResourceKey')
let $Registries=Java.loadClass('net.minecraft.core.registries.Registries')

/**
 * 获取结构的ResourceKey
 * @param {Special.Structure} structureName  
 */
function structureKey(structureName) { return $ResourceKey.create($Registries.STRUCTURE, structureName) }

/**
 * 检测坐标是否在结构内，如果在则返回true
 * @param {$ServerLevel_} level
 * @param {$BlockPos$MutableBlockPos_} pos
 * @param {string} structureName
 */
let simpleCheckPosInStructure = (level, pos, structureName) =>
    !!level.structureManager().getStructureWithPieceAt(pos, structureKey(structureName)).getStructure()

const hordeSpawnStructure = [

]

let $ChunkPos = Java.loadClass("net.minecraft.world.level.ChunkPos")
/**
 * @param {Internal.Player} Y$player
 * @returns 
 */
function checkStructure(Y$player) {
    let Y$serverLevel = Y$player.level
    let Y$playerPos = Y$player.block.pos
    /** @type {Internal.Structure[]} */
    let Y$structureArray = Y$serverLevel.structureManager().getAllStructuresAt(Y$playerPos).keySet().toArray()
    let Y$structureRegistry = Y$serverLevel.registryAccess().registryOrThrow($Registries.STRUCTURE)
    for (let Y$structure of Y$structureArray) {
        let Y$structureStart =
            Y$serverLevel.structureManager().getStructureAt(Y$playerPos, Y$structure)
        if (Y$structureStart.isValid()) {
            if (hordeSpawnStructure.indexOf(Y$structureRegistry.getKey(Y$structure).toString()) > -1) {
                return true
            }
        }
    }
    return false
}

// Y:测试用的,可以删除
// ItemEvents.tooltip(event => {
// ItemEvents.firstLeftClicked(event => {
//     event.player.tell(checkStructure(event.player) ? "true" : "false")
// })


// 冷却时间，单位为游戏刻（10分钟）
const cooldownTime = 10 * 60 * 20;
// 触发尸潮的随机概率（例如1/100）
const hordeSpawnChance = 100 / 100;
/*
// 检测玩家是否进入特定结构
PlayerEvents.tick(e => {
    let player = e.player;

    // Y:每秒执行一次 之前执行的太多了罢!
    if (player.age % 20 != 0) return;

    let level = player.level;
    let pos = player.blockPosition();
    let playerData = player.persistentData;
    let currentTime = level.dayTime();

    // 增加玩家上次尸潮时间的nbt
    let lastTriggerTime = playerData.getInt("mryh:lastHordeTriggerTime"); // 如果没有则默认为0

    // 检查是否超过冷却时间
    // Y:将存粹的数字运算前置，应该能优化点
    if (currentTime - lastTriggerTime >= cooldownTime) {
        // Y:修改结构检测,减少不必要的计算
        if (checkStructure(player)) {
            // 随机概率触发尸潮
            if (Math.random() < hordeSpawnChance) {
                // 更新玩家的触发时间
                playerData.putInt("mryh:lastHordeTriggerTime", currentTime);
                let day = Math.floor(level.dayTime() / 24000);
                let hordeType = updateHordeType(day); // 根据天数更新尸潮类型
                player.tell("你惊动了某处的怪物！尸潮即将来袭！");
                player.runCommandSilent(`/hordes spawnWave ${player.name.string} 30 ${hordeType}`);
            }
        }
    }
});
*/
