
// 会引起尸潮的特殊物品（例：CDU）
let specialItems = [
    "spore:cdu"
    // 可以在这里添加更多特殊物品
];

// 标记每个特殊物品是否已经触发过尸潮
let blockMarks = new Array(specialItems.length).fill(false);
// 用注册到访结构进度来代替访问结构
let specialStructures = [

]
// 更新hordeType的函数
function updateHordeType(day) {
    if (day < 5) {
        return "hordes:default";
    } else if (day < 15) {
        return "hordes:hordes10";
    } else if (day < 25) {
        return "hordes:hordes20";
    } else if (day < 35) {
        return "hordes:hordes30";
    } else if (day < 45) {
        return "hordes:hordes40";
    } else if (day < 55) {
        return "hordes:hordes50";
    } else if (day < 65) {
        return "hordes:hordes60";
    } else if (day < 75) {
        return "hordes:hordes70";
    } else if (day < 85) {
        return "hordes:hordes80";
    } else if (day < 95) {
        return "hordes:hordes90";
    } else {
        return "hordes:hordes100";
    }
}

let horde_spawn=0

LevelEvents.tick(event => {
    let day = Math.floor(event.level.dayTime() / 24000);
    let dayTick = event.level.dayTime() % 24000;

    // 夜晚时间从13000刻到23990刻
    let isNightTime = dayTick >= 13000 && dayTick <= 23990;

    // 每五天触发一次尸潮
    if (isNightTime && day % 5 == 0 && day !== 0) {
        let hordeType = updateHordeType(day);

        // 直接触发尸潮
        if (dayTick === 13000) {
            event.server.runCommandSilent(`/hordes spawnWave @r 30 ${hordeType}`);
            /*
            event.server.runCommandSilent(`/playsound mryh:music.horde_spawn player @a ~ ~ ~`);
            */
           event.server.sendData('mryh:hordes_spawn',{ hordes_spawn: 1 })
        }
        if (dayTick === 16000) {
            event.server.runCommandSilent(`/hordes spawnWave @r 40 ${hordeType}`);
        }
        if (dayTick === 19000) {
            event.server.runCommandSilent(`/hordes spawnWave @r 50 ${hordeType}`);
        }
        if (dayTick === 22000) {
            event.server.runCommandSilent(`/hordes spawnWave @r 60 ${hordeType}`);
        }
    }
});

/*
BlockEvents.broken(event => {
    let day = Math.floor(event.level.dayTime() / 24000);
    let item = event.block.id;
    let hordeType = updateHordeType(day);
    let player = event.player.name.string;

    // 检查被破坏的物品是否在特殊物品数组中，并且游戏天数大于10
    let itemIndex = specialItems.indexOf(item);
    if (itemIndex !== -1 && day > 10 && !blockMarks[itemIndex]) {
        event.server.runCommandSilent(`/hordes spawnWave ${player} 50 ${hordeType}`);
        event.server.runCommandSilent(`/title ${player} title {"text":"你惊动了尸潮！","color":"red","bold":true}`);
        blockMarks[itemIndex] = true; // 标记该物品已触发尸潮
    }
});
*/


