
ItemEvents.rightClicked(event => {
    if (event.item.item.id != 'mryh:data_watch') return
    let player = event.player;
    let stats = player.getStats(); // 获取玩家的统计信息对象
    // 获取特定统计信息的值
    let playTimeTicks = stats.playTime; // 获取游戏时间（刻）
    let timeSinceDeathTicks = stats.timeSinceDeath; // 获取距上次死亡时间（刻）
    let deathCount = stats.deaths; // 获取死亡次数
    // 转换为分钟
    let playTimeMinutes = playTimeTicks / 20 / 60;
    let timeSinceDeathMinutes = timeSinceDeathTicks / 20 / 60;
    let monsterBonus = Math.max(0, playTimeMinutes / 20 + timeSinceDeathMinutes / 10 - deathCount);
    // 测试输出
    event.player.tell(`§a游戏时间: §e${Math.round(playTimeMinutes)}分钟`);
    event.player.tell(`§c距上次死亡: §e${Math.round(timeSinceDeathMinutes)}分钟`);
    event.player.tell(`§d死亡次数: §e${deathCount}次`);
    event.player.tell(`§6当前怪物属性加成基础: §e${monsterBonus.toFixed(2)}`);
});