
// 指令创建
ServerEvents.commandRegistry(event => {
    let { commands: Commands, arguments: Arguments } = event;
    event.register(
        Commands.literal('mryh')
            .requires(src => src.hasPermission(2)) // 确保命令执行者具有足够的权限
            .then(Commands.literal('query')
                .then(Commands.argument('player', Arguments.PLAYER.create(event))
                    .executes(ctx => {
                        let playerName = Arguments.PLAYER.getResult(ctx, 'player');
                        let player = ctx.source.server.getPlayer(playerName);
                        let name = ctx.source.player.name;
                        if (!player) {
                            ctx.source.player.tell(`查询不到玩家：${name}`);
                            return 0;
                        }
                        let stages = player.stages.getAll().toArray();
                        stages.sort(); // 对阶段进行排序
                        if (stages.length === 0) {
                            ctx.source.player.tell(`玩家 ${name} 没有阶段。`);
                        } else {
                            ctx.source.player.tell(`玩家 ${name} 拥有以下阶段：\n` + stages.join("，"));
                        }
                        return 1;
                    })
                )
            )
    );
    event.register(
        Commands.literal('mryh')
            .requires(src => src.hasPermission(2))
            .then(Commands.literal('difficult')
                .then(Commands.argument('player', Arguments.PLAYER.create(event))
                    .then(Commands.argument('arg1', Arguments.INTEGER.create(event))
                        .executes(ctx => {
                            let diffLevelNum = Arguments.INTEGER.getResult(ctx, 'arg1');
                            let player = ctx.source.server.getPlayer(Arguments.PLAYER.getResult(ctx, 'player'))

                            let oriDiffStage = player.stages.getAll().toArray().find(ele => ele.startsWith('difficult_level_'))
                            if (oriDiffStage) {
                                player.stages.remove(oriDiffStage)
                            }
                            player.stages.add('difficult_level_' + diffLevelNum)
                            return 1
                        }
                        )
                    )
                )
            )
    )
});

// 属性变化数组
let difficultLevelDef = [
    { healthMulti: 0.5, attackMulti: 1.0, armorMulti: 1.0, speedMulti: 0.8 },// 求生
    { healthMulti: 1.0, attackMulti: 1.0, armorMulti: 1.0, speedMulti: 1.0 },// 末世
    { healthMulti: 1.5, attackMulti: 1.2, armorMulti: 1.2, speedMulti: 1.1 },// 绝境
    { healthMulti: 2.0, attackMulti: 1.5, armorMulti: 1.5, speedMulti: 1.2 } // 湮灭
];
// 原版难度
let difficultlevelMC = [
    { healthMulti: 0.5, attackMulti: 1.0, armorMulti: 1.0, speedMulti: 0.8 },// 简单
    { healthMulti: 1.0, attackMulti: 1.0, armorMulti: 1.0, speedMulti: 1.0 },// 普通
    { healthMulti: 2.0, attackMulti: 1.5, armorMulti: 1.5, speedMulti: 1.2 } // 困难
]

EntityEvents.spawned(e => {
    /**
    * @type {Internal.LivingEntity}
    */
    let entity = e.entity
    if (!entity) return
    let player = entity.getLevel().getNearestPlayer(entity, 240)
    if (!player) return
    if (!entity.isLiving() || !(entity.isMonster())) return
    if (entity.persistentData.contains('diffLevel')) return

    let diffStage = player.stages.getAll().toArray().find(ele => ele.startsWith('difficult_level_'));
    let diffLevelNum = 1; 

    if (diffStage) {
        let match = diffStage.match('difficult_level_(\\d+)');
        if (match && match[1]) {
            diffLevelNum = parseInt(match[1]);
            diffLevelNum = Math.max(1, Math.min(diffLevelNum, difficultLevelDef.length));
        }
    }

    let diffLevel = difficultLevelDef[diffLevelNum - 1] || { healthMulti: 1, attackMulti: 1, armorMulti: 1, speedMulti: 1 };

    entity.persistentData.putInt('diffLevel', diffLevelNum);

    let mcDifficultyId = Math.max(1, Math.min(e.level.difficulty.id, difficultlevelMC.length));
    let diffLevelMC = difficultlevelMC[mcDifficultyId - 1];

    let stats = player.getStats(); 

    let playTimeTicks = stats.playTime; 
    let timeSinceDeathTicks = stats.timeSinceDeath; 
    let deathCount = stats.deaths; 

    let playTimeMinutes = playTimeTicks / 20 / 60;
    let timeSinceDeathMinutes = timeSinceDeathTicks / 20 / 60;
    let monsterBonus = Math.max(0, playTimeMinutes / 20 + timeSinceDeathMinutes / 10 - deathCount);

    let dayeffect = monsterBonus.toFixed(2);
    let randomfactor = 0.8 + (1.3 - 0.8) * Math.random();
    let health_fixedEffect = Math.min(dayeffect * randomfactor / 2, 300)
    let attack_damage_fixedEffect = Math.min(dayeffect * randomfactor / 200, 2)
    let armor_fixedEffect = Math.min(dayeffect * randomfactor / 50, 50)
    let movement_speed_fixedEffect = Math.min(dayeffect * randomfactor / 1000, 1)

    if (diffLevel.healthMulti != 0 && entity.attributes.hasAttribute('minecraft:generic.max_health')) {
        entity.setAttributeBaseValue('minecraft:generic.max_health', entity.getAttribute('minecraft:generic.max_health').getValue() * diffLevel.healthMulti * diffLevelMC.healthMulti + health_fixedEffect);
        entity.setHealth(entity.getMaxHealth());
    }
    if (diffLevel.attackMulti != 0 && entity.attributes.hasAttribute('minecraft:generic.attack_damage')) {
        let original = entity.getAttribute('minecraft:generic.attack_damage').getValue();
        let rawMulti = diffLevel.attackMulti * diffLevelMC.attackMulti * attack_damage_fixedEffect;
        let clampedMulti = Math.min(rawMulti, 4); 
        entity.setAttributeBaseValue('minecraft:generic.attack_damage', original * clampedMulti);
    }
    if (diffLevel.armorMulti != 0 && entity.attributes.hasAttribute('minecraft:generic.armor')) {
        entity.setAttributeBaseValue('minecraft:generic.armor', entity.getAttribute('minecraft:generic.armor').getValue() * diffLevel.armorMulti * diffLevelMC.armorMulti + armor_fixedEffect);
    }
    if (diffLevel.speedMulti != 0 && entity.attributes.hasAttribute('minecraft:generic.movement_speed')) {
        let originalSpeed = entity.getAttribute('minecraft:generic.movement_speed').getValue();
        let newSpeed = originalSpeed * diffLevel.speedMulti * diffLevelMC.speedMulti + movement_speed_fixedEffect;

        let clampedSpeed = Math.min(newSpeed, originalSpeed * 1.2);

        entity.setAttributeBaseValue('minecraft:generic.movement_speed', clampedSpeed);
    }
})
