
let $SpawnerBlockEntity = Java.loadClass('net.minecraft.world.level.block.entity.SpawnerBlockEntity')

let playersSpawnTickCount = {}

let mob_pool = [
    "minecraft:zombie",
    "zombie_extreme:infected",
    "zombie_extreme:parasite",
    "undead_revamp2:the_moonflower",
    "apocalypsenow:runner_40",
    "zombie_extreme:infected_police"
]

PlayerEvents.tick(event => {
    if (event.level.dayTime() % 20 * 20 !== 0) return
    if (event.level.dayTime() <= 24000 * 5) return
    if (event.level.difficulty.id == 0) return
    let uuid = event.getEntity().getStringUuid()
    if (playersSpawnTickCount[uuid] == null) {
        //设定默认值
        playersSpawnTickCount[uuid] = 100
    }
    playersSpawnTickCount[uuid]--
    if (Math.random() > event.level.difficulty.id / 10) return
    let spawnerPositions = [];
    event.level.getChunkAt(event.player.block.pos).getBlockEntities().forEach((pos, spawner) => {
        if (!(spawner instanceof $SpawnerBlockEntity)) return
        let deltaY = Math.abs(event.player.block.pos.y - pos.y)
        if (deltaY < 4) {
            spawnerPositions.push(pos.immutable())
        }
    })

    //foreach换成for，用来跳出循环
    for (let pos of spawnerPositions) {
        if (playersSpawnTickCount[uuid] > 0) break
        event.level.setBlockAndUpdate(pos, Block.getBlock('minecraft:air').defaultBlockState())
        event.server.tell('一小股尸潮正在爆发！！')
        let spawnerX = pos.x;
        let spawnerY = pos.y;
        let spawnerZ = pos.z;

        for (let j = 0; j < 15; j++) {
            let mobid = mob_pool[Math.floor(Math.random() * mob_pool.length)];
            let mob = event.level.createEntity(mobid);
            let cageChunkX = spawnerX >> 4;
            let cageChunkZ = spawnerZ >> 4;
            let nowChunkX = Math.floor(sx) >> 4;
            let nowChunkZ = Math.floor(sz) >> 4;
            if (nowChunkX !== cageChunkX || nowChunkZ !== cageChunkZ) {
                sx = spawnerX + 0.5;
                sz = spawnerZ + 0.5;
                sy = spawnerY + 1;
            }
            let sx = spawnerX + Math.floor(Math.random() * 11) - 5;   // -5...+5
            let sz = spawnerZ + Math.floor(Math.random() * 11) - 5;
            let sy = spawnerY + Math.floor(Math.random() * 7) - 3;    // -3...+3

            while (sy > spawnerY - 3 &&
                !event.level.getBlockState(new BlockPos(sx, sy - 1, sz)).canOcclude()) sy--;

            while (sy < spawnerY + 3 &&
                (event.level.getBlockState(new BlockPos(sx, sy, sz)).canOcclude() ||
                    event.level.getBlockState(new BlockPos(sx, sy + 1, sz)).canOcclude())) sy++;

            if (sy < spawnerY - 3 || sy > spawnerY + 3) sy = spawnerY;

            mob.setPosition(sx + 0.5, sy, sz + 0.5);

            mob.persistentData.putString("mryh_hordes_spawn_wave", "true");
            mob.spawn();
        }
        //设置冷却
        playersSpawnTickCount[uuid] = 100
    }

});

EntityEvents.spawned(e => {
    if (!e.entity.persistentData.getString("mryh_hordes_spawn_wave") == true) return
    /**
     * @type {Internal.LivingEntity}
     */
    let mob = e.entity
    mob.potionEffects.add('minecraft:glowing', 1200)
})

/*
PlayerEvents.chat(e=>{
    e.player.give(Item.of('minecraft:written_book', '{author:"世界的观测者",pages:[\'{"text":"         你们睁开双眼，看到的是一个支离破碎的世界。\\\\n         天空不再蔚蓝，大地布满疮痍，空气中弥漫着腐朽与金属的气息。\\\\n         你们困惑、恐惧，甚至愤怒\\\\n\\\\n——这一切为何发生？\\\\n——你们是谁？\\\\n——又该去向何方？"}\',\'{"text":"         但记住，这个世界并非全然死去。它在挣扎，在低语，在等待。\\\\n         那些废墟之下埋藏着旧日的真相，风中飘荡着未解的谜题。你们脚下的土地曾是实验室、城市、家园，如今却成了战场与坟场。\\\\n\\\\n\\\\n          可你们并非孤身一人。"}\',\'{"text":"         有人会告诉你们“生存就是一切”，有人会警告“信任即是奢侈”。\\\\n         但我要说：观察，思考，然后选择。你们遇到的每一个“人”，每一段记忆\\\\n         甚至每一次死亡，都可能是一把钥匙——解开过去，或是打开未来。"}\',\'{"text":"         孢子生物在暗处滋生，血肉之花在阴影中绽放，而你们……或许是偶然，或许是注定，站在了这场浩劫的交叉点上。\\\\n         活下去，但别忘了：你们不仅是幸存者，也是观测者。你们的每一个选择，都在重塑这个世界的结局。\\\\n\\\\n\\\\n\\\\n\\\\n      ——来自某个仍在记录的身影"}\'],title:"《致新生的幸存者》"}'))
})
*/