
let $Color = Java.loadClass("java.awt.Color")
function rgbaColor(R, G, B, A) {
    return new $Color(R / 255, G / 255, B / 255, A / 100).getRGB();
}
let MAX_HOSTILE_MOBS = 100;

EntityEvents.spawned(e => {
    if (!e.entity.isMonster()) return
    let count_overworld = e.level.getEntities().filter(entity => entity.isMonster() && entity.level.dimension === 'minecraft:overworld').size();
    if (count_overworld > MAX_HOSTILE_MOBS * e.level.difficulty.id) {
        e.cancel()
    }
    let count_lostcities = e.level.getEntities().filter(entity => entity.isMonster() && entity.level.dimension === 'lostcities:lostcity').size();
    if (count_lostcities > (MAX_HOSTILE_MOBS * e.level.difficulty.id) / 2) {
        e.cancel()
    }
    let count_end = e.level.getEntities().filter(entity => entity.isMonster() && entity.level.dimension === 'minecraft:end').size();
    if (count_end > (MAX_HOSTILE_MOBS * e.level.difficulty.id) / 3) {
        e.cancel()
    }
    /*
    let spawnchance = e.level.difficulty.id
    if (spawnchance == 1) {
        if (Math.random() < 0.9) {
            e.cancel()
        }
    }
    if (spawnchance == 2) {
        if (Math.random() < 0.6) {
            e.cancel()
        }
    }
    */
})


let monsterNames = [
    "温酒故长安",
    "彩虹喵",
    "冷漠冫无情",
    "尤里QAQ",
    "星野大叔",
    "❅落花☬眠影❅",
    "bRyan Gosling",
    "牧枫",
    "鹤原木桃香",
    "March.",
    "汤姆",
    "TomCat",
    "妖孽卡比",
    "柚子茶",
    "𝙎𝙪𝙥𝙧𝙚𝙢𝙚",
    "fjndjdkdkf",
    "Gentiana",
    "雨桑",
    "长月之肆.",
    "艽",
    "科恩亚",
    "李氏姐姐",
    "清景",
    "Round Valley Company",
    "呓语",
    "——",
    "Alice",
    "冻奶",
    "飞鱼桑",
    "illusion",
    "mrma",
    "SF-2403",
    "太极·未花",
    "小忆然喵",
    "白珀",
    "哈基然"
];

EntityEvents.spawned(e => {
    if (!e.entity.isMonster()) return;
    if (Math.random() < 0.99) return
    let randomName = monsterNames[Math.floor(Math.random() * monsterNames.length)];
    e.entity.setCustomName(Text.of(randomName).color(rgbaColor(Math.random() * 255, Math.random() * 255, Math.random() * 255, 100)));
    e.entity.setCustomNameVisible(true);
});

/*
PlayerEvents.chat(e => {
    let count = e.level.getEntities().filter(entity => entity.isMonster() && entity.level.dimension === 'minecraft:overworld').size();
    e.player.tell(`${count}`)
})
*/