
let $TimelessAPI = Java.loadClass("com.tacz.guns.api.TimelessAPI")
let $BuiltInRegistries = Java.loadClass('net.minecraft.core.registries.BuiltInRegistries')
let $MobType = Java.loadClass('net.minecraft.world.entity.MobType')

$BuiltInRegistries.ENCHANTMENT.forEach((/**@type {Internal.Enchantment} key */key, value) => {
    if (key.category == "UNIVERSAL_ENCHANTS_MRYH_KILLERADD_BULLET_3") {
        /**@type {Internal.EnchantmentCategory} */
        console.log(key.category.canEnchant(Item.of("tacz:modern_kinetic_gun")))
    } else if (key.category == "UNIVERSAL_ENCHANTS_MRYH_KILLERADD_BULLET") {
        console.log(key.category.canEnchant(Item.of("tacz:modern_kinetic_gun")))
    }
})
/**
 * @param {Internal.LivingHurtEvent_} event 
 * @param {$LivingEntityHurtEventJS_} event
 * @returns
 */
// 处理非玩家造成的伤害
global.HurtCoreByOther = event => {
    DifficultdamageToPlayer(event)
};

/** 
 * @param {Internal.LivingHurtEvent_} event 
 */
global.HurtCoreByPlayer = event => {
    event.entity.invulnerableTime = 10 + 1;
    handleDamageByPlayer(event);
    OccupationDamageByPlayer(event);
    finalDamageByPlayer(event)
};

/** 
 * @param {Internal.LivingHurtEvent_} event 
 */
function handleDamageByPlayer(event) {
    let DamageType = event.getSource().getType().toString();
    switch (DamageType) {
        case "tacz.bullet":
            return BulletDamageByPlayer(event);
        default:
            break;
    }
}


let tagToMultiplier = {
    'difficult_level_1': 0.8,
    'difficult_level_2': 1.0,
    'difficult_level_3': 1.5,
    'difficult_level_4': 2.0
};

/** 
 * @param {Internal.LivingHurtEvent_} event 
 */
function DifficultdamageToPlayer(event) {
    if (!event.entity.isPlayer()) return;

    let multiplier = 1.0;

    for (let tag in tagToMultiplier) {
        if (event.entity.tags.contains(tag)) {
            multiplier = tagToMultiplier[tag];
            break;
        }
    }

    event.amount = Math.round(event.amount * multiplier * 100) / 100;
}

/** 
 * @param {Internal.LivingHurtEvent_} event 
 */
function BulletDamageByPlayer(event) {
    let enchantlevel = event.source.player.mainHandItem
    // 增强射击战术
    if (enchantlevel.getEnchantmentLevel("mryh:tactical_enhancement")) {
        let count = event.amount * (1 + 0.05 * enchantlevel.getEnchantmentLevel("mryh:tactical_enhancement"))
        event.setAmount(count)
    }
    // 减速射击战术
    if (enchantlevel.getEnchantmentLevel("mryh:slowing_bullets")) {
        /**
         * @type {Internal.LivingEntity}
         */
        let entity = event.entity
        entity.potionEffects.add('minecraft:slowness', 60, enchantlevel.getEnchantmentLevel("mryh:slowing_bullets"))
    }
    // 爆裂射击战术
    if (enchantlevel.getEnchantmentLevel("mryh:boom_bullets")) {
        if (Math.random() > 0.02 * enchantlevel.getEnchantmentLevel("mryh:boom_bullets")) return
        let GunId = event.source.player.mainHandItem.nbt.getString("GunId")
        $TimelessAPI.getCommonGunIndex(GunId).ifPresent(gun => {
            let gunType = gun.getType();
            let tnt = event.entity.block.createExplosion()
            switch (gunType) {
                case "mg":
                    tnt.strength(Math.min(event.amount / 20, 10))
                    tnt.explode()
                case "sniper":
                    tnt.strength(Math.min(event.amount / 20, 15))
                    tnt.explode()
            }
        });
    }
    // 湮灭射击战术
    if (enchantlevel.getEnchantmentLevel("mryh:onekill_bullets")) {
        if (!event.source.player.tags.contains('difficult_level_4')) return
        let GunId = event.source.player.mainHandItem.nbt.getString("GunId")
        let maxhealth = event.entity.maxHealth
        let health = event.entity.health
        $TimelessAPI.getCommonGunIndex(GunId).ifPresent(gun => {
            let gunType = gun.getType();
            switch (gunType) {
                case "sniper":
                    if (health / maxhealth > 0.1 * enchantlevel.getEnchantmentLevel("mryh:onekill_bullets")) return
                    event.setAmount(maxhealth)
            }
        });
    }
    // 冷冻射击战术（反真菌射击战术）
    if (enchantlevel.getEnchantmentLevel("mryh:spore_kill_bullets")) {
        let spore_monster_damage_fina = 0
    }
}


/** 
 * @param {Internal.LivingHurtEvent_} event 
 */
function OccupationDamageByPlayer(event) {
    let OccupationType = event.source.actual.persistentData.getString("Occupation");
    switch (OccupationType) {
        case "firemen":
            return firemenDamageByPlayer(event);
        case "police":
            return policeDamageByPlayer(event);
        case "veteran":
            return veteranDamageByPlayer(event);
        case "technician":
            return technicianDamageByPlayer(event);
        case "doctor":
            return doctorDamageByPlayer(event);
        case "cooks":
            return cooksDamageByPlayer(event);
        default:
            break;
    }
}


/** 
 * @param {Internal.LivingHurtEvent_} event 
 */
function firemenDamageByPlayer(event) {
    let abilitycount = event.source.player.getAttribute('mryh:firemen').getValue()
    if (abilitycount >= 1) {
        let weapon = event.source.player.mainHandItem.id
        let firemenitem = [
            'marbledsarsenal:fire_axe',
            'zombiekit:netherite_fire_axe',
            'zombiekit:netherite_fire_axe',
            'zombie_extreme:fireaxe',
            'apocalypsenow:wooden_fire_axe',
            'apocalypsenow:fire_axe'
        ]
        if (firemenitem.includes(weapon)) {
        }
    }
    if (abilitycount >= 2) {

    }
    if (abilitycount = 3) {

    }
}

/** 
 * @param {Internal.LivingHurtEvent_} event 
 */
function policeDamageByPlayer(event) {
    let abilitycount = event.source.player.getAttribute('mryh:police').getValue()
    if (abilitycount >= 1) {
        let weapon = event.source.player.mainHandItem.id
        let policeitem = [
            'apocalypsenow:night_stick',
            'zombie_extreme:police_baton',
            'apocalypsenow:electric_baton'
        ]
        if (policeitem.includes(weapon)) {
            let attacker = event.source.player
            let target = event.entity
            let viewVector = attacker.getViewVector(1.0);
            let length = Math.sqrt(viewVector.x() * viewVector.x() + viewVector.y() * viewVector.y() + viewVector.z() * viewVector.z());
            let normalizedVector = {
                x: viewVector.x() / length,
                y: viewVector.y() / length,
                z: viewVector.z() / length
            };
            let velocity = 2
            target.setMotion(
                normalizedVector.x * velocity,
                normalizedVector.y * velocity,
                normalizedVector.z * velocity
            )
            event.entity.potionEffects.add('minecraft:slowness', 100, 0)
        }
    }
    if (abilitycount >= 2) {

    }
    if (abilitycount = 3) {

    }

}
/** 
 * @param {Internal.LivingHurtEvent_} event 
 */
function veteranDamageByPlayer(event) {
    let abilitycount = event.source.player.getAttribute('mryh:veteran').getValue()
    if (abilitycount >= 1) {
        let trueamount = event.amount * 1.2
        event.amount = trueamount
    }
    if (abilitycount >= 2) {

    }
    if (abilitycount = 3) {

    }

}
/** 
 * @param {Internal.LivingHurtEvent_} event 
 */
function technicianDamageByPlayer(event) {
    let abilitycount = event.source.player.getAttribute('mryh:technician').getValue()
    if (abilitycount >= 1) {
        if (event.entity.isUndead()) {
            let trueamount = event.amount * 1.5
            event.amount = trueamount
        }
    }
    if (abilitycount >= 2) {

    }
    if (abilitycount = 3) {

    }

}
/** 
 * @param {Internal.LivingHurtEvent_} event 
 */
function doctorDamageByPlayer(event) {
    let abilitycount = event.source.player.getAttribute('mryh:doctor').getValue()
    if (abilitycount >= 1) {
        let weapon = event.source.player.mainHandItem.id
        if (weapon == 'apocalypsenow:scalpel') {
            let count = 0;
            if (event.entity.persistentData.getString('mryh_mob') == 'bleeding') {
                return
            } else (
                event.entity.persistentData.putString('mryh_mob', 'bleeding')
            )
            let blood = event.entity.server.scheduleRepeatingInTicks(20, blood => {
                if (!event.entity.isAlive()) return;
                if (count >= 10) return;
                if (event.entity.health > 6) {
                    event.entity.attack(6)
                    count++;
                } else {
                    event.entity.kill()
                    blood.clear()
                    return
                }
                if (event.entity.isAlive() && count == 10) {
                    event.entity.persistentData.remove('mryh_mob')
                    blood.clear()
                }
            })
        }
    }
    if (abilitycount >= 2) {

    }
    if (abilitycount = 3) {

    }

}
/** 
 * @param {Internal.LivingHurtEvent_} event 
 */
function cooksDamageByPlayer(event) {
    let abilitycount = event.source.player.getAttribute('mryh:cooks').getValue()
    if (abilitycount >= 1) {

    }
    if (abilitycount >= 2) {

    }
    if (abilitycount = 3) {

    }

}

/** 
 * @param {Internal.LivingHurtEvent_} event 
 */
function finalDamageByPlayer(event) {
    let spore_monster_damage_fina = event.amount
    if (!event.entity.isPlayer()) {
        if (event.source.player.mainHandItem.getEnchantmentLevel("mryh:spore_kill_bullets")) {
            if (spore_entity.includes(event.entity.type)) {
                let monster_health = event.entity.getHealth()
                let finaldamage = spore_monster_damage_fina
                if (Math.random() > 0.15 * event.source.player.mainHandItem.getEnchantmentLevel("mryh:spore_kill_bullets")) return
                if (monster_health > finaldamage) {
                    event.entity.health = monster_health - event.amount
                    event.source.player.tell("已突破真菌生物防御")
                } else if (monster_health <= finaldamage) {
                    event.source.player.tell("已歼灭真菌生物")
                    event.entity.kill()
                }
            }
        }

    }
}

let spore_entity = [
    "spore:inf_human",
    "spore:inf_villager",
    "spore:inf_wanderer",
    "spore:inf_witch",
    "spore:inf_pillager",
    "spore:inf_player",
    "spore:inf_hazmat",
    "spore:inf_drowned",
    "spore:inf_husk",
    "spore:inf_wandering_trader",
    "spore:inf_evoker",
    "spore:inf_vindicator",
    "spore:braiomil",
    "spore:knight",
    "spore:griefer",
    "spore:busser",
    "spore:spitter",
    "spore:leaper",
    "spore:slasher",
    "spore:howler",
    "spore:stalker",
    "spore:brute",
    "spore:volatile",
    "spore:hallucination",
    "spore:inquisitor",
    "spore:lacerator",
    "spore:brotkatze",
    "spore:plagued",
    "spore:mound",
    "spore:verwahrung",
    "spore:howitzer",
    "spore:sieger",
    "spore:scamper",
    "spore:vervathorn",
    "spore:womb",
    "spore:hindenburg",
    "spore:wendigo",
    "spore:vigil",
    "spore:gazenbreacher",
    "spore:scent",
    "spore:delusioner",
    "spore:specter",
    "spore:jagdhund",
    "spore:scavenger",
    "spore:ogre",
    "spore:infested_construct",
    "spore:bloater",
    "spore:tendril",
    "spore:nuckelave",
    "spore:hexenmeister",
    "spore:nuke",
    "spore:axtwerfer",
    "spore:hohlfresser",
    "spore:bioblob",
    "spore:saugling",
    "spore:inebrieter",
    "spore:protector",
    "spore:mephetic",
    "spore:proto",
    "spore:reconstructor",
    "spore:gastgaber",
    "spore:usurper",
    "spore:umarmed",
    "spore:verva",
    "spore:thorn",
    "spore:nuclea",
    "minecraft:creeper"
]