let $LostCitiesImp = Java.loadClass("mcjty.lostcities.LostCitiesImp");
let $LostCities = Java.loadClass("mcjty.lostcities.LostCities");

// 建筑类型配置
const BUILDING_TYPES = {
    "apartment": { name: "公寓", stars: "★☆☆☆☆", lootMultiplier: 1.0 },
    "library": { name: "图书馆", stars: "★★☆☆☆", lootMultiplier: 1.0 },
    "skyscraper": { name: "摩天大楼", stars: "★★☆☆☆", lootMultiplier: 1.0 },
    "bank": { name: "银行", stars: "★★☆☆☆", lootMultiplier: 1.0 },
    "bazaar": { name: "商业街", stars: "★☆☆☆☆", lootMultiplier: 1.0 },
    "mall": { name: "商业中心", stars: "★☆☆☆☆", lootMultiplier: 1.0 },
    "beacon": { name: "灯塔", stars: "★★☆☆☆", lootMultiplier: 1.0 },
    "camp": { name: "野营", stars: "★☆☆☆☆", lootMultiplier: 1.0 },
    "dwelling": { name: "居民住宅", stars: "★☆☆☆☆", lootMultiplier: 1.0 },
    "fire_factory": { name: "火电厂", stars: "★★★☆☆", lootMultiplier: 1.0 },
    "firehouse": { name: "消防站", stars: "★★☆☆☆", lootMultiplier: 1.0 },
    "police_station": { name: "警察局", stars: "★★☆☆☆", lootMultiplier: 1.0 },
    "hospital": { name: "医院", stars: "★★★☆☆", lootMultiplier: 1.0 },
    "hotel": { name: "酒店", stars: "★★☆☆☆", lootMultiplier: 1.0 },
    "office": { name: "办公楼", stars: "★★☆☆☆", lootMultiplier: 1.0 },
    "oilrig": { name: "深海钻井平台", stars: "★★★☆☆", lootMultiplier: 1.0 },
    "prison": { name: "监狱", stars: "★★★★☆", lootMultiplier: 1.0 },
    "research_institute": { name: "军事研究所", stars: "★★★★☆", lootMultiplier: 1.0 },
    "school": { name: "学校", stars: "★☆☆☆☆", lootMultiplier: 1.0 },
    "villa": { name: "别墅", stars: "★☆☆☆☆", lootMultiplier: 1.0 }
};

// 难度配置
const DIFFICULTY_LEVELS = {
    0: "和平", 1: "简单", 2: "普通", 3: "困难"
};

const MRYH_DIFFICULTY_LEVELS = {
    "difficult_level_1": "求生", "difficult_level_2": "末世",
    "difficult_level_3": "绝境", "difficult_level_4": "湮灭"
};

// 战利品概率计算函数 - 确保括号完整
function calculateLootProbability(baseProbability, luck, difficulty, mryhDifficulty, buildingMultiplier) {
    if (buildingMultiplier === undefined) buildingMultiplier = 1.0;

    let probability = baseProbability * buildingMultiplier;

    if (luck >= 6) {
        probability *= 1.5;
    }

    if (difficulty === "困难") {
        probability *= 1.5;
    }

    if (mryhDifficulty === "湮灭") {
        probability *= 1.5;
    }

    return probability;
}

ItemEvents.rightClicked(event => {
    if (event.item.item.id != 'mryh:building_radar') return
    let player = event.player;
    let playerName = event.player.name.string; // 获取玩家名
    let level = event.level;
    let chunkx = event.level.getChunkAt(event.player.block.pos).pos.x;
    let chunky = event.level.getChunkAt(event.player.block.pos).pos.z;
    let buildingId = $LostCities.lostCitiesImp.getLostInfo(level).getChunkInfo(chunkx, chunky).buildingId.toString();

    // 获取难度信息
    let difficult = event.level.difficulty.id;
    let difficultid = DIFFICULTY_LEVELS[difficult] || "未定级";

    let luck = player.getAttribute('minecraft:generic.luck').baseValue;
    let diff = player.stages.getAll().toArray().find(ele => ele.startsWith('difficult_level_'));
    let mryh_diff = MRYH_DIFFICULTY_LEVELS[diff] || "未定级";

    // 查找匹配的建筑类型
    let buildingInfo = null;
    for (let [key, value] of Object.entries(BUILDING_TYPES)) {
        if (buildingId.includes(key)) {
            buildingInfo = value;
            break;
        }
    }

    if (buildingInfo) {
        // 计算战利品概率
        let lootProbability = calculateLootProbability(0.17, luck, difficultid, mryh_diff, buildingInfo.lootMultiplier);
        let lootDisplay = (lootProbability * 100).toFixed(2) + '%';

        event.player.tell(`当前玩家战利品加成:战利品池子'§a 原版难度：${difficultid}§f'+'§b 幸运等级：${luck}§f'+'§e 末日余晖难度：${mryh_diff}§f'，附加战利品概率：§d ${lootDisplay}§f`);
        event.player.server.runCommandSilent(`/title ${playerName} title {"text":"当前处于建筑类型: ${buildingInfo.name}","color":"yellow","bold":true}`);
        event.player.server.runCommandSilent(`/title ${playerName} subtitle {"text":"战利品星级：${buildingInfo.stars}","color":"red","italic":true}`);
    }
});
/*
ItemEvents.firstLeftClicked(event => {
    let level = event.level;
    let chunkx = event.level.getChunkAt(event.player.block.pos).pos.x;
    let chunky = event.level.getChunkAt(event.player.block.pos).pos.z;
    let buildingId = $LostCities.lostCitiesImp.getLostInfo(level).getChunkInfo(chunkx, chunky).buildingId.toString();
    event.player.tell(buildingId)
});
*/