// 卫星雷达站战利品表
ServerEvents.chestLootTables(event => {
    event.modify('mryh:satellite_radar_station_1', loot => {
        loot.addPool(pool => {
            pool.addItem('minecraft:iron_ingot').weight(22).count([1, 4]);
            pool.addItem('minecraft:iron_nugget').weight(18).count([1, 3]);
            pool.addItem('minecraft:diamond').weight(25).count([1, 2]);
            pool.addItem('apocalypsenow:money').weight(20).count([1, 4]);
            pool.addItem('minecraft:gold_ingot').weight(15).count([1, 3]);
            pool.addItem('minecraft:gold_nugget').weight(20).count([1, 2]);
            pool.addItem('zombiekit:alcohol').weight(22).count([1, 4]);
            pool.addItem('minecraft:glowstone_dust').weight(18).count([1, 3]);
            pool.addItem('minecraft:slime_ball').weight(25).count([1, 2]);
            pool.addItem('apocalypsenow:electrical_scrap').weight(15).count([1, 4]);
            pool.addItem('minecraft:chicken').weight(20).count([1, 3]);
            pool.addItem('minecraft:cod').weight(22).count([1, 2]);
            pool.addItem('minecraft:mutton').weight(18).count([1, 4]);
            pool.addItem('minecraft:blaze_rod').weight(25).count([1, 3]);
            pool.addItem('minecraft:porkchop').weight(15).count([1, 2]);
            pool.addItem('minecraft:beef').weight(20).count([1, 4]);
            pool.addItem('minecraft:rabbit').weight(22).count([1, 3]);
            pool.addItem('minecraft:beetroot').weight(18).count([1, 2]);
            pool.addItem('minecraft:flint').weight(25).count([1, 4]);
            pool.addItem('minecraft:coal').weight(15).count([1, 3]);
            pool.addItem('minecraft:raw_gold').weight(20).count([1, 2]);
            pool.addItem('minecraft:raw_iron').weight(22).count([1, 4]);
            pool.addItem('minecraft:raw_copper').weight(18).count([1, 3]);
            pool.addItem('create:raw_zinc').weight(25).count([1, 2]);
            pool.addItem('minecraft:sugar').weight(15).count([1, 4]);
            pool.addItem('minecraft:amethyst_shard').weight(20).count([1, 3]);
            pool.addItem('minecraft:redstone').weight(22).count([1, 2]);
            pool.addItem('minecraft:paper').weight(18).count([1, 4]);
            pool.addItem('apocalypsenow:textilethread').weight(25).count([1, 3]);
            pool.addItem('minecraft:emerald').weight(15).count([1, 2]);
            pool.addItem('minecraft:feather').weight(20).count([1, 4]);
            pool.addItem('minecraft:carrot').weight(22).count([1, 3]);
            pool.addItem('minecraft:bone_meal').weight(18).count([1, 2]);
            pool.addItem('minecraft:bone').weight(25).count([1, 4]);
            pool.addItem('minecraft:lapis_lazuli').weight(15).count([1, 3]);
            pool.addItem('minecraft:copper_ingot').weight(20).count([1, 2]);
            pool.addItem('minecraft:ink_sac').weight(22).count([1, 4]);
            pool.addItem('apocalypsenow:engineering_parts').weight(18).count([1, 3]);
            pool.addItem('apocalypsenow:scrapmetal').weight(25).count([1, 2]);
            pool.addItem('minecraft:stick').weight(15).count([1, 4]);
            pool.addItem('minecraft:charcoal').weight(20).count([1, 3]);
            pool.addItem('zombiekit:camphor').weight(22).count([1, 2]);
            pool.addItem('zombiekit:rubber').weight(18).count([1, 4]);
            pool.addItem('minecraft:gunpowder').weight(25).count([1, 3]);
            pool.addItem('minecraft:leather').weight(15).count([1, 2]);
            pool.addItem('minecraft:quartz').weight(20).count([1, 4]);
            pool.addItem('minecraft:book').weight(22).count([1, 3]);
            pool.addItem('apocalypsenow:plastic').weight(18).count([1, 2]);
            pool.addItem('apocalypsenow:plasticplate').weight(25).count([1, 4]);
            pool.addItem('zombie_extreme:m_9_knife').weight(20);
            pool.addItem('zombie_extreme:military_suit_leggings').weight(25);
            pool.addItem('zombie_extreme:military_machete').weight(15);
            pool.addItem('zombie_extreme:military_suit_chestplate').weight(20);
            pool.addItem('zombie_extreme:military_suit_boots').weight(25);
            pool.addItem('tacz:modern_kinetic_gun').weight(15).nbt({ GunId: "mpworld:ls22b" });
            pool.addItem('tacz:modern_kinetic_gun').weight(20).nbt({ GunId: "tacz:scar_h" });
            pool.addItem('tacz:modern_kinetic_gun').weight(25).nbt({ GunId: "tacz:scar_l" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "mpworld:ls" });
            pool.addItem('tacz:modern_kinetic_gun').weight(22).nbt({ GunId: "mpworld:ls45" });
            pool.addItem('tacz:modern_kinetic_gun').weight(17).nbt({ GunId: "tacz:m16a4" });
            pool.addItem('tacz:modern_kinetic_gun').weight(23).nbt({ GunId: "tacz:m16a1" });
            pool.addItem('tacz:modern_kinetic_gun').weight(19).nbt({ GunId: "gfl2:191" });
            pool.addEmpty(200);
            pool.rolls = 5;
        })
    })

    event.modify('mryh:satellite_radar_station_2', loot => {
        loot.addPool(pool => {
            pool.addItem('tacz:modern_kinetic_gun').weight(15).nbt({ GunId: "mpworld:545p" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "tacz:sks_tactical" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "bf1:vg15" });
            pool.addItem('tacz:modern_kinetic_gun').weight(16).nbt({ GunId: "bluearchive:shiroko" });
            pool.addItem('tacz:modern_kinetic_gun').weight(14).nbt({ GunId: "gfl2:wanderingstars" });
            pool.addItem('tacz:modern_kinetic_gun').weight(17).nbt({ GunId: "gfl2:g11_5" });
            pool.addItem('tacz:modern_kinetic_gun').weight(13).nbt({ GunId: "tacz:type_81" });
            pool.addItem('tacz:modern_kinetic_gun').weight(19).nbt({ GunId: "bluearchive:toki" });
            pool.addItem('tacz:modern_kinetic_gun').weight(11).nbt({ GunId: "bluearchive:yukino" });
            pool.addItem('tacz:modern_kinetic_gun').weight(16).nbt({ GunId: "immersive_armorer:assult_rifle" });
            pool.addItem('tacz:modern_kinetic_gun').weight(14).nbt({ GunId: "bluearchive:azusa" });
            pool.addItem('tacz:modern_kinetic_gun').weight(17).nbt({ GunId: "create_armorer:rifle_assult_crane" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "mpworld:22r" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "bf1:m1916" });
            pool.addItem('tacz:modern_kinetic_gun').weight(13).nbt({ GunId: "mpworld:ls30" });
            pool.addItem('tacz:modern_kinetic_gun').weight(15).nbt({ GunId: "mpworld:ls30b" });
            pool.addItem('tacz:modern_kinetic_gun').weight(11).nbt({ GunId: "mpworld:ls22" });
            pool.addItem('tacz:modern_kinetic_gun').weight(19).nbt({ GunId: "tacz:aug" });
            pool.addItem('tacz:modern_kinetic_gun').weight(14).nbt({ GunId: "helldiver2:ar23p_liberator" });
            pool.addItem('tacz:modern_kinetic_gun').weight(16).nbt({ GunId: "helldiver2:ar23c_liberator" });
            pool.addItem('tacz:modern_kinetic_gun').weight(17).nbt({ GunId: "helldiver2:ar23_liberator" });
            pool.addItem('tacz:modern_kinetic_gun').weight(7).nbt({ GunId: "emxarms:emx_enforcer" });
            pool.addItem('tacz:modern_kinetic_gun').weight(6).nbt({ GunId: "bf1:vp1915" });
            pool.addItem('tacz:modern_kinetic_gun').weight(8).nbt({ GunId: "bluearchive:fuuka" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "helldiver2:sg225_breaker" });
            pool.addItem('tacz:modern_kinetic_gun').weight(9).nbt({ GunId: "applied_armorer:niklas_smg_freedom" });
            pool.addItem('tacz:modern_kinetic_gun').weight(6).nbt({ GunId: "cyber_armorer:g58_dian" });
            pool.addItem('tacz:modern_kinetic_gun').weight(8).nbt({ GunId: "cyber_armorer:saratoga" });
            pool.addItem('tacz:modern_kinetic_gun').weight(7).nbt({ GunId: "cyber_armorer:carnage" });
            pool.addItem('tacz:modern_kinetic_gun').weight(9).nbt({ GunId: "emxarms:emx_umx32" });
            pool.addItem('tacz:modern_kinetic_gun').weight(6).nbt({ GunId: "bf1:wex" });
            pool.addItem('tacz:modern_kinetic_gun').weight(8).nbt({ GunId: "tacz:aa12" });
            pool.addItem('tacz:modern_kinetic_gun').weight(7).nbt({ GunId: "bf1:ef46" });
            pool.addItem('tacz:modern_kinetic_gun').weight(9).nbt({ GunId: "create_armorer:smg_auto_crank" });
            pool.addItem('tacz:modern_kinetic_gun').weight(6).nbt({ GunId: "immersive_armorer:standard_rail_smg_mk1" });
            pool.addItem('tacz:modern_kinetic_gun').weight(8).nbt({ GunId: "gfl2:lioncubs" });
            pool.addItem('tacz:modern_kinetic_gun').weight(7).nbt({ GunId: "applied_armorer:moritz_shotgun_sg914" });
            pool.addItem('tacz:modern_kinetic_gun').weight(9).nbt({ GunId: "bluearchive:hoshino" });
            pool.addItem('tacz:modern_kinetic_gun').weight(6).nbt({ GunId: "cyber_armorer:g58_dian_yinglong" });
            pool.addItem('tacz:modern_kinetic_gun').weight(8).nbt({ GunId: "cyber_armorer:m2038_the_headsman" });
            pool.addItem('tacz:modern_kinetic_gun').weight(7).nbt({ GunId: "emxarms:emx_scgraves" });
            pool.addItem('tacz:modern_kinetic_gun').weight(9).nbt({ GunId: "emxarms:emx_expel32" });
            pool.addItem('tacz:modern_kinetic_gun').weight(6).nbt({ GunId: "emxarms:emx_expel32se" });
            pool.addItem('marbledsarsenal:medical_olive_helmet_cm7m_gas_mask').weight(15);
            pool.addItem('marbledsarsenal:medical_olive_combat_helmet').weight(20);
            pool.addItem('marbledsarsenal:desert_military_armor_helmet').weight(25);
            pool.addItem('marbledsarsenal:desert_military_armor_chestplate').weight(15);
            pool.addItem('marbledsarsenal:desert_military_armor_leggings').weight(20);
            pool.addItem('marbledsarsenal:desert_military_armor_boots').weight(25);
            pool.addItem('marbledsarsenal:medical_un_helmet_cm6m_gas_mask').weight(15);
            pool.addItem('marbledsarsenal:medical_un_helmet_cm7m_gas_mask').weight(20);
            pool.addItem('marbledsarsenal:medical_un_combat_helmet').weight(25);
            pool.addItem('apocalypsenow:military_radio').weight(15);
            pool.addItem('apocalypsenow:military_urban_boots').weight(20);
            pool.addItem('apocalypsenow:military_urban_chestplate').weight(25);
            pool.addItem('apocalypsenow:military_urban_leggings').weight(15);
            pool.addItem('apocalypsenow:military_urban_helmet').weight(20);
            pool.addItem('apocalypsenow:military_pilot_headset_chestplate').weight(25);
            pool.addItem('apocalypsenow:military_knife').weight(15);
            pool.addItem('apocalypsenow:military_shovel').weight(20);
            pool.addItem('apocalypsenow:military_riot_armor_leggings').weight(25);
            pool.addItem('apocalypsenow:tactical_saber').weight(15);
            pool.addItem('apocalypsenow:desert_military_bulletproof_vest_chestplate').weight(20);
            pool.addItem('apocalypsenow:royal_canada_police_officer_leggings').weight(25);
            pool.addItem('apocalypsenow:us_army_helmet').weight(15);
            pool.addItem('apocalypsenow:us_army_leggings').weight(20);
            pool.addItem('apocalypsenow:us_army_chestplate').weight(25);
            pool.addItem('apocalypsenow:us_army_boots').weight(15);
            pool.addItem('marbledsarsenal:medical_olive_helmet_cm6m_gas_mask').weight(20);
            pool.addItem('marbledsarsenal:winter_military_armor_boots').weight(25);
            pool.addItem('marbledsarsenal:winter_military_armor_chestplate').weight(15);
            pool.addItem('marbledsarsenal:winter_military_armor_leggings').weight(20);
            pool.addItem('marbledsarsenal:winter_military_armor_helmet').weight(25);
            pool.addItem('marbledsarsenal:medical_combat_helmet').weight(15);
            pool.addItem('marbledsarsenal:medical_helmet_cm8m_gas_mask').weight(20);
            pool.addItem('marbledsarsenal:medical_helmet_cm7m_gas_mask').weight(25);
            pool.addItem('marbledsarsenal:medical_helmet_cm6m_gas_mask').weight(15);
            pool.addItem('marbledsarsenal:medical_un_helmet_cm8m_gas_mask').weight(20);
            pool.addItem('marbledsarsenal:medical_olive_helmet_cm8m_gas_mask').weight(25);
            pool.addItem('apocalypsenow:military_pilotheadset').weight(15);
            pool.addItem('apocalypsenow:military_riot_armor_boots').weight(20);
            pool.addItem('apocalypsenow:military_riot_armor_chestplate').weight(25);
            pool.addItem('apocalypsenow:military_riot_armor_helmet').weight(15);
            pool.addItem('apocalypsenow:military_bulletprooft_vest_chestplate').weight(20);
            pool.addItem('apocalypsenow:military_beret_chestplate').weight(25);
            pool.addItem('apocalypsenow:military_beret_helmet').weight(15);
            pool.addEmpty(200);
            pool.rolls = 5;
        })
    })

    event.modify('mryh:satellite_radar_station_3', loot => {
        loot.addPool(pool => {
            pool.addItem('gold_ingot')
        })
    })

    event.modify('mryh:satellite_radar_station_4', loot => {
        loot.addPool(pool => {
            pool.addItem('minecraft:diamond')
        })
    })
})


// 定义物品列表
let POOLS_satellite_radar_station = {
    // 无幸运（0-1）
    noLuck: [

    ],
    // 幸运2+（2-5）
    luck2: [
        "apocalypsenow:canadian_army_helmet",
        "apocalypsenow:japanese_army_boots",
        "apocalypsenow:british_army_helmet",
        "apocalypsenow:british_army_leggings",
        "apocalypsenow:british_army_boots",
        "apocalypsenow:british_army_chestplate",
        "apocalypsenow:japanese_army_chestplate",
        "apocalypsenow:japanese_army_leggings",
        "apocalypsenow:japanese_army_helmet",
        "apocalypsenow:mexican_army_helmet",
        "apocalypsenow:mexican_army_leggings",
        "apocalypsenow:mexican_army_chestplate",
        "apocalypsenow:mexican_army_boots",
        "apocalypsenow:brazilian_army_helmet",
        "apocalypsenow:brazilian_army_leggings",
        "apocalypsenow:canadian_army_leggings",
        "apocalypsenow:canadian_army_chestplate",
        "apocalypsenow:canadian_army_boots",
        "apocalypsenow:italian_bersaglieri_army_chestplate",
        "apocalypsenow:italian_bersaglieri_army_leggings",
        "apocalypsenow:italian_bersaglieri_army_helmet",
        "apocalypsenow:italian_bersaglieri_army_boots",
        "apocalypsenow:brazilian_army_boots",
        "apocalypsenow:brazilian_army_chestplate"
    ],
    // 幸运6+
    luck6: [
        "apocalypsenow:usa_armor_leggings",
        "apocalypsenow:russian_army_helmet",
        "apocalypsenow:russian_army_chestplate",
        "apocalypsenow:usa_armor_boots",
        "apocalypsenow:chinese_army_leggings",
        "apocalypsenow:chinese_army_boots",
        'apocalypsenow:army_boots',
        'apocalypsenow:army_chestplate',
        'apocalypsenow:army_leggings',
        'apocalypsenow:army_helmet'
    ],
    // 困难模式
    hardMode: [
        "apocalypsenow:russian_army_leggings",
        "apocalypsenow:chinese_army_chestplate",
        "apocalypsenow:usa_armor_helmet",
    ],
    // TAG
    TagMode: [
        "apocalypsenow:russian_army_boots",
        "apocalypsenow:chinese_army_helmet",
        "apocalypsenow:usa_armor_chestplate",

    ],
    // 枪械
    gunIds: {
        noLuck: [

        ],
        luck2: [
            "emxarms:emx_draftsman_ev1",
            "helldiver2:sg225ie_breaker",
            "gfl2:ls06",
            "emxarms:emx_expel32_lb",
            "gfl2:mindhunter",
            "trisdyna:fpc211",
            "trisdyna:iras",
            "gfl2:stm",
            "emxarms:emx_draftsman_ev",
            "emxarms:emx_draftsman",
            "dawnhunting:tcpl_vector45",
            "emxarms:emx_expel32se_ba",
            "emxarms:emx_umx32_koei"
        ],
        luck6: [
            "mpworld:ak338lb",
            "mpworld:ak338l",
            "tacz:rpk",
            "tacz:m95",
            "tacz:m700",
            "bf1:man_m95",
            "tacz:ai_awp",
            "bf1:martini",
            "bc:ak50",
            "create_armorer:sniper_semi_clockwork",
            "immersive_armorer:railgun",
            "create_armorer:mg_platemag_flywheel",
            "mpworld:mas49",
            "mpworld:ssg08b",
            "mpworld:ssg08",
            "tacz:m107",
            "tacz:m249",
            "bf1:lewis",
            "helldiver2:r63cs_diligence",
            "helldiver2:r63_diligence",
            "bc:qjz171",
            "bf1:mg0815",
            "bf1:tg1918",
            "cyber_armorer:grad",
            "cyber_armorer:grad_05",
            "immersive_armorer:chemical_thrower",
            "bluearchive:otogi",
            "mpworld:qwhdknife2",
            "emxarms:emx_pmg90eos",
            "applied_armorer:moritz_sniper_semi_k30",
            "applied_armorer:moritz_gernade_gl3",
            "emxarms:emx_mk88",
            "cyber_armorer:grad_sparky",
            "gfl2:bittercaramel",
            "cyber_armorer:grad_overwatch",
            "cyber_armorer:grad_borzaya",
            "gfl2:forestelves",
            "bc:muxing_s",
            "emxarms:emx_pmg90"
        ],
        hardMode: [

        ],
        TagMode: [
            "emxarms:emx_rivet",
            "emxarms:emx_umx57",
            "emxarms:emx_mk951r",
            "emxarms:emx_mk951l",
            "tacz:hk_g3",
            "bluearchive:serika",
            "mpworld:sc15",
            "bluearchive:momoi",
            "bf1:f_faust",
            "create_armorer:special_melee_atomic",
            "create_armorer:special_melee_wrench",
            "bf1:man_m95",
            "tacz:m320",
            "tacz:ai_awp",
            "tacz:m107",
            "bf1:martini",
            "gfl2:95_5",
            "tacz:ak47",
            "tacz:qbz_95",
            "tacz:hk416d",
            "gfl2:416a5",
            "gfl2:skulla",
            "cyber_armorer:copperhead",
            "cyber_armorer:ajax_pit_bull",
            "cyber_armorer:ajax_moron_labe",
            "cyber_armorer:ajax",
            "tacz:mk14",
            "bf1:mhgl",
            "mpworld:ls30c",
            "applied_armorer:moritz_rifle_ar77",
            "applied_armorer:niklas_lever_vigenere",
            "emxarms:emx_umx57h",
            "tacz:m4a1",
            "gfl2:97",
            "mpworld:te_01",
            "mpworld:mas49",
            "immersive_armorer:railgun",
            "create_armorer:sniper_semi_clockwork",
            "bc:spg9",
            "helldiver2:r63_diligence",
            "helldiver2:r63cs_diligence",
            "tacz:m700",
            "gfl2:g36",
            "mpworld:ssg08b",
            "tacz:m95",
            "tacz:rpg7",
            "applied_armorer:special_melee_task_manager",
            "helldiver2:r36_eruptor",
            "bf1:tg1918",
            "helldiver2:jar5_dominator",
            "mpworld:ssg08"
        ]
    },
    // 子弹
    ammoIds: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
    // 配件
    attachmentId: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
};


LootJS.modifiers(e => {
    e.addLootTableModifier(/.*mryh:chests\/satellite_radar_station.*/)
        .randomChance(1)
        .apply(context => {
            let BASE_CHANCE = 0.17;
            let luck = context.getLuck();
            let difficulty = context.level.difficulty.id;
            let player = context.player;
            if (!player) return
            let hasTagMode = player?.tags.contains('difficult_level_4');
            let { finalLootPool, chanceMultiplier } = getFinalLootPool(POOLS_satellite_radar_station, luck, difficulty, player);
            if (finalLootPool.length === 0) return;
            let finalChance = Math.min(BASE_CHANCE * chanceMultiplier, 1.0);
            let rolls = getRandomNumber(1, 3);
            for (let i = 0; i < rolls; i++) {
                let randomIndex = Math.floor(Math.random() * finalLootPool.length);
                let selectedItem = finalLootPool[randomIndex];
                let entry = createLootEntry(context, selectedItem, POOLS_satellite_radar_station, luck, difficulty, hasTagMode, finalChance);
                context.addLoot(entry);
            }
        });
});