// 研究所战利品表
ServerEvents.chestLootTables(event => {
    event.modify('mryh:research_institute_1', loot => {
        loot.addPool(pool => {
            pool.addItem('spore:living_core').weight(20).count([1, 4]);
            pool.addItem('minecraft:slime_ball').weight(25).count([1, 3]);
            pool.addItem('spore:nerves').weight(15).count([1, 2]);
            pool.addItem('spore:tendons').weight(22).count([1, 4]);
            pool.addItem('spore:compound').weight(18).count([1, 3]);
            pool.addItem('spore:biomass').weight(23).count([1, 2]);
            pool.addItem('spore:toxic_syringe').weight(17).count([1, 4]);
            pool.addItem('spore:mutation_syringe').weight(21).count([1, 3]);
            pool.addItem('spore:compound_plate').weight(24).count([1, 2]);
            pool.addItem('minecraft:sugar').weight(16).count([1, 4]);
            pool.addItem('create:raw_zinc').weight(22).count([1, 3]);
            pool.addItem('minecraft:raw_copper').weight(18).count([1, 2]);
            pool.addItem('minecraft:raw_iron').weight(24).count([1, 4]);
            pool.addItem('minecraft:raw_gold').weight(17).count([1, 3]);
            pool.addItem('minecraft:glowstone_dust').weight(21).count([1, 2]);
            pool.addItem('zombiekit:alcohol').weight(19).count([1, 4]);
            pool.addItem('minecraft:gold_nugget').weight(23).count([1, 3]);
            pool.addItem('minecraft:gold_ingot').weight(16).count([1, 2]);
            pool.addItem('apocalypsenow:money').weight(22).count([1, 4]);
            pool.addItem('minecraft:diamond').weight(18).count([1, 3]);
            pool.addItem('minecraft:iron_nugget').weight(24).count([1, 2]);
            pool.addItem('minecraft:iron_ingot').weight(17).count([1, 4]);
            pool.addItem('minecraft:copper_ingot').weight(21).count([1, 3]);
            pool.addItem('minecraft:lapis_lazuli').weight(23).count([1, 2]);
            pool.addItem('minecraft:bone').weight(16).count([1, 4]);
            pool.addItem('minecraft:bone_meal').weight(22).count([1, 3]);
            pool.addItem('spore:sickle_fragment').weight(18).count([1, 2]);
            pool.addItem('spore:plated_muscle').weight(24).count([1, 4]);
            pool.addItem('spore:hardened_bind').weight(17).count([1, 3]);
            pool.addItem('spore:fleshy_bone').weight(21).count([1, 2]);
            pool.addItem('spore:mutated_fiber').weight(19).count([1, 4]);
            pool.addItem('spore:cerebrum').weight(23).count([1, 3]);
            pool.addItem('spore:alveolic_sack').weight(16).count([1, 2]);
            pool.addItem('spore:brain_noodles').weight(22).count([1, 4]);
            pool.addItem('spore:altered_spleen').weight(18).count([1, 3]);
            pool.addItem('spore:claw_fragment').weight(20).count([1, 2]);
            pool.addItem('apocalypsenow:electrical_scrap').weight(25).count([1, 4]);
            pool.addItem('minecraft:leather').weight(17).count([1, 3]);
            pool.addItem('minecraft:carrot').weight(21).count([1, 2]);
            pool.addItem('minecraft:feather').weight(16).count([1, 4]);
            pool.addItem('minecraft:emerald').weight(23).count([1, 3]);
            pool.addItem('apocalypsenow:textilethread').weight(18).count([1, 2]);
            pool.addItem('minecraft:paper').weight(22).count([1, 4]);
            pool.addItem('minecraft:redstone').weight(17).count([1, 3]);
            pool.addItem('minecraft:amethyst_shard').weight(24).count([1, 2]);
            pool.addItem('minecraft:gunpowder').weight(19).count([1, 4]);
            pool.addItem('zombiekit:rubber').weight(21).count([1, 3]);
            pool.addItem('zombiekit:camphor').weight(16).count([1, 2]);
            pool.addItem('minecraft:charcoal').weight(23).count([1, 4]);
            pool.addItem('minecraft:stick').weight(18).count([1, 3]);
            pool.addItem('apocalypsenow:scrapmetal').weight(22).count([1, 2]);
            pool.addItem('apocalypsenow:engineering_parts').weight(17).count([1, 4]);
            pool.addItem('minecraft:ink_sac').weight(21).count([1, 3]);
            pool.addItem('apocalypsenow:plasticplate').weight(19).count([1, 2]);
            pool.addItem('apocalypsenow:plastic').weight(24).count([1, 4]);
            pool.addItem('minecraft:book').weight(16).count([1, 3]);
            pool.addItem('minecraft:quartz').weight(20).count([1, 2]);
            pool.addItem('minecraft:blaze_rod').weight(23).count([1, 4]);
            pool.addItem('minecraft:coal').weight(18).count([1, 3]);
            pool.addItem('minecraft:flint').weight(22).count([1, 2]);
            pool.addItem('minecraft:beetroot').weight(17).count([1, 4]);
            pool.addItem('minecraft:rabbit').weight(21).count([1, 3]);
            pool.addItem('minecraft:beef').weight(19).count([1, 2]);
            pool.addItem('minecraft:porkchop').weight(24).count([1, 4]);
            pool.addItem('minecraft:mutton').weight(16).count([1, 3]);
            pool.addItem('minecraft:cod').weight(20).count([1, 2]);
            pool.addItem('minecraft:chicken').weight(22).count([1, 4]);
            pool.addEmpty(200);
            pool.rolls = 5;
        })
    })

    event.modify('mryh:research_institute_2', loot => {
        loot.addPool(pool => {
            pool.addItem('spore:nerves').weight(22).count([1, 4]);
            pool.addItem('spore:hardened_bind').weight(18).count([1, 3]);
            pool.addItem('spore:armor_fragment').weight(25).count([1, 2]);
            pool.addItem('spore:armor_plate').weight(17).count([1, 4]);
            pool.addItem('spore:heart_kebab').weight(20).count([1, 3]);
            pool.addItem('spore:brain_noodles').weight(19).count([1, 2]);
            pool.addItem('spore:corrosive_sack').weight(24).count([1, 4]);
            pool.addItem('spore:bile_tumor').weight(16).count([1, 3]);
            pool.addItem('spore:sickle_fragment').weight(21).count([1, 2]);
            pool.addItem('spore:milky_sack').weight(23).count([1, 4]);
            pool.addItem('spore:claw').weight(18).count([1, 3]);
            pool.addItem('spore:claw_fragment').weight(20).count([1, 2]);
            pool.addItem('spore:altered_spleen').weight(22).count([1, 4]);
            pool.addItem('spore:vigil_eye_soup').weight(17).count([1, 3]);
            pool.addItem('spore:cerebrum').weight(25).count([1, 2]);
            pool.addItem('spore:plated_muscle').weight(19).count([1, 4]);
            pool.addItem('spore:fleshy_claw').weight(20).count([1, 3]);
            pool.addItem('spore:fleshy_bone').weight(23).count([1, 2]);
            pool.addItem('spore:spine_fragment').weight(18).count([1, 4]);
            pool.addItem('spore:living_core').weight(21).count([1, 3]);
            pool.addItem('spore:roasted_heart_kebab').weight(24).count([1, 2]);
            pool.addItem('spore:spine').weight(17).count([1, 4]);
            pool.addItem('spore:alveolic_sack').weight(22).count([1, 3]);
            pool.addItem('spore:tendons').weight(19).count([1, 2]);
            pool.addItem('spore:sausage').weight(23).count([1, 4]);
            pool.addItem('spore:fiber_stew').weight(18).count([1, 3]);
            pool.addItem('spore:mutated_fiber').weight(20).count([1, 2]);
            pool.addItem('spore:mutated_heart').weight(25).count([1, 4]);
            pool.addItem('apocalypsenow:jet_pilot_boots').weight(25);
            pool.addItem('apocalypsenow:anarchy_helmet').weight(20);
            pool.addItem('apocalypsenow:anarchy_leggings').weight(15);
            pool.addItem('apocalypsenow:anarchy_chestplate').weight(22);
            pool.addItem('apocalypsenow:anarchy_boots').weight(18);
            pool.addItem('apocalypsenow:forestguard_helmet').weight(23);
            pool.addItem('apocalypsenow:forestguard_leggings').weight(17);
            pool.addItem('apocalypsenow:jet_pilot_leggings').weight(20);
            pool.addItem('apocalypsenow:jet_pilot_helmet').weight(24);
            pool.addItem('zombiekit:standard_tactical_helmet').weight(16);
            pool.addItem('zombiekit:standard_tactical_leggings').weight(21);
            pool.addItem('zombiekit:standard_tactical_boots').weight(19);
            pool.addItem('zombiekit:standard_tactical_chestplate').weight(24);
            pool.addItem('zombiekit:skiing_chestplate').weight(18);
            pool.addItem('zombiekit:skiing_leggings').weight(22);
            pool.addItem('zombiekit:skiing_helmet').weight(20);
            pool.addItem('zombiekit:skiing_boots').weight(23);
            pool.addItem('apocalypsenow:forestguard_boots').weight(17);
            pool.addItem('apocalypsenow:forestguard_chestplate').weight(21);
            pool.addItem('apocalypsenow:jet_pilot_chestplate').weight(19);
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "immersive_armorer:assult_rifle" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "mpworld:ls45" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "mpworld:ls30b" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "mpworld:ls30" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "mpworld:ls22" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "mpworld:ls22b" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "tacz:aug" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "immersive_armorer:standard_rail_smg_mk1" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "create_armorer:smg_auto_crank" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "bluearchive:yukino" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "bluearchive:azusa" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "bluearchive:fuuka" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "helldiver2:sg225_breaker" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "bf1:wex" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "bf1:vg15" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "tacz:sks_tactical" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "tacz:scar_l" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "tacz:scar_h" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "bf1:m1916" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "tacz:m16a4" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "tacz:aa12" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "helldiver2:ar23_liberator" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "helldiver2:ar23c_liberator" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "helldiver2:ar23p_liberator" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "mpworld:ls" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "tacz:m16a1" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "tacz:type_81" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "mpworld:545p" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "bf1:ef46" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "mpworld:22r" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "create_armorer:rifle_assult_crane" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "bluearchive:shiroko" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "emxarms:emx_scgraves" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "emxarms:emx_expel32" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "emxarms:emx_expel32se" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "emxarms:emx_umx32" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "emxarms:emx_enforcer" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "bf1:vp1915" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "cyber_armorer:m2038_the_headsman" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "applied_armorer:moritz_shotgun_sg914" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "applied_armorer:niklas_smg_freedom" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "cyber_armorer:g58_dian" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "cyber_armorer:saratoga" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "cyber_armorer:carnage" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "gfl2:lioncubs" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "gfl2:wanderingstars" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "gfl2:g11_5" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "gfl2:191" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "bluearchive:hoshino" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "bluearchive:toki" });
            pool.addItem('tacz:modern_kinetic_gun').weight(5).nbt({ GunId: "cyber_armorer:g58_dian_yinglong" });
            pool.addEmpty(200);
            pool.rolls = 5;
        })
    })

    event.modify('mryh:research_institute_3', loot => {
        loot.addPool(pool => {
            pool.addItem('gold_ingot')
        })
    })

    event.modify('mryh:research_institute_4', loot => {
        loot.addPool(pool => {
            pool.addItem('endrem:lost_eye').weight(100);
        })
    })

    event.modify('mryh:research_institute_armorammo', loot => {
        loot.addPool(pool => {
            pool.addItem('apocalypsenow:anarchy_boots').weight(12);
            pool.addItem('apocalypsenow:anarchy_chestplate').weight(10);
            pool.addItem('apocalypsenow:anarchy_leggings').weight(11);
            pool.addItem('apocalypsenow:anarchy_helmet').weight(13);
            pool.addItem('apocalypsenow:jet_pilot_boots').weight(14);
            pool.addItem('apocalypsenow:jet_pilot_chestplate').weight(12);
            pool.addItem('apocalypsenow:jet_pilot_leggings').weight(13);
            pool.addItem('apocalypsenow:jet_pilot_helmet').weight(15);
            pool.addItem('zombiekit:standard_tactical_helmet').weight(18);
            pool.addItem('apocalypsenow:forestguard_helmet').weight(16);
            pool.addItem('apocalypsenow:forestguard_leggings').weight(14);
            pool.addItem('apocalypsenow:forestguard_chestplate').weight(13);
            pool.addItem('apocalypsenow:forestguard_boots').weight(15);
            pool.addItem('zombiekit:skiing_chestplate').weight(17);
            pool.addItem('zombiekit:skiing_leggings').weight(16);
            pool.addItem('zombiekit:skiing_helmet').weight(18);
            pool.addItem('zombiekit:skiing_boots').weight(17);
            pool.addItem('zombiekit:standard_tactical_boots').weight(16);
            pool.addItem('zombiekit:standard_tactical_chestplate').weight(14);
            pool.addItem('zombiekit:standard_tactical_leggings').weight(15);

            pool.addEmpty(100);
            pool.rolls = 2;
        })
    })

    event.modify('mryh:research_institute_key', loot => {
        loot.addPool(pool => {
            pool.addItem('mryh:alliance_dimension_armor_plate').weight(50);
            pool.addItem('mryh:defense_dimension_armor_plate').weight(20);
            pool.addItem('mryh:unified_dimension_armor_plate').weight(10);
            pool.addItem('mryh:retaliation_dimension_armor_plate').weight(5);
            pool.addItem('mryh:novice_cabin_spawn_item').weight(14);
            pool.addItem('mryh:combined_seal').weight(2);

            pool.addEmpty(200);
            pool.rolls = 2;
        })
    })

    event.modify('mryh:research_institute_gun', loot => {
        loot.addPool(pool => {
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "emxarms:emx_scgraves" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "applied_armorer:moritz_shotgun_sg914" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "helldiver2:sg225_breaker" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "cyber_armorer:m2038_the_headsman" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "bluearchive:hoshino" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "cyber_armorer:carnage" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "bf1:wex" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "bf1:ef46" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "emxarms:emx_enforcer" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "tacz:aa12" });

            pool.addEmpty(50);
            pool.rolls = 2;
        })
    })

    event.modify('mryh:research_institute_gun2', loot => {
        loot.addPool(pool => {
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "helldiver2:ar23c_liberator" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "bluearchive:shiroko" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "gfl2:191" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "mpworld:ls30" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "mpworld:ls" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "gfl2:g11_5" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "tacz:scar_h" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "helldiver2:ar23_liberator" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "mpworld:ls30b" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "mpworld:ls22b" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "bluearchive:azusa" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "mpworld:ls22" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "tacz:m16a1" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "create_armorer:rifle_assult_crane" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "mpworld:ls45" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "tacz:sks_tactical" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "bf1:m1916" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "mpworld:545p" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "mpworld:22r" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "bluearchive:yukino" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "tacz:scar_l" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "tacz:type_81" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "tacz:aug" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "gfl2:wanderingstars" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "bluearchive:toki" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "tacz:m16a4" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "bf1:vg15" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "immersive_armorer:assult_rifle" });
            pool.addItem('tacz:modern_kinetic_gun').weight(12).nbt({ GunId: "helldiver2:ar23p_liberator" });
            pool.addEmpty(150);
            pool.rolls = 2;
        })
    })

    event.modify('mryh:research_institute_gun3', loot => {
        loot.addPool(pool => {
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "cyber_armorer:g58_dian" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "cyber_armorer:g58_dian_yinglong" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "applied_armorer:niklas_smg_freedom" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "emxarms:emx_expel32" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "create_armorer:smg_auto_crank" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "emxarms:emx_umx32" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "immersive_armorer:standard_rail_smg_mk1" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "emxarms:emx_expel32se" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "cyber_armorer:saratoga" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "gfl2:lioncubs" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "bluearchive:fuuka" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "bf1:vp1915" });

            pool.addEmpty(50);
            pool.rolls = 2;
        })
    })
})


// 定义物品列表
let POOLS_research_institute = {
    // 无幸运（0-1）
    noLuck: [

    ],
    // 幸运2+（2-5）
    luck2: [
        "max_armory:lamellar_armor_boots",
        "zombie_extreme:juggernaut_suit_chestplate",
        "zombie_extreme:juggernaut_suit_boots",
        "max_armory:mingguang_armor_chestplate",
        "apocalypsenow:spec_ops_leggings",
        "apocalypsenow:spec_ops_chestplate",
        "apocalypsenow:spec_ops_boots",
        "zombie_extreme:exo_suit_chestplate",
        "zombie_extreme:exo_suit_leggings",
        "apocalypsenow:army_leggings",
        "apocalypsenow:army_helmet",
        "zombie_extreme:juggernaut_suit_leggings",
        "zombie_extreme:juggernaut_suit_helmet",
        "zombie_extreme:exo_suit_boots"
    ],
    // 幸运6+
    luck6: [
        "apocalypsenow:juggernaut_boots",
        "apocalypsenow:bombsquad_helmet",
        "apocalypsenow:bombsquad_leggings",
        "apocalypsenow:bombsquad_chestplate",
        "apocalypsenow:bombsquad_boots",
        "zombiekit:bomb_helmet",
        "zombiekit:bomb_leggings",
        "zombiekit:bomb_chestplate",
        "zombiekit:bomb_boots",
        "apocalypsenow:juggernaut_helmet",
        "apocalypsenow:juggernaut_leggings",
        "apocalypsenow:juggernaut_chestplate"
    ],
    // 困难模式
    hardMode: [
        "spore:tumor",
        "spore:fried_wing_membrane",
        "spore:frozen_tumor",
        "spore:fungal_burger",
        "spore:sicken_tumor",
        "spore:roasted_tumor",
        "spore:r_wing",
        "spore:wing_membrane",
        "spore:calcified_tumor"
    ],
    // TAG
    TagMode: [
        "spore:reinforced_syringe",
        "spore:skeletal_syringe",
        "spore:drowned_syringe",
        "spore:charred_syringe",
        "spore:compound_plate",
        "spore:rotten_syringe",
        "spore:compound",
        "spore:bezerk_syringe",
        "spore:calcified_syringe",
        "spore:hardening_agent",
        "spore:sharpening_agent",
        "spore:integrating_agent",
        "spore:toxic_syringe",
        "spore:mutation_syringe",
        "spore:circuit_board",
        "spore:ice_canister",
        "spore:biomass",
        "spore:scanner",
        "spore:surgery_table",
        "spore:syringe",
        "spore:vampiric_syringe"
    ],
    // 枪械
    gunIds: {
        noLuck: [

        ],
        luck2: [
            "gfl2:97",
            "tacz:hk416d",
            "emxarms:emx_rivet",
            "cyber_armorer:ajax_pit_bull",
            "cyber_armorer:ajax_moron_labe",
            "cyber_armorer:ajax",
            "cyber_armorer:copperhead",
            "emxarms:emx_umx57h",
            "mpworld:ls30c",
            "bf1:lewis",
            "emxarms:emx_mk951l",
            "gfl2:skulla",
            "tacz:qbz_95",
            "gfl2:g36",
            "tacz:m320",
            "bluearchive:momoi",
            "tacz:ak47",
            "bf1:f_faust",
            "create_armorer:special_melee_wrench",
            "bf1:mg0815",
            "tacz:m249",
            "bc:ak50",
            "bf1:mhgl",
            "mpworld:sc15",
            "helldiver2:r36_eruptor",
            "create_armorer:special_melee_atomic",
            "tacz:rpk",
            "applied_armorer:special_melee_task_manager",
            "tacz:mk14",
            "tacz:hk_g3",
            "bluearchive:serika",
            "applied_armorer:niklas_lever_vigenere",
            "mpworld:te_01",
            "applied_armorer:moritz_rifle_ar77",
            "emxarms:emx_mk951r",
            "gfl2:95_5",
            "gfl2:416a5",
            "tacz:rpg7",
            "mpworld:ak338l",
            "mpworld:ak338lb",
            "create_armorer:mg_platemag_flywheel",
            "bc:qjz171",
            "emxarms:emx_umx57",
            "bc:spg9",
            "helldiver2:jar5_dominator",
            "tacz:m4a1"
        ],
        luck6: [
            "gfl2:ls06",
            "emxarms:emx_pulse_al",
            "emxarms:emx_mk951r_ba",
            "bluearchive:hina",
            "emxarms:emx_mg57",
            "emxarms:emx_mk951lmg",
            "emxarms:emx_mg90",
            "dawnhunting:tcpl_vector45ar",
            "emxarms:emx_draftsman",
            "emxarms:emx_expel32_lb",
            "emxarms:emx_umx32_koei",
            "gfl2:stm",
            "emxarms:emx_expel32se_ba",
            "dawnhunting:tcpl_vector45",
            "emxarms:emx_kund50ex_al",
            "emxarms:emx_pulse_dl1",
            "cyber_armorer:copperhead_psalm",
            "emxarms:emx_pulse_dl2",
            "trisdyna:fl3e",
            "trisdyna:fl00",
            "trisdyna:fl3e_sd",
            "emxarms:emx_pulse_sc",
            "emxarms:emx_mk951l_ba",
            "emxarms:emx_rivet_gw",
            "trisdyna:ch104",
            "emxarms:emx_draftsman_ev1",
            "trisdyna:iras",
            "trisdyna:fpc211",
            "gfl2:mindhunter",
            "helldiver2:sg225ie_breaker",
            "emxarms:emx_draftsman_ev"
        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
    // 子弹
    ammoIds: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
    // 配件
    attachmentId: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
};


LootJS.modifiers(e => {
    e.addLootTableModifier(/.*mryh:chests\/research_institute.*/)
        .randomChance(1)
        .apply(context => {
            let BASE_CHANCE = 0.17;
            let luck = context.getLuck();
            let difficulty = context.level.difficulty.id;
            let player = context.player;
            if (!player) return
            let hasTagMode = player?.tags.contains('difficult_level_4');
            let { finalLootPool, chanceMultiplier } = getFinalLootPool(POOLS_research_institute, luck, difficulty, player);
            if (finalLootPool.length === 0) return;
            let finalChance = Math.min(BASE_CHANCE * chanceMultiplier, 1.0);
            let rolls = getRandomNumber(1, 3);
            for (let i = 0; i < rolls; i++) {
                let randomIndex = Math.floor(Math.random() * finalLootPool.length);
                let selectedItem = finalLootPool[randomIndex];
                let entry = createLootEntry(context, selectedItem, POOLS_research_institute, luck, difficulty, hasTagMode, finalChance);
                context.addLoot(entry);
            }
        });
});