// 警察局战利品表
ServerEvents.chestLootTables(event => {
    event.modify('mryh:police_station_1', loot => {
        loot.addPool(pool => {
            pool.addItem('tacz:modern_kinetic_gun').weight(20).nbt({ GunId: "helldiver2:ar23_liberator" });
            pool.addItem('tacz:modern_kinetic_gun').weight(20).nbt({ GunId: "mpworld:ls" });
            pool.addItem('tacz:modern_kinetic_gun').weight(20).nbt({ GunId: "tacz:scar_h" });
            pool.addItem('tacz:modern_kinetic_gun').weight(20).nbt({ GunId: "bf1:vg15" });
            pool.addItem('tacz:modern_kinetic_gun').weight(20).nbt({ GunId: "bluearchive:azusa" });
            pool.addItem('tacz:modern_kinetic_gun').weight(20).nbt({ GunId: "bluearchive:shiroko" });
            pool.addItem('apocalypsenow:electric_baton').weight(25);
            pool.addItem('zombie_extreme:police_baton').weight(20);
            pool.addItem('apocalypsenow:night_stick').weight(15);
            pool.addItem('minecraft:paper').weight(18).count([1, 4]);
            pool.addItem('minecraft:redstone').weight(22).count([1, 3]);
            pool.addItem('minecraft:iron_nugget').weight(20).count([1, 2]);
            pool.addItem('minecraft:iron_ingot').weight(25).count([1, 4]);
            pool.addItem('minecraft:copper_ingot').weight(15).count([1, 3]);
            pool.addItem('minecraft:lapis_lazuli').weight(20).count([1, 2]);
            pool.addItem('minecraft:bone').weight(22).count([1, 4]);
            pool.addItem('minecraft:bone_meal').weight(18).count([1, 3]);
            pool.addItem('minecraft:slime_ball').weight(25).count([1, 2]);
            pool.addItem('zombiekit:rubber').weight(15).count([1, 4]);
            pool.addItem('zombiekit:camphor').weight(20).count([1, 3]);
            pool.addItem('minecraft:charcoal').weight(22).count([1, 2]);
            pool.addItem('minecraft:stick').weight(18).count([1, 4]);
            pool.addItem('apocalypsenow:scrapmetal').weight(25).count([1, 3]);
            pool.addItem('minecraft:porkchop').weight(15).count([1, 2]);
            pool.addItem('minecraft:mutton').weight(20).count([1, 4]);
            pool.addItem('minecraft:cod').weight(22).count([1, 3]);
            pool.addItem('minecraft:chicken').weight(18).count([1, 2]);
            pool.addItem('apocalypsenow:electrical_scrap').weight(25).count([1, 4]);
            pool.addItem('minecraft:leather').weight(15).count([1, 3]);
            pool.addItem('minecraft:raw_gold').weight(20).count([1, 2]);
            pool.addItem('minecraft:raw_iron').weight(22).count([1, 4]);
            pool.addItem('minecraft:raw_copper').weight(18).count([1, 3]);
            pool.addItem('create:raw_zinc').weight(25).count([1, 2]);
            pool.addItem('minecraft:sugar').weight(15).count([1, 4]);
            pool.addItem('minecraft:amethyst_shard').weight(20).count([1, 3]);
            pool.addItem('minecraft:diamond').weight(22).count([1, 2]);
            pool.addItem('apocalypsenow:money').weight(18).count([1, 4]);
            pool.addItem('minecraft:gold_ingot').weight(25).count([1, 3]);
            pool.addItem('minecraft:gold_nugget').weight(15).count([1, 2]);
            pool.addItem('zombiekit:alcohol').weight(20).count([1, 4]);
            pool.addItem('minecraft:glowstone_dust').weight(22).count([1, 3]);
            pool.addItem('minecraft:carrot').weight(18).count([1, 2]);
            pool.addItem('minecraft:feather').weight(25).count([1, 4]);
            pool.addItem('minecraft:emerald').weight(15).count([1, 3]);
            pool.addItem('apocalypsenow:textilethread').weight(20).count([1, 2]);
            pool.addItem('minecraft:ink_sac').weight(22).count([1, 4]);
            pool.addItem('apocalypsenow:engineering_parts').weight(18).count([1, 3]);
            pool.addItem('minecraft:beef').weight(25).count([1, 2]);
            pool.addItem('minecraft:rabbit').weight(15).count([1, 4]);
            pool.addItem('minecraft:beetroot').weight(20).count([1, 3]);
            pool.addItem('minecraft:flint').weight(22).count([1, 2]);
            pool.addItem('minecraft:coal').weight(18).count([1, 4]);
            pool.addItem('minecraft:blaze_rod').weight(25).count([1, 3]);
            pool.addItem('minecraft:gunpowder').weight(15).count([1, 2]);
            pool.addItem('minecraft:quartz').weight(20).count([1, 4]);
            pool.addItem('minecraft:book').weight(22).count([1, 3]);
            pool.addItem('apocalypsenow:plastic').weight(18).count([1, 2]);
            pool.addItem('apocalypsenow:plasticplate').weight(25).count([1, 4]);
            pool.addEmpty(200);
            pool.rolls = 5
        })
    })

    event.modify('mryh:police_station_2', loot => {
        loot.addPool(pool => {
            pool.addItem('tacz:modern_kinetic_gun').weight(15).nbt({ GunId: "bluearchive:yukino" });
            pool.addItem('tacz:modern_kinetic_gun').weight(20).nbt({ GunId: "create_armorer:rifle_assult_crane" });
            pool.addItem('tacz:modern_kinetic_gun').weight(25).nbt({ GunId: "bluearchive:azusa" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "helldiver2:ar23c_liberator" });
            pool.addItem('tacz:modern_kinetic_gun').weight(22).nbt({ GunId: "bluearchive:shiroko" });
            pool.addItem('tacz:modern_kinetic_gun').weight(17).nbt({ GunId: "helldiver2:ar23_liberator" });
            pool.addItem('tacz:modern_kinetic_gun').weight(23).nbt({ GunId: "bf1:vg15" });
            pool.addItem('tacz:modern_kinetic_gun').weight(19).nbt({ GunId: "gfl2:wanderingstars" });
            pool.addItem('tacz:modern_kinetic_gun').weight(24).nbt({ GunId: "gfl2:191" });
            pool.addItem('tacz:modern_kinetic_gun').weight(16).nbt({ GunId: "tacz:m16a1" });
            pool.addItem('tacz:modern_kinetic_gun').weight(21).nbt({ GunId: "tacz:m16a4" });
            pool.addItem('tacz:modern_kinetic_gun').weight(26).nbt({ GunId: "tacz:aug" });
            pool.addItem('tacz:modern_kinetic_gun').weight(17).nbt({ GunId: "mpworld:ls" });
            pool.addItem('tacz:modern_kinetic_gun').weight(22).nbt({ GunId: "tacz:sks_tactical" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "mpworld:22r" });
            pool.addItem('tacz:modern_kinetic_gun').weight(23).nbt({ GunId: "tacz:scar_h" });
            pool.addItem('tacz:modern_kinetic_gun').weight(19).nbt({ GunId: "mpworld:ls22" });
            pool.addItem('tacz:modern_kinetic_gun').weight(24).nbt({ GunId: "bf1:m1916" });
            pool.addItem('tacz:modern_kinetic_gun').weight(20).nbt({ GunId: "immersive_armorer:assult_rifle" });
            pool.addItem('tacz:modern_kinetic_gun').weight(25).nbt({ GunId: "helldiver2:ar23p_liberator" });
            pool.addItem('tacz:modern_kinetic_gun').weight(18).nbt({ GunId: "mpworld:ls30b" });
            pool.addItem('tacz:modern_kinetic_gun').weight(22).nbt({ GunId: "mpworld:ls45" });
            pool.addItem('tacz:modern_kinetic_gun').weight(19).nbt({ GunId: "tacz:scar_l" });
            pool.addItem('tacz:modern_kinetic_gun').weight(23).nbt({ GunId: "mpworld:ls22b" });
            pool.addItem('tacz:modern_kinetic_gun').weight(17).nbt({ GunId: "gfl2:g11_5" });
            pool.addItem('tacz:modern_kinetic_gun').weight(21).nbt({ GunId: "mpworld:545p" });
            pool.addItem('tacz:modern_kinetic_gun').weight(20).nbt({ GunId: "bluearchive:toki" });
            pool.addItem('apocalypsenow:swat_chestplate').weight(25);
            pool.addItem('apocalypsenow:swat_leggings').weight(20);
            pool.addItem('zombie_extreme:swat_suit_helmet').weight(18);
            pool.addItem('zombie_extreme:swat_suit_chestplate').weight(22);
            pool.addItem('zombie_extreme:swat_suit_leggings').weight(17);
            pool.addItem('apocalypsenow:swat_helmet').weight(23);
            pool.addItem('apocalypsenow:sheriff_helmet').weight(19);
            pool.addItem('apocalypsenow:swatriotcontrol_boots').weight(24);
            pool.addItem('apocalypsenow:swat_boots').weight(18);
            pool.addItem('apocalypsenow:police_shield').weight(21);
            pool.addItem('zombie_extreme:police_suit_chestplate').weight(19);
            pool.addItem('zombie_extreme:police_suit_helmet').weight(25);
            pool.addItem('marbledsarsenal:riot_armor_helmet').weight(17);
            pool.addItem('marbledsarsenal:riot_armor_boots').weight(22);
            pool.addItem('apocalypsenow:swatriotcontrol_helmet').weight(20);
            pool.addItem('apocalypsenow:swatriotcontrol_chestplate').weight(18);
            pool.addItem('marbledsarsenal:riot_armor_leggings').weight(23);
            pool.addItem('marbledsarsenal:riot_armor_chestplate').weight(19);
            pool.addItem('apocalypsenow:police_chestplate').weight(24);
            pool.addItem('apocalypsenow:police_helmet').weight(18);
            pool.addItem('apocalypsenow:swatriotcontrol_leggings').weight(21);
            pool.addItem('apocalypsenow:police_leggings').weight(19);
            pool.addItem('apocalypsenow:police_boots').weight(25);
            pool.addItem('zombie_extreme:swat_suit_boots').weight(17);
            pool.addItem('zombie_extreme:police_baton').weight(20);
            pool.addItem('apocalypsenow:night_stick').weight(22);
            pool.addItem('apocalypsenow:electric_baton').weight(18);
            pool.addItem('apocalypsenow:riot_shield').weight(23);
            pool.addEmpty(200);
            pool.rolls = 5
        })
    })

    event.modify('mryh:police_station_3', loot => {
        loot.addPool(pool => {
            pool.addItem('gold_ingot')
        })
    })

    event.modify('mryh:police_station_4', loot => {
        loot.addPool(pool => {
            pool.addItem('minecraft:diamond')
        })
    })
})


// 定义物品列表
let POOLS_police_station = {
    // 无幸运（0-1）
    noLuck: [

    ],
    // 幸运2+（2-5）
    luck2: [
        "tacz:modern_kinetic_gun",
        "tacz:modern_kinetic_gun"
    ],
    // 幸运6+
    luck6: [

    ],
    // 困难模式
    hardMode: [
        "tacz:modern_kinetic_gun",
        "tacz:modern_kinetic_gun"
    ],
    // TAG
    TagMode: [
        "zombiekit:standard_tactical_boots",
        "zombiekit:standard_tactical_chestplate",
        "zombiekit:standard_tactical_leggings",
        "zombiekit:standard_tactical_helmet",
        "apocalypsenow:jet_pilot_helmet",
        "apocalypsenow:jet_pilot_leggings",
        "apocalypsenow:jet_pilot_chestplate",
        "apocalypsenow:jet_pilot_boots"
    ],
    // 枪械
    gunIds: {
        noLuck: [
            "bluearchive:hoshino",
            "cyber_armorer:m2038_the_headsman",
            "emxarms:emx_scgraves",
            "emxarms:emx_enforcer",
            "helldiver2:sg225_breaker",
            "bf1:wex",
            "tacz:aa12",
            "bf1:ef46",
            "cyber_armorer:carnage",
            "applied_armorer:moritz_shotgun_sg914"
        ],
        luck2: [
            "gfl2:skulla",
            "bluearchive:momoi",
            "bluearchive:serika",
            "emxarms:emx_umx57h",
            "cyber_armorer:ajax_pit_bull",
            "emxarms:emx_rivet",
            "mpworld:ls30c",
            "cyber_armorer:ajax_moron_labe",
            "emxarms:emx_mk951l",
            "applied_armorer:moritz_rifle_ar77",
            "tacz:hk416d",
            "mpworld:mas49",
            "create_armorer:sniper_semi_clockwork",
            "tacz:qbz_95",
            "gfl2:g36",
            "tacz:ak47",
            "tacz:hk_g3",
            "gfl2:97",
            "emxarms:emx_mk951r",
            "gfl2:95_5",
            "gfl2:416a5",
            "emxarms:emx_umx57",
            "tacz:m4a1",
            "mpworld:sc15",
            "mpworld:te_01",
            "cyber_armorer:ajax",
            "cyber_armorer:copperhead",
            "applied_armorer:niklas_lever_vigenere",
            "tacz:mk14"
        ],
        luck6: [
            "emxarms:emx_pulse_dl2",
            "trisdyna:fl00",
            "gfl2:ls06",
            "trisdyna:fl3e_sd",
            "trisdyna:fl3e",
            "emxarms:emx_expel32_lb",
            "emxarms:emx_umx32_koei",
            "emxarms:emx_expel32se_ba",
            "dawnhunting:tcpl_vector45",
            "emxarms:emx_pulse_dl1",
            "emxarms:emx_kund50ex_al",
            "emxarms:emx_pulse_sc"
        ],
        hardMode: [
            "bf1:vp1915",
            "cyber_armorer:saratoga",
            "applied_armorer:niklas_smg_freedom",
            "create_armorer:smg_auto_crank",
            "emxarms:emx_umx32",
            "immersive_armorer:standard_rail_smg_mk1",
            "cyber_armorer:g58_dian",
            "emxarms:emx_expel32se",
            "emxarms:emx_expel32",
            "bluearchive:fuuka",
            "cyber_armorer:g58_dian_yinglong",
            "gfl2:lioncubs"
        ],
        TagMode: [
            "bf1:tg1918",
            "helldiver2:r63_diligence",
            "tacz:m700",
            "tacz:ai_awp",
            "mpworld:ssg08",
            "bf1:martini",
            "immersive_armorer:railgun",
            "tacz:m95",
            "bf1:man_m95",
            "tacz:m107",
            "helldiver2:r63cs_diligence",
            "mpworld:ssg08b"
        ]
    },
    // 子弹
    ammoIds: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
    // 配件
    attachmentId: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
};


LootJS.modifiers(e => {
    e.addLootTableModifier(/.*mryh:chests\/police_station.*/)
        .randomChance(1)
        .apply(context => {
            let BASE_CHANCE = 0.17;
            let luck = context.getLuck();
            let difficulty = context.level.difficulty.id;
            let player = context.player;
            if (!player) return
            let hasTagMode = player?.tags.contains('difficult_level_4');
            let { finalLootPool, chanceMultiplier } = getFinalLootPool(POOLS_police_station, luck, difficulty, player);
            if (finalLootPool.length === 0) return;
            let finalChance = Math.min(BASE_CHANCE * chanceMultiplier, 1.0);
            let rolls = getRandomNumber(1, 3);
            for (let i = 0; i < rolls; i++) {
                let randomIndex = Math.floor(Math.random() * finalLootPool.length);
                let selectedItem = finalLootPool[randomIndex];
                let entry = createLootEntry(context, selectedItem, POOLS_police_station, luck, difficulty, hasTagMode, finalChance);
                context.addLoot(entry);
            }
        });
});