// 图书馆战利品表
ServerEvents.chestLootTables(event => {
    event.modify('mryh:library_1', loot => {
        loot.addPool(pool => {
            pool.addItem('copper_ingot').weight(50).count([5, 20]);;
            pool.addItem('constructionwand:iron_wand').weight(30);
            pool.addItem('minecraft:spyglass').weight(20);
            pool.addItem('minecraft:chain').weight(60).count([1, 3]);
            pool.addItem('apocalypsenow:plasticplate').weight(45).count([1, 2]);
            pool.addItem('minecraft:lantern').weight(35).count([1, 1]);
            pool.addItem('minecraft:paper').weight(70).count([5, 12]);
            pool.addItem('minecraft:lapis_lazuli').weight(65).count([3, 8]);
            pool.addItem('minecraft:iron_ingot').weight(55).count([1, 4]);
            pool.addItem('minecraft:book').weight(50).count([1, 2]);
            pool.addItem('apocalypsenow:engineering_parts').weight(30).count([1, 1]);
            pool.addItem('apocalypsenow:electrical_scrap').weight(75).count([2, 6]);
            pool.addItem('minecraft:bone_meal').weight(80).count([4, 10]);
            pool.addItem('minecraft:torch').weight(85).count([8, 16]);
            pool.addItem('minecraft:redstone_torch').weight(40).count([2, 5]);
            pool.addItem('minecraft:name_tag').weight(25).count([1, 1]);
            pool.addItem('minecraft:copper_ingot').weight(60).count([1, 3]);
            pool.addItem('minecraft:sugar').weight(65).count([2, 5]);
            pool.addItem('minecraft:campfire').weight(45).count([1, 2]);
            pool.addItem('apocalypsenow:textilethread').weight(55).count([1, 3]);
            pool.addItem('apocalypsenow:scrapmetal').weight(70).count([2, 5]);
            pool.addItem('minecraft:phantom_membrane').weight(20).count([1, 1]);
            pool.addItem('minecraft:flint_and_steel').weight(35).count([1, 1]);
            pool.addEmpty(200);
            pool.rolls = 5;
        })
    })

    event.modify('mryh:library_2', loot => {
        loot.addPool(pool => {
            pool.addItem('iron_ingot').weight(50).count([5, 20]);
            pool.addItem('supplementaries:key').weight(30);
            pool.addItem('minecraft:clock').weight(20).count([1, 1]);
            pool.addItem('zombiekit:blueprint_of_mortar').weight(25).count([1, 1]);
            pool.addItem('zombiekit:blueprint_of_landmine').weight(25).count([1, 1]);
            pool.addItem('zombiekit:blueprint_of_drone').weight(20).count([1, 1]);
            pool.addItem('zombiekit:blueprint_of_steel').weight(30).count([1, 1]);
            pool.addItem('zombiekit:blueprint_of_dye').weight(35).count([1, 1]);
            pool.addItem('zombiekit:blueprint_of_heavy_machine_gun').weight(15).count([1, 1]);
            pool.addItem('zombiekit:blueprint_of_riot').weight(15).count([1, 1]);
            pool.addItem('minecraft:soul_torch').weight(70).count([6, 12]);
            pool.addItem('minecraft:prismarine_shard').weight(50).count([2, 5]);
            pool.addItem('minecraft:prismarine_crystals').weight(45).count([1, 4]);
            pool.addItem('minecraft:ender_pearl').weight(30).count([1, 2]);
            pool.addItem('zombie_extreme:syringe_adrenaline').weight(25).count([1, 1]);
            pool.addItem('minecraft:crying_obsidian').weight(20).count([1, 1]);
            pool.addItem('minecraft:zombie_head').weight(10).count([1, 1]);
            pool.addItem('minecraft:tnt').weight(20).count([1, 2]);
            pool.addItem('cold_sweat:waterskin').weight(35).count([1, 1]);
            pool.addItem('cold_sweat:chameleon_molt').weight(30).count([1, 1]);
            pool.addItem('apocalypsenow:polyesterthread').weight(55).count([1, 3]);
            pool.addItem('apocalypsenow:polyester').weight(50).count([1, 2]);
            pool.addItem('minecraft:gold_ingot').weight(40).count([1, 3]);
            pool.addItem('minecraft:copper_block').weight(25).count([1, 1]);
            pool.addItem('minecraft:skeleton_skull').weight(10).count([1, 1]);
            pool.addItem('refinedstorage:basic_processor').weight(30).count([1, 2]);
            pool.addItem('refinedstorage:raw_basic_processor').weight(40).count([1, 3]);
            pool.addItem('refinedstorage:raw_improved_processor').weight(25).count([1, 2]);
            pool.addItem('refinedstorage:raw_advanced_processor').weight(15).count([1, 1]);
            pool.addItem('refinedstorage:improved_processor').weight(20).count([1, 1]);
            pool.addItem('refinedstorage:advanced_processor').weight(10).count([1, 1]);
            pool.addItem('zombie_extreme:syringe_night_vision').weight(25).count([1, 1]);
            pool.addEmpty(200);
            pool.rolls = 5;
        })
    })

    event.modify('mryh:library_3', loot => {
        loot.addPool(pool => {
            pool.addItem('gold_ingot')
        })
    })

    event.modify('mryh:library_4', loot => {
        loot.addPool(pool => {
            pool.addItem('minecraft:diamond')
        })
    })
})


// 定义物品列表
let POOLS_library = {
    // 无幸运（0-1）
    noLuck: [

    ],
    // 幸运2+（2-5）
    luck2: [
        "zombie_extreme:pill_night_vision",
        "zombie_extreme:acid_bottle",
        "zombie_extreme:batteries",
        "minecraft:redstone_block",
        "refinedstorage:silicon",
        "apocalypsenow:kevlar",
        "apocalypsenow:kevlarthread",
        "apocalypsenow:armorplate",
        "minecraft:emerald",
        "minecraft:golden_apple",
        "minecraft:blaze_rod",
        "minecraft:ghast_tear",
        "naturescompass:naturescompass",
        "minecraft:enchanting_table",
        "minecraft:diamond",
        "zombie_extreme:ruby"
    ],
    // 幸运6+
    luck6: [
        "minecraft:gold_block",
        "minecraft:emerald_block",
        "scalinghealth:power_crystal_shard",
        "zombie_extreme:energy_battery",
        "minecraft:ender_eye",
        "minecraft:netherite_scrap",
        "zombiekit:energy_rod",
        "nameless_trinkets:spider_legs",
        "nameless_trinkets:sleeping_pills",
        "editenchanting:enchantment_edit_table"
    ],
    // 困难模式
    hardMode: [

    ],
    // TAG
    TagMode: [
        "mryh:medium_permession"
    ],
    // 枪械
    gunIds: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
    // 子弹
    ammoIds: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
    // 配件
    attachmentId: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
};


LootJS.modifiers(e => {
    e.addLootTableModifier(/.*mryh:chests\/library.*/)
        .randomChance(1)
        .apply(context => {
            let BASE_CHANCE = 0.17;
            let luck = context.getLuck();
            let difficulty = context.level.difficulty.id;
            let player = context.player;
            if (!player) return
            let hasTagMode = player?.tags.contains('difficult_level_4');
            let { finalLootPool, chanceMultiplier } = getFinalLootPool(POOLS_library, luck, difficulty, player);
            if (finalLootPool.length === 0) return;
            let finalChance = Math.min(BASE_CHANCE * chanceMultiplier, 1.0);
            let rolls = getRandomNumber(1, 3);
            for (let i = 0; i < rolls; i++) {
                let randomIndex = Math.floor(Math.random() * finalLootPool.length);
                let selectedItem = finalLootPool[randomIndex];
                let entry = createLootEntry(context, selectedItem, POOLS_library, luck, difficulty, hasTagMode, finalChance);
                context.addLoot(entry);
            }
        });
});