// 沉浸工厂战利品
ServerEvents.chestLootTables(event => {
    event.modify('mryh:immersiveengineering_factory_1', loot => {
        loot.addPool(pool => {
            pool.addItem('minecraft:lapis_lazuli').weight(15).count([1, 4]);
            pool.addItem('immersiveengineering:dust_nickel').weight(20).count([1, 3]);
            pool.addItem('immersiveengineering:plate_silver').weight(18).count([1, 2]);
            pool.addItem('immersiveengineering:dust_aluminum').weight(22).count([1, 4]);
            pool.addItem('minecraft:copper_ingot').weight(17).count([1, 3]);
            pool.addItem('immersiveengineering:wire_copper').weight(25).count([1, 2]);
            pool.addItem('immersiveengineering:nugget_lead').weight(16).count([1, 4]);
            pool.addItem('minecraft:iron_ingot').weight(21).count([1, 3]);
            pool.addItem('minecraft:slime_ball').weight(19).count([1, 2]);
            pool.addItem('minecraft:carrot').weight(23).count([1, 4]);
            pool.addItem('zombiekit:bile_jar').weight(15).count([1, 3]);
            pool.addItem('minecraft:feather').weight(20).count([1, 2]);
            pool.addItem('minecraft:emerald').weight(22).count([1, 4]);
            pool.addItem('apocalypsenow:textilethread').weight(18).count([1, 3]);
            pool.addItem('minecraft:paper').weight(25).count([1, 2]);
            pool.addItem('minecraft:redstone').weight(16).count([1, 4]);
            pool.addItem('minecraft:amethyst_shard').weight(21).count([1, 3]);
            pool.addItem('minecraft:sugar').weight(19).count([1, 2]);
            pool.addItem('create:raw_zinc').weight(23).count([1, 4]);
            pool.addItem('minecraft:raw_copper').weight(17).count([1, 3]);
            pool.addItem('zombiekit:potion_jar').weight(20).count([1, 2]);
            pool.addItem('zombiekit:molotov_cocktail').weight(22).count([1, 4]);
            pool.addItem('zombiekit:alcohol').weight(18).count([1, 3]);
            pool.addItem('immersiveengineering:dust_gold').weight(25).count([1, 2]);
            pool.addItem('minecraft:gold_nugget').weight(16).count([1, 4]);
            pool.addItem('minecraft:gold_ingot').weight(21).count([1, 3]);
            pool.addItem('immersiveengineering:dust_steel').weight(19).count([1, 2]);
            pool.addItem('apocalypsenow:money').weight(23).count([1, 4]);
            pool.addItem('minecraft:diamond').weight(17).count([1, 3]);
            pool.addItem('zombiekit:iron_wire').weight(20).count([1, 2]);
            pool.addItem('immersiveengineering:dust_iron').weight(22).count([1, 4]);
            pool.addItem('minecraft:iron_nugget').weight(18).count([1, 3]);
            pool.addItem('zombiekit:high_temperature_fuel_canister').weight(25).count([1, 2]);
            pool.addItem('minecraft:bone_meal').weight(16).count([1, 4]);
            pool.addItem('minecraft:bone').weight(21).count([1, 3]);
            pool.addItem('zombiekit:firecracker').weight(19).count([1, 2]);
            pool.addItem('minecraft:chicken').weight(23).count([1, 4]);
            pool.addItem('apocalypsenow:electrical_scrap').weight(17).count([1, 3]);
            pool.addItem('minecraft:leather').weight(20).count([1, 2]);
            pool.addItem('zombiekit:saltpeter_bucket').weight(22).count([1, 4]);
            pool.addItem('immersiveengineering:dust_saltpeter').weight(18).count([1, 3]);
            pool.addItem('minecraft:raw_gold').weight(25).count([1, 2]);
            pool.addItem('minecraft:raw_iron').weight(16).count([1, 4]);
            pool.addItem('immersiveengineering:raw_lead').weight(21).count([1, 3]);
            pool.addItem('minecraft:glowstone_dust').weight(19).count([1, 2]);
            pool.addItem('minecraft:book').weight(23).count([1, 4]);
            pool.addItem('immersiveengineering:ersatz_leather').weight(17).count([1, 3]);
            pool.addItem('apocalypsenow:plastic').weight(20).count([1, 2]);
            pool.addItem('apocalypsenow:plasticplate').weight(22).count([1, 4]);
            pool.addItem('minecraft:ink_sac').weight(18).count([1, 3]);
            pool.addItem('immersiveengineering:seed').weight(25).count([1, 2]);
            pool.addItem('apocalypsenow:engineering_parts').weight(16).count([1, 4]);
            pool.addItem('apocalypsenow:scrapmetal').weight(21).count([1, 3]);
            pool.addItem('immersiveengineering:dust_constantan').weight(19).count([1, 2]);
            pool.addItem('immersiveengineering:ingot_constantan').weight(23).count([1, 4]);
            pool.addItem('minecraft:stick').weight(17).count([1, 3]);
            pool.addItem('minecraft:rabbit').weight(20).count([1, 2]);
            pool.addItem('minecraft:beetroot').weight(22).count([1, 4]);
            pool.addItem('immersiveengineering:wire_electrum').weight(18).count([1, 3]);
            pool.addItem('immersiveengineering:dust_electrum').weight(25).count([1, 2]);
            pool.addItem('minecraft:flint').weight(16).count([1, 4]);
            pool.addItem('minecraft:coal').weight(21).count([1, 3]);
            pool.addItem('immersiveengineering:dust_coke').weight(19).count([1, 2]);
            pool.addItem('minecraft:blaze_rod').weight(23).count([1, 4]);
            pool.addItem('minecraft:gunpowder').weight(17).count([1, 3]);
            pool.addItem('zombiekit:rubber').weight(20).count([1, 2]);
            pool.addItem('zombiekit:camphor').weight(22).count([1, 4]);
            pool.addItem('minecraft:charcoal').weight(18).count([1, 3]);
            pool.addItem('minecraft:beef').weight(25).count([1, 2]);
            pool.addItem('minecraft:porkchop').weight(16).count([1, 4]);
            pool.addItem('minecraft:mutton').weight(21).count([1, 3]);
            pool.addItem('minecraft:cod').weight(19).count([1, 2]);
            pool.addItem('minecraft:quartz').weight(23).count([1, 4]);
            pool.addEmpty(200);
            pool.rolls = 5;
        })
    })

    event.modify('mryh:immersiveengineering_factory_2', loot => {
        loot.addPool(pool => {
            pool.addItem('immersiveengineering:wire_copper').weight(15).count([1, 4]);
            pool.addItem('immersiveengineering:nugget_copper').weight(20).count([1, 3]);
            pool.addItem('immersiveengineering:dust_wood').weight(18).count([1, 2]);
            pool.addItem('immersiveengineering:plate_nickel').weight(22).count([1, 4]);
            pool.addItem('immersiveengineering:dust_nickel').weight(17).count([1, 3]);
            pool.addItem('immersiveengineering:nugget_nickel').weight(25).count([1, 2]);
            pool.addItem('immersiveengineering:ingot_nickel').weight(16).count([1, 4]);
            pool.addItem('immersiveengineering:stick_treated').weight(21).count([1, 3]);
            pool.addItem('immersiveengineering:blastbrick').weight(19).count([1, 2]);
            pool.addItem('immersiveengineering:wire_steel').weight(23).count([1, 4]);
            pool.addItem('immersiveengineering:nugget_steel').weight(18).count([1, 3]);
            pool.addItem('immersiveengineering:dust_steel').weight(25).count([1, 2]);
            pool.addItem('immersiveengineering:stick_steel').weight(17).count([1, 4]);
            pool.addItem('immersiveengineering:plate_steel').weight(20).count([1, 3]);
            pool.addItem('immersiveengineering:ingot_uranium').weight(22).count([1, 2]);
            pool.addItem('immersiveengineering:component_iron').weight(18).count([1, 4]);
            pool.addItem('immersiveengineering:plate_iron').weight(23).count([1, 3]);
            pool.addItem('immersiveengineering:stick_iron').weight(19).count([1, 2]);
            pool.addItem('immersiveengineering:dust_iron').weight(25).count([1, 4]);
            pool.addItem('immersiveengineering:plate_lead').weight(16).count([1, 3]);
            pool.addItem('immersiveengineering:dust_lead').weight(21).count([1, 2]);
            pool.addItem('immersiveengineering:nugget_lead').weight(18).count([1, 4]);
            pool.addItem('immersiveengineering:wire_lead').weight(22).count([1, 3]);
            pool.addItem('immersiveengineering:ingot_lead').weight(17).count([1, 2]);
            pool.addItem('immersiveengineering:plate_copper').weight(23).count([1, 4]);
            pool.addItem('immersiveengineering:dust_copper').weight(19).count([1, 3]);
            pool.addItem('immersiveengineering:ingot_silver').weight(20).count([1, 2]);
            pool.addItem('immersiveengineering:nugget_silver').weight(24).count([1, 4]);
            pool.addItem('immersiveengineering:dust_silver').weight(18).count([1, 3]);
            pool.addItem('immersiveengineering:plate_silver').weight(22).count([1, 2]);
            pool.addItem('immersiveengineering:ingot_aluminum').weight(17).count([1, 4]);
            pool.addItem('immersiveengineering:wire_aluminum').weight(21).count([1, 3]);
            pool.addItem('immersiveengineering:nugget_aluminum').weight(19).count([1, 2]);
            pool.addItem('immersiveengineering:dust_aluminum').weight(23).count([1, 4]);
            pool.addItem('immersiveengineering:stick_aluminum').weight(18).count([1, 3]);
            pool.addItem('immersiveengineering:plate_aluminum').weight(20).count([1, 2]);
            pool.addItem('immersiveengineering:connector_redstone').weight(22).count([1, 4]);
            pool.addItem('immersiveengineering:clinker_brick').weight(19).count([1, 3]);
            pool.addItem('immersiveengineering:clinker_brick_sill').weight(17).count([1, 2]);
            pool.addItem('immersiveengineering:plate_gold').weight(21).count([1, 4]);
            pool.addItem('immersiveengineering:dust_gold').weight(18).count([1, 3]);
            pool.addItem('immersiveengineering:nugget_uranium').weight(23).count([1, 2]);
            pool.addItem('immersiveengineering:dust_uranium').weight(16).count([1, 4]);
            pool.addItem('immersiveengineering:plate_uranium').weight(20).count([1, 3]);
            pool.addItem('immersiveengineering:ingot_steel').weight(22).count([1, 2]);
            pool.addItem('immersiveengineering:nugget_constantan').weight(18).count([1, 4]);
            pool.addItem('immersiveengineering:ingot_constantan').weight(19).count([1, 3]);
            pool.addItem('immersiveengineering:creosote_bucket').weight(20).count([1, 2]);
            pool.addItem('immersiveengineering:concrete').weight(23).count([1, 4]);
            pool.addItem('immersiveengineering:cokebrick').weight(17).count([1, 3]);
            pool.addItem('immersiveengineering:coal_coke').weight(21).count([1, 2]);
            pool.addItem('immersiveengineering:coke').weight(18).count([1, 4]);
            pool.addItem('immersiveengineering:dust_coke').weight(24).count([1, 3]);
            pool.addItem('immersiveengineering:plate_electrum').weight(19).count([1, 2]);
            pool.addItem('immersiveengineering:dust_electrum').weight(20).count([1, 4]);
            pool.addItem('immersiveengineering:nugget_electrum').weight(22).count([1, 3]);
            pool.addItem('immersiveengineering:raw_lead').weight(18).count([1, 2]);
            pool.addItem('immersiveengineering:raw_uranium').weight(21).count([1, 4]);
            pool.addItem('immersiveengineering:dust_sulfur').weight(19).count([1, 3]);
            pool.addItem('immersiveengineering:dust_saltpeter').weight(20).count([1, 2]);
            pool.addItem('immersiveengineering:slag_brick').weight(22).count([1, 4]);
            pool.addItem('immersiveengineering:slag').weight(18).count([1, 3]);
            pool.addItem('immersiveengineering:electron_tube').weight(23).count([1, 2]);
            pool.addItem('immersiveengineering:light_bulb').weight(17).count([1, 4]);
            pool.addItem('immersiveengineering:circuit_board').weight(20).count([1, 3]);
            pool.addItem('immersiveengineering:component_electronic').weight(24).count([1, 2]);
            pool.addItem('immersiveengineering:ingot_electrum').weight(19).count([1, 4]);
            pool.addItem('immersiveengineering:wire_electrum').weight(21).count([1, 3]);
            pool.addItem('immersiveengineering:raw_aluminum').weight(18).count([1, 2]);
            pool.addItem('immersiveengineering:raw_silver').weight(22).count([1, 4]);
            pool.addItem('immersiveengineering:raw_nickel').weight(19).count([1, 3]);
            pool.addItem('immersiveengineering:connector_bundled').weight(20).count([1, 2]);
            pool.addItem('immersiveengineering:ersatz_leather').weight(23).count([1, 4]);
            pool.addItem('immersiveengineering:connector_lv').weight(17).count([1, 3]);
            pool.addItem('immersiveengineering:wirecoil_copper').weight(21).count([1, 2]);
            pool.addItem('immersiveengineering:dust_constantan').weight(18).count([1, 4]);
            pool.addItem('immersiveengineering:hemp_fabric').weight(22).count([1, 3]);
            pool.addItem('immersiveengineering:seed').weight(19).count([1, 2]);
            pool.addItem('immersiveengineering:hemp_fiber').weight(20).count([1, 4]);
            pool.addItem('immersiveengineering:plate_duroplast').weight(24).count([1, 3]);
            pool.addItem('immersiveengineering:plate_constantan').weight(18).count([1, 2]);
            pool.addItem('immersiveengineering:shovel_steel').weight(15);
            pool.addItem('immersiveengineering:hoe_steel').weight(20);
            pool.addItem('immersiveengineering:hammer').weight(25);
            pool.addItem('immersiveengineering:wirecutter').weight(18);
            pool.addItem('immersiveengineering:shield').weight(22);
            pool.addItem('immersiveengineering:axe_steel').weight(17);
            pool.addItem('immersiveengineering:sword_steel').weight(23);
            pool.addItem('immersiveengineering:pickaxe_steel').weight(19);
            pool.addItem('immersiveengineering:capacitor_lv').weight(21);
            pool.addItem('immersiveengineering:screwdriver').weight(16);
            pool.addEmpty(200);
            pool.rolls = 5;
        })
    })

    event.modify('mryh:immersiveengineering_factory_3', loot => {
        loot.addPool(pool => {
            pool.addItem('gold_ingot')
        })
    })

    event.modify('mryh:immersiveengineering_factory_4', loot => {
        loot.addPool(pool => {
            pool.addItem('minecraft:diamond')
        })
    })
})


// 定义物品列表
let POOLS_immersiveengineering_factory = {
    // 无幸运（0-1）
    noLuck: [

    ],
    // 幸运2+（2-5）
    luck2: [
        "zombiekit:fuel_canister",
        "zombiekit:smoke_mortar_shell",
        "zombiekit:potion_jar",
        "zombiekit:baseball_bat",
        "zombiekit:snow_camouflage_dye",
        "zombiekit:molotov_cocktail",
        "zombiekit:iron_wire",
        "zombiekit:napalm_fuel_canister",
        "zombiekit:plastics",
        "zombiekit:chainsaw",
        "zombiekit:mine_layer_mortar_shell",
        "zombiekit:wrench",
        "zombiekit:forest_camouflage_dye",
        "zombiekit:drone_components",
        "zombiekit:smokeless_gunpowder",
        "zombiekit:machine_gun_components",
        "zombiekit:mortar_shell",
        "zombiekit:bile_jar",
        "zombiekit:saltpeter_bucket",
        "zombiekit:desert_camouflage_dye",
        "zombiekit:firecracker",
        "zombiekit:high_temperature_fuel_canister",
        "zombiekit:mortar_components",
        "zombiekit:fire_mortar_shell"
    ],
    // 幸运6+
    luck6: [

    ],
    // 困难模式
    hardMode: [
        "zombie_extreme:lead_plate",
        "zombie_extreme:ignotlead",
        "zombie_extreme:ignot_aluminum",
        "zombie_extreme:tin_plate",
        "zombie_extreme:ignot_tin",
        "zombie_extreme:saw_blade",
        "zombie_extreme:bronze_nugget",
        "zombie_extreme:bronze_wire",
        "zombie_extreme:ignot_bronze",
        "zombie_extreme:raw_aluminum",
        "zombie_extreme:plastic",
        "zombie_extreme:cloth",
        "zombie_extreme:ignot_infected_titan",
        "zombie_extreme:infected_flesh",
        "zombie_extreme:ignot_infected_steel",
        "zombie_extreme:rubber",
        "zombie_extreme:rubber_sheet",
        "zombie_extreme:oil_shale",
        "zombie_extreme:titan_plate",
        "zombie_extreme:titan_nugget",
        "zombie_extreme:ignot_titan",
        "zombie_extreme:steel_bar",
        "zombie_extreme:steel_blade",
        "zombie_extreme:acid_bottle",
        "zombie_extreme:filter",
        "zombie_extreme:energy_battery",
        "zombie_extreme:ruby",
        "zombie_extreme:circuit_diagram",
        "zombie_extreme:batteries",
        "zombie_extreme:raw_tin",
        "zombie_extreme:raw_lead",
        "zombie_extreme:raw_titan",
        "zombie_extreme:raw_plastic",
        "zombie_extreme:steel_plate",
        "zombie_extreme:ignotsteel",
        "zombie_extreme:uranium"
    ],
    // TAG
    TagMode: [
        "zombiekit:blueprint_of_riot",
        "zombiekit:blueprint_of_dye",
        "zombiekit:blueprint_of_drone",
        "zombiekit:blueprint_of_steel",
        "zombiekit:blueprint_of_mortar",
        "zombiekit:blueprint_of_landmine",
        "zombiekit:blueprint_of_heavy_machine_gun"
    ],
    // 枪械
    gunIds: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
    // 子弹
    ammoIds: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
    // 配件
    attachmentId: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
};


LootJS.modifiers(e => {
    e.addLootTableModifier(/.*mryh:chests\/immersiveengineering_factory.*/)
        .randomChance(1)
        .apply(context => {
            let BASE_CHANCE = 0.17;
            let luck = context.getLuck();
            let difficulty = context.level.difficulty.id;
            let player = context.player;
            if (!player) return
            let hasTagMode = player?.tags.contains('difficult_level_4');
            let { finalLootPool, chanceMultiplier } = getFinalLootPool(POOLS_immersiveengineering_factory, luck, difficulty, player);
            if (finalLootPool.length === 0) return;
            let finalChance = Math.min(BASE_CHANCE * chanceMultiplier, 1.0);
            let rolls = getRandomNumber(1, 3);
            for (let i = 0; i < rolls; i++) {
                let randomIndex = Math.floor(Math.random() * finalLootPool.length);
                let selectedItem = finalLootPool[randomIndex];
                let entry = createLootEntry(context, selectedItem, POOLS_immersiveengineering_factory, luck, difficulty, hasTagMode, finalChance);
                context.addLoot(entry);
            }
        });
});