// 医院战利品表
ServerEvents.chestLootTables(event => {
    event.modify('mryh:hospital_1', loot => {
        loot.addPool(pool => {
            pool.addItem('minecraft:amethyst_shard').weight(18).count([1, 3]);
            pool.addItem('minecraft:diamond').weight(25).count([1, 2]);
            pool.addItem('minecraft:iron_nugget').weight(20).count([1, 4]);
            pool.addItem('minecraft:iron_ingot').weight(22).count([1, 3]);
            pool.addItem('minecraft:copper_ingot').weight(15).count([1, 2]);
            pool.addItem('zombie_extreme:pill_against_radiation').weight(20).count([1, 4]);
            pool.addItem('minecraft:lapis_lazuli').weight(22).count([1, 3]);
            pool.addItem('minecraft:bone').weight(18).count([1, 2]);
            pool.addItem('minecraft:bone_meal').weight(25).count([1, 4]);
            pool.addItem('minecraft:charcoal').weight(15).count([1, 3]);
            pool.addItem('minecraft:mutton').weight(20).count([1, 2]);
            pool.addItem('minecraft:cod').weight(22).count([1, 4]);
            pool.addItem('minecraft:chicken').weight(18).count([1, 3]);
            pool.addItem('apocalypsenow:electrical_scrap').weight(25).count([1, 2]);
            pool.addItem('minecraft:leather').weight(15).count([1, 4]);
            pool.addItem('apocalypsenow:rags').weight(20).count([1, 3]);
            pool.addItem('minecraft:raw_gold').weight(22).count([1, 2]);
            pool.addItem('minecraft:raw_iron').weight(18).count([1, 4]);
            pool.addItem('minecraft:carrot').weight(25).count([1, 3]);
            pool.addItem('minecraft:glowstone_dust').weight(15).count([1, 2]);
            pool.addItem('zombie_extreme:syringe_drug').weight(20).count([1, 4]);
            pool.addItem('zombiekit:alcohol').weight(22).count([1, 3]);
            pool.addItem('minecraft:gold_ingot').weight(18).count([1, 2]);
            pool.addItem('minecraft:redstone').weight(25).count([1, 4]);
            pool.addItem('minecraft:paper').weight(15).count([1, 3]);
            pool.addItem('apocalypsenow:textilethread').weight(20).count([1, 2]);
            pool.addItem('minecraft:emerald').weight(22).count([1, 4]);
            pool.addItem('minecraft:feather').weight(18).count([1, 3]);
            pool.addItem('zombie_extreme:syringe_adrenaline').weight(25).count([1, 2]);
            pool.addItem('minecraft:raw_copper').weight(15).count([1, 4]);
            pool.addItem('create:raw_zinc').weight(20).count([1, 3]);
            pool.addItem('zombie_extreme:pill_psycho').weight(22).count([1, 2]);
            pool.addItem('minecraft:sugar').weight(18).count([1, 4]);
            pool.addItem('minecraft:gold_nugget').weight(25).count([1, 3]);
            pool.addItem('apocalypsenow:money').weight(15).count([1, 2]);
            pool.addItem('minecraft:slime_ball').weight(20).count([1, 4]);
            pool.addItem('minecraft:rabbit').weight(22).count([1, 3]);
            pool.addItem('minecraft:beetroot').weight(18).count([1, 2]);
            pool.addItem('minecraft:flint').weight(25).count([1, 4]);
            pool.addItem('minecraft:coal').weight(15).count([1, 3]);
            pool.addItem('minecraft:blaze_rod').weight(20).count([1, 2]);
            pool.addItem('minecraft:gunpowder').weight(22).count([1, 4]);
            pool.addItem('apocalypsenow:cleanrags').weight(18).count([1, 3]);
            pool.addItem('zombiekit:rubber').weight(25).count([1, 2]);
            pool.addItem('zombiekit:camphor').weight(15).count([1, 4]);
            pool.addItem('minecraft:quartz').weight(20).count([1, 3]);
            pool.addItem('minecraft:book').weight(22).count([1, 2]);
            pool.addItem('apocalypsenow:plastic').weight(18).count([1, 4]);
            pool.addItem('apocalypsenow:plasticplate').weight(25).count([1, 3]);
            pool.addItem('minecraft:ink_sac').weight(15).count([1, 2]);
            pool.addItem('zombie_extreme:syringe_night_vision').weight(20).count([1, 4]);
            pool.addItem('zombie_extreme:pill_night_vision').weight(22).count([1, 3]);
            pool.addItem('zombie_extreme:experimental_pill').weight(18).count([1, 2]);
            pool.addItem('apocalypsenow:engineering_parts').weight(25).count([1, 4]);
            pool.addItem('apocalypsenow:scrapmetal').weight(15).count([1, 3]);
            pool.addItem('zombie_extreme:pill_anti_hunger').weight(20).count([1, 2]);
            pool.addItem('minecraft:stick').weight(22).count([1, 4]);
            pool.addItem('minecraft:porkchop').weight(18).count([1, 3]);
            pool.addItem('minecraft:beef').weight(25).count([1, 2]);
            pool.addEmpty(200);
            pool.rolls = 5
        })
    })

    event.modify('mryh:hospital_2', loot => {
        loot.addPool(pool => {
            pool.addItem('apocalypsenow:contamination_suit_blue_leggings').weight(22);
            pool.addItem('apocalypsenow:contamination_suit_blue_helmet').weight(18);
            pool.addItem('apocalypsenow:contamination_suit_blue_chestplate').weight(25);
            pool.addItem('apocalypsenow:hazmat_suit_boots').weight(20);
            pool.addItem('apocalypsenow:hazmat_suit_helmet').weight(15);
            pool.addItem('apocalypsenow:advanced_hazmat_suit_helmet').weight(20);
            pool.addItem('apocalypsenow:advanced_hazmat_suit_chestplate').weight(22);
            pool.addItem('marbledsarsenal:hazmat_armor_leggings').weight(18);
            pool.addItem('zombie_extreme:hazmat_suit_boots').weight(25);
            pool.addItem('marbledsarsenal:hazmat_armor_helmet').weight(20);
            pool.addItem('marbledsarsenal:hazmat_armor_chestplate').weight(15);
            pool.addItem('marbledsarsenal:hazmat_armor_boots').weight(22);
            pool.addItem('apocalypsenow:nurse_leggings').weight(18);
            pool.addItem('zombie_extreme:hazmat_suit_chestplate').weight(25);
            pool.addItem('zombie_extreme:hazmat_suit_helmet').weight(20);
            pool.addItem('zombie_extreme:hazmat_suit_leggings').weight(15);
            pool.addItem('apocalypsenow:nurse_chestplate').weight(22);
            pool.addItem('apocalypsenow:nurse_boots').weight(18);
            pool.addItem('apocalypsenow:level_a_hazmatsuit_leggings').weight(25);
            pool.addItem('apocalypsenow:level_a_hazmatsuit_helmet').weight(20);
            pool.addItem('apocalypsenow:advanced_hazmat_suit_boots').weight(15);
            pool.addItem('apocalypsenow:hazmat_suit_leggings').weight(22);
            pool.addItem('apocalypsenow:contamination_suit_white_helmet').weight(18);
            pool.addItem('apocalypsenow:contamination_suit_white_leggings').weight(25);
            pool.addItem('apocalypsenow:advanced_hazmat_suit_leggings').weight(20);
            pool.addItem('apocalypsenow:level_a_hazmatsuit_boots').weight(15);
            pool.addItem('apocalypsenow:level_a_hazmatsuit_chestplate').weight(22);
            pool.addItem('apocalypsenow:contamination_suit_white_chestplate').weight(18);
            pool.addItem('apocalypsenow:contamination_suit_white_boots').weight(25);
            pool.addItem('apocalypsenow:contamination_suit_green_helmet').weight(20);
            pool.addItem('apocalypsenow:contamination_suit_green_chestplate').weight(15);
            pool.addItem('zombiekit:bandage').weight(22).count([1, 4]);
            pool.addItem('zombiekit:suspicious_drug').weight(18).count([1, 3]);
            pool.addItem('zombiekit:painkiller').weight(25).count([1, 2]);
            pool.addItem('zombie_extreme:syringe_drug').weight(20).count([1, 4]);
            pool.addItem('zombie_extreme:syringe_antidote').weight(15).count([1, 3]);
            pool.addItem('zombie_extreme:syringe_adrenaline').weight(20).count([1, 2]);
            pool.addItem('zombie_extreme:pill_psycho').weight(22).count([1, 4]);
            pool.addItem('minecraft:golden_carrot').weight(18).count([1, 3]);
            pool.addItem('apocalypsenow:antibiotics').weight(25).count([1, 2]);
            pool.addItem('apocalypsenow:bandage').weight(20).count([1, 4]);
            pool.addItem('apocalypsenow:bloodbag').weight(15).count([1, 3]);
            pool.addItem('apocalypsenow:cleanrags').weight(20).count([1, 2]);
            pool.addItem('apocalypsenow:homemadeantibiotics').weight(22).count([1, 4]);
            pool.addItem('apocalypsenow:pain_killers').weight(18).count([1, 3]);
            pool.addItem('zombie_extreme:pill_against_radiation').weight(25).count([1, 2]);
            pool.addItem('zombie_extreme:pill_anti_hunger').weight(20).count([1, 4]);
            pool.addItem('zombie_extreme:pill_night_vision').weight(15).count([1, 3]);
            pool.addItem('mryh:deradiationsickness').weight(20).count([1, 2]);
            pool.addItem('scalinghealth:bandages').weight(22).count([1, 4]);
            pool.addItem('zombie_extreme:bandage').weight(18).count([1, 3]);
            pool.addItem('zombie_extreme:dizziness_pill').weight(25).count([1, 2]);
            pool.addItem('zombie_extreme:experimental_pill').weight(20).count([1, 4]);
            pool.addItem('zombie_extreme:experimental_serum').weight(15).count([1, 3]);
            pool.addItem('apocalypsenow:rags').weight(20).count([1, 2]);
            pool.addEmpty(200);
            pool.rolls = 5
        })
    })

    event.modify('mryh:hospital_3', loot => {
        loot.addPool(pool => {
            pool.addItem('gold_ingot')
        })
    })

    event.modify('mryh:hospital_4', loot => {
        loot.addPool(pool => {
            pool.addItem('minecraft:diamond')
        })
    })
})


// 定义物品列表
let POOLS_hospital = {
    // 无幸运（0-1）
    noLuck: [

    ],
    // 幸运2+（2-5）
    luck2: [
        "scalinghealth:heart_crystal_shard",
        "scalinghealth:heart_crystal",
        "zombiekit:medical_kit",
        "scalinghealth:medkit",
        "apocalypsenow:medicalkit",
        "scalinghealth:power_crystal_shard",
        "scalinghealth:power_crystal",
        "minecraft:golden_apple",
        "minecraft:enchanted_golden_apple",
        "scalinghealth:chance_heart",
        "scalinghealth:cursed_heart",
        "scalinghealth:enchanted_heart",
        "apocalypsenow:suturekit",
        "zombiekit:miracle"
    ],
    // 幸运6+
    luck6: [
        "spore:armor_fragment",
        "spore:armor_plate",
        "spore:sausage",
        "spore:wing_membrane",
        "spore:fiber_stew",
        "spore:r_wing",
        "spore:brain_noodles",
        "spore:corrosive_sack",
        "spore:claw_fragment",
        "spore:heart_kebab",
        "spore:roasted_heart_kebab",
        "spore:fried_wing_membrane",
        "spore:living_core",
        "spore:milky_sack",
        "spore:hardened_bind",
        "spore:nerves",
        "spore:plated_muscle",
        "spore:cerebrum",
        "spore:vigil_eye_soup",
        "spore:altered_spleen",
        "spore:fleshy_claw",
        "spore:mutated_heart",
        "spore:mutated_fiber",
        "spore:sickle_fragment",
        "spore:calcified_tumor",
        "spore:spine_fragment",
        "spore:spine",
        "spore:tumor",
        "spore:alveolic_sack",
        "spore:tendons",
        "spore:fleshy_bone",
        "spore:bile_tumor",
        "spore:claw",
        "spore:frozen_tumor",
        "spore:fungal_burger",
        "spore:sicken_tumor",
        "spore:roasted_tumor"
    ],
    // 困难模式
    hardMode: [
        "marbledsarsenal:medical_combat_helmet",
        "marbledsarsenal:medical_olive_combat_helmet",
        "marbledsarsenal:black_plate_carrier_heavy",
        "marbledsarsenal:olive_plate_carrier_heavy",
        "marbledsarsenal:swat_armor_boots",
        "marbledsarsenal:desert_military_armor_helmet",
        "marbledsarsenal:black_juggernaut_armor_boots",
        "marbledsarsenal:black_juggernaut_armor_helmet",
        "marbledsarsenal:olive_juggernaut_armor_chestplate",
        "marbledsarsenal:un_combat_helmet",
        "marbledsarsenal:riot_armor_helmet",
        "marbledsarsenal:riot_armor_chestplate",
        "marbledsarsenal:desert_military_armor_boots",
        "marbledsarsenal:olive_juggernaut_armor_boots",
        "marbledsarsenal:olive_combat_helmet",
        "marbledsarsenal:winter_military_armor_chestplate",
        "marbledsarsenal:winter_military_armor_boots",
        "marbledsarsenal:olive_juggernaut_armor_leggings",
        "marbledsarsenal:black_juggernaut_armor_chestplate",
        "marbledsarsenal:swat_armor_leggings",
        "marbledsarsenal:riot_armor_boots",
        "marbledsarsenal:olive_plate_carrier_light",
        "marbledsarsenal:medical_un_combat_helmet",
        "marbledsarsenal:swat_armor_helmet",
        "marbledsarsenal:combat_helmet",
        "marbledsarsenal:swat_armor_chestplate",
        "marbledsarsenal:riot_armor_leggings",
        "marbledsarsenal:winter_military_armor_helmet",
        "marbledsarsenal:olive_juggernaut_armor_helmet",
        "marbledsarsenal:black_juggernaut_armor_leggings",
        "marbledsarsenal:black_plate_carrier_light",
        "marbledsarsenal:winter_military_armor_leggings",
        "marbledsarsenal:desert_military_armor_chestplate"
    ],
    // TAG
    TagMode: [

    ],
    // 枪械
    gunIds: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
    // 子弹
    ammoIds: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
    // 配件
    attachmentId: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
};


LootJS.modifiers(e => {
    e.addLootTableModifier(/.*mryh:chests\/hospital.*/)
        .randomChance(1)
        .apply(context => {
            let BASE_CHANCE = 0.17;
            let luck = context.getLuck();
            let difficulty = context.level.difficulty.id;
            let player = context.player;
            if (!player) return
            let hasTagMode = player?.tags.contains('difficult_level_4');
            let { finalLootPool, chanceMultiplier } = getFinalLootPool(POOLS_hospital, luck, difficulty, player);
            if (finalLootPool.length === 0) return;
            let finalChance = Math.min(BASE_CHANCE * chanceMultiplier, 1.0);
            let rolls = getRandomNumber(1, 3);
            for (let i = 0; i < rolls; i++) {
                let randomIndex = Math.floor(Math.random() * finalLootPool.length);
                let selectedItem = finalLootPool[randomIndex];
                let entry = createLootEntry(context, selectedItem, POOLS_hospital, luck, difficulty, hasTagMode, finalChance);
                context.addLoot(entry);
            }
        });
});