// 消防站战利品表
ServerEvents.chestLootTables(event => {
    event.modify('mryh:fire_station_1', loot => {
        loot.addPool(pool => {
            pool.addItem('marbledsarsenal:katana').weight(20);
            pool.addItem('zombie_extreme:fireaxe').weight(25);
            pool.addItem('cold_sweat:goat_fur_pants').weight(15);
            pool.addItem('cold_sweat:goat_fur_cap').weight(20);
            pool.addItem('cold_sweat:goat_fur_parka').weight(25);
            pool.addItem('marbledsarsenal:medical_helmet_cm6m_gas_mask').weight(15);
            pool.addItem('modern_structures:crowbar').weight(20);
            pool.addItem('apocalypsenow:wooden_fire_axe').weight(25);
            pool.addItem('zombiekit:netherite_crowbar').weight(15);
            pool.addItem('apocalypsenow:textilethread').weight(22).count([1, 4]);
            pool.addItem('minecraft:paper').weight(18).count([1, 3]);
            pool.addItem('minecraft:iron_nugget').weight(20).count([1, 2]);
            pool.addItem('minecraft:iron_ingot').weight(25).count([1, 4]);
            pool.addItem('minecraft:copper_ingot').weight(15).count([1, 3]);
            pool.addItem('minecraft:lapis_lazuli').weight(20).count([1, 2]);
            pool.addItem('minecraft:bone').weight(22).count([1, 4]);
            pool.addItem('minecraft:bone_meal').weight(18).count([1, 3]);
            pool.addItem('minecraft:slime_ball').weight(25).count([1, 2]);
            pool.addItem('minecraft:blaze_rod').weight(15).count([1, 4]);
            pool.addItem('minecraft:gunpowder').weight(20).count([1, 3]);
            pool.addItem('cold_sweat:goat_fur').weight(22).count([1, 2]);
            pool.addItem('zombiekit:rubber').weight(18).count([1, 4]);
            pool.addItem('zombiekit:camphor').weight(25).count([1, 3]);
            pool.addItem('minecraft:chicken').weight(15).count([1, 2]);
            pool.addItem('minecraft:cod').weight(20).count([1, 4]);
            pool.addItem('marbledsapi:raw_steel').weight(22).count([1, 3]);
            pool.addItem('apocalypsenow:electrical_scrap').weight(18).count([1, 2]);
            pool.addItem('minecraft:leather').weight(25).count([1, 4]);
            pool.addItem('minecraft:raw_gold').weight(15).count([1, 3]);
            pool.addItem('minecraft:raw_iron').weight(20).count([1, 2]);
            pool.addItem('minecraft:raw_copper').weight(22).count([1, 4]);
            pool.addItem('create:raw_zinc').weight(18).count([1, 3]);
            pool.addItem('minecraft:sugar').weight(25).count([1, 2]);
            pool.addItem('minecraft:amethyst_shard').weight(15).count([1, 4]);
            pool.addItem('minecraft:redstone').weight(20).count([1, 3]);
            pool.addItem('minecraft:diamond').weight(22).count([1, 2]);
            pool.addItem('apocalypsenow:money').weight(18).count([1, 4]);
            pool.addItem('marbledsapi:steel_sheet').weight(25).count([1, 3]);
            pool.addItem('minecraft:gold_ingot').weight(15).count([1, 2]);
            pool.addItem('minecraft:gold_nugget').weight(20).count([1, 4]);
            pool.addItem('zombiekit:alcohol').weight(22).count([1, 3]);
            pool.addItem('minecraft:glowstone_dust').weight(18).count([1, 2]);
            pool.addItem('minecraft:carrot').weight(25).count([1, 4]);
            pool.addItem('minecraft:feather').weight(15).count([1, 3]);
            pool.addItem('minecraft:emerald').weight(20).count([1, 2]);
            pool.addItem('minecraft:stick').weight(22).count([1, 4]);
            pool.addItem('minecraft:charcoal').weight(18).count([1, 3]);
            pool.addItem('minecraft:mutton').weight(25).count([1, 2]);
            pool.addItem('minecraft:porkchop').weight(15).count([1, 4]);
            pool.addItem('minecraft:beef').weight(20).count([1, 3]);
            pool.addItem('minecraft:rabbit').weight(22).count([1, 2]);
            pool.addItem('minecraft:beetroot').weight(18).count([1, 4]);
            pool.addItem('minecraft:flint').weight(25).count([1, 3]);
            pool.addItem('minecraft:coal').weight(15).count([1, 2]);
            pool.addItem('marbledsarsenal:rubber').weight(20).count([1, 4]);
            pool.addItem('minecraft:quartz').weight(22).count([1, 3]);
            pool.addItem('minecraft:book').weight(18).count([1, 2]);
            pool.addItem('minecraft:rabbit_hide').weight(25).count([1, 4]);
            pool.addItem('cold_sweat:chameleon_molt').weight(15).count([1, 3]);
            pool.addItem('apocalypsenow:plastic').weight(20).count([1, 2]);
            pool.addItem('apocalypsenow:plasticplate').weight(22).count([1, 4]);
            pool.addItem('minecraft:ink_sac').weight(18).count([1, 3]);
            pool.addItem('apocalypsenow:engineering_parts').weight(25).count([1, 2]);
            pool.addItem('apocalypsenow:scrapmetal').weight(15).count([1, 4]);
            pool.addEmpty(200);
            pool.rolls = 5;
        })
    })

    event.modify('mryh:fire_station_2', loot => {
        loot.addPool(pool => {
            pool.addItem('apocalypsenow:fire_figther_chestplate').weight(20);
            pool.addItem('cold_sweat:goat_fur_boots').weight(25);
            pool.addItem('cold_sweat:hoglin_hooves').weight(15);
            pool.addItem('cold_sweat:hoglin_hide').weight(20);
            pool.addItem('minecraft:leather_chestplate').weight(25);
            pool.addItem('minecraft:leather_helmet').weight(15);
            pool.addItem('minecraft:leather_leggings').weight(20);
            pool.addItem('zombiekit:crowbar').weight(25);
            pool.addItem('zombiekit:netherite_crowbar').weight(15);
            pool.addItem('cold_sweat:hoglin_headpiece').weight(20);
            pool.addItem('cold_sweat:goat_fur_pants').weight(25);
            pool.addItem('cold_sweat:goat_fur_cap').weight(15);
            pool.addItem('cold_sweat:goat_fur_parka').weight(20);
            pool.addItem('apocalypsenow:wooden_fire_axe').weight(25);
            pool.addItem('apocalypsenow:crowbar').weight(15);
            pool.addItem('zombie_extreme:crowbar').weight(20);
            pool.addItem('modern_structures:crowbar').weight(25);
            pool.addItem('minecraft:leather_boots').weight(15);
            pool.addItem('apocalypsenow:red_crowbar').weight(20);
            pool.addItem('apocalypsenow:fire_figther_helmet').weight(25);
            pool.addItem('apocalypsenow:fire_figther_leggings').weight(15);
            pool.addItem('apocalypsenow:fire_figther_boots').weight(20);
            pool.addItem('zombiekit:fire_axe').weight(25);
            pool.addItem('apocalypsenow:fire_axe').weight(15);
            pool.addItem('zombie_extreme:fireaxe').weight(20);
            pool.addItem('cold_sweat:hoglin_tunic').weight(25);
            pool.addItem('cold_sweat:hoglin_trousers').weight(15);
            pool.addItem('minecraft:leather').weight(22).count([1, 4]);
            pool.addItem('cold_sweat:chameleon_molt').weight(18).count([1, 3]);
            pool.addItem('minecraft:rabbit_hide').weight(20).count([1, 2]);
            pool.addItem('cold_sweat:goat_fur').weight(25).count([1, 4]);
            pool.addEmpty(200);
            pool.rolls = 5;
        })
    })

    event.modify('mryh:fire_station_3', loot => {
        loot.addPool(pool => {
            pool.addItem('gold_ingot')
        })
    })

    event.modify('mryh:fire_station_4', loot => {
        loot.addPool(pool => {
            pool.addItem('minecraft:diamond')
        })
    })
})


// 定义物品列表
let POOLS_fire_station = {
    // 无幸运（0-1）
    noLuck: [

    ],
    // 幸运2+（2-5）
    luck2: [
        "immersive_aircraft:rotary_cannon",
        "immersive_aircraft:improved_landing_gear",
        "immersive_aircraft:industrial_gears",
        "immersive_aircraft:enhanced_propeller",
        "immersive_aircraft:gyrodyne",
        "immersive_aircraft:quadrocopter",
        "immersive_aircraft:engine",
        "immersive_aircraft:biplane",
        "immersive_aircraft:sturdy_pipes",
        "marbledsapi:steel_ingot",
        "marbledsapi:steel_sheet",
        "marbledsapi:steel_block",
        "marbledsapi:hardened_steel_ingot",
        "marbledsapi:hardened_steel_sheet",
        "marbledsapi:raw_steel",
        "marbledsapi:rubber",
        "immersive_aircraft:airship",
        "immersive_aircraft:sail",
        "immersive_aircraft:gyroscope",
        "immersive_aircraft:boiler",
        "immersive_aircraft:heavy_crossbow",
        "immersive_aircraft:propeller",
        "immersive_aircraft:bomb_bay",
        "immersive_aircraft:hull_reinforcement",
        "immersive_aircraft:hull",
        "immersive_aircraft:telescope"
    ],
    // 幸运6+
    luck6: [
        "immersive_aircraft:eco_engine",
        "immersive_aircraft:steel_boiler",
        "immersive_aircraft:warship",
        "immersive_aircraft:cargo_airship",
        "immersive_aircraft:nether_engine"
    ],
    // 困难模式
    hardMode: [
        "marbledsarsenal:fire_axe",
        "marbledsarsenal:crowbar",
        "marbledsarsenal:helmet_cm8m_gas_mask",
        "marbledsarsenal:cm8m_gas_mask",
        "marbledsarsenal:helmet_cm7m_gas_mask",
        "marbledsarsenal:cm7m_gas_mask",
        "marbledsarsenal:helmet_cm6m_gas_mask",
        "marbledsarsenal:cm6m_gas_mask",
        "marbledsarsenal:bone_saw",
        "marbledsarsenal:medical_un_helmet_cm7m_gas_mask",
        "marbledsarsenal:medical_un_helmet_cm6m_gas_mask",
        "marbledsarsenal:un_helmet_cm6m_gas_mask",
        "marbledsarsenal:un_helmet_cm8m_gas_mask",
        "marbledsarsenal:un_helmet_cm7m_gas_mask",
        "marbledsarsenal:white_gp5_gas_mask",
        "marbledsarsenal:gas_mask_filter",
        "marbledsarsenal:combat_helmet",
        "marbledsarsenal:medical_helmet_cm8m_gas_mask",
        "marbledsarsenal:medical_helmet_cm7m_gas_mask",
        "marbledsarsenal:medical_helmet_cm6m_gas_mask",
        "marbledsarsenal:medical_un_helmet_cm8m_gas_mask",
        "marbledsarsenal:medical_olive_helmet_cm8m_gas_mask",
        "marbledsarsenal:medical_olive_helmet_cm7m_gas_mask",
        "marbledsarsenal:medical_olive_helmet_cm6m_gas_mask",
        "marbledsarsenal:olive_helmet_cm6m_gas_mask",
        "marbledsarsenal:olive_helmet_cm8m_gas_mask",
        "marbledsarsenal:olive_helmet_cm7m_gas_mask",
        "marbledsarsenal:tomahawk",
        "marbledsarsenal:tanto",
        "marbledsarsenal:stop_sign",
        "marbledsarsenal:sledgehammer",
        "marbledsarsenal:rubber",
        "marbledsarsenal:pipe_wrench",
        "marbledsarsenal:modern_axe",
        "marbledsarsenal:machete",
        "marbledsarsenal:katana"
    ],
    // TAG
    TagMode: [
        "modern_structures:tactic_leggings",
        "modern_structures:batlleaxe",
        "mcore:steel_ingot",
        "mcore:steel_nugget",
        "mcore:titanium_ingot",
        "mcore:titanium_sheet",
        "mcore:raw_titanium",
        "marbledsarsenal:black_gp5_gas_mask",
        "marbledsarsenal:armor_plate",
        "modern_structures:tactic_helmet",
        "modern_structures:tactic_boots",
        "modern_structures:tactic_chestplate",
        "spore:gas_mask",
        "modern_structures:tacticshield"
    ],
    // 枪械
    gunIds: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
    // 子弹
    ammoIds: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
    // 配件
    attachmentId: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
};


LootJS.modifiers(e => {
    e.addLootTableModifier(/.*mryh:chests\/fire_station.*/)
        .randomChance(1)
        .apply(context => {
            let BASE_CHANCE = 0.17;
            let luck = context.getLuck();
            let difficulty = context.level.difficulty.id;
            let player = context.player;
            if (!player) return
            let hasTagMode = player?.tags.contains('difficult_level_4');
            let { finalLootPool, chanceMultiplier } = getFinalLootPool(POOLS_fire_station, luck, difficulty, player);
            if (finalLootPool.length === 0) return;
            let finalChance = Math.min(BASE_CHANCE * chanceMultiplier, 1.0);
            let rolls = getRandomNumber(1, 3);
            for (let i = 0; i < rolls; i++) {
                let randomIndex = Math.floor(Math.random() * finalLootPool.length);
                let selectedItem = finalLootPool[randomIndex];
                let entry = createLootEntry(context, selectedItem, POOLS_fire_station, luck, difficulty, hasTagMode, finalChance);
                context.addLoot(entry);
            }
        });
});