// 火电厂战利品表
ServerEvents.chestLootTables(event => {
    event.modify('mryh:fire_factory_1', loot => {
        loot.addPool(pool => {
            pool.addItem('copper_ingot').weight(30).count([4, 10])
            pool.addItem('minecraft:golden_pickaxe').weight(15);
            pool.addItem('minecraft:iron_shovel').weight(20);
            pool.addItem('minecraft:stone_shovel').weight(30);
            pool.addItem('minecraft:golden_shovel').weight(25);
            pool.addItem('minecraft:flint_and_steel').weight(35);
            pool.addItem('minecraft:bone_meal').weight(40).count([4, 10]);
            pool.addItem('supplementaries:suspicious_gravel_bricks').weight(40).count([1, 3]);
            pool.addItem('supplementaries:ash_brick').weight(45).count([2, 5]);
            pool.addItem('supplementaries:flint_block').weight(50).count([1, 2]);
            pool.addItem('minecraft:emerald_ore').weight(8).count([1, 1]);
            pool.addItem('minecraft:tripwire_hook').weight(55).count([2, 4]);
            pool.addItem('minecraft:string').weight(65).count([3, 8]);
            pool.addItem('minecraft:paper').weight(60).count([5, 12]);
            pool.addItem('minecraft:brick').weight(50).count([2, 6]);
            pool.addItem('minecraft:redstone_ore').weight(25).count([1, 2]);
            pool.addItem('minecraft:infested_stone_bricks').weight(30).count([1, 3]);
            pool.addItem('minecraft:infested_mossy_stone_bricks').weight(25).count([1, 2]);
            pool.addItem('minecraft:infested_cracked_stone_bricks').weight(25).count([1, 2]);
            pool.addItem('minecraft:infested_chiseled_stone_bricks').weight(20).count([1, 1]);
            pool.addItem('minecraft:honey_block').weight(20).count([1, 1]);
            pool.addItem('minecraft:honeycomb').weight(40).count([2, 5]);
            pool.addItem('minecraft:warped_stem').weight(35).count([2, 4]);
            pool.addItem('minecraft:acacia_log').weight(45).count([3, 6]);
            pool.addItem('minecraft:gold_ore').weight(15).count([1, 2]);
            pool.addItem('minecraft:gold_nugget').weight(55).count([4, 9]);
            pool.addItem('minecraft:gold_ingot').weight(30).count([1, 3]);
            pool.addItem('minecraft:bone').weight(65).count([3, 7]);
            pool.addItem('minecraft:lapis_ore').weight(20).count([1, 2]);
            pool.addItem('minecraft:daylight_detector').weight(15).count([1, 1]);
            pool.addItem('minecraft:smithing_table').weight(10).count([1, 1]);
            pool.addItem('minecraft:copper_ingot').weight(50).count([2, 5]);
            pool.addItem('minecraft:copper_ore').weight(35).count([1, 3]);
            pool.addItem('minecraft:copper_block').weight(15).count([1, 1]);
            pool.addItem('minecraft:iron_ingot').weight(40).count([1, 4]);
            pool.addItem('minecraft:iron_nugget').weight(60).count([4, 9]);
            pool.addItem('minecraft:anvil').weight(5).count([1, 1]);
            pool.addItem('minecraft:raw_copper_block').weight(20).count([1, 1]);
            pool.addItem('minecraft:raw_copper').weight(45).count([2, 5]);
            pool.addItem('minecraft:raw_iron_block').weight(20).count([1, 1]);
            pool.addItem('minecraft:raw_iron').weight(50).count([2, 6]);
            pool.addItem('minecraft:birch_log').weight(40).count([3, 6]);
            pool.addItem('minecraft:blue_ice').weight(10).count([1, 1]);
            pool.addItem('minecraft:mushroom_stem').weight(30).count([1, 3]);
            pool.addItem('minecraft:infested_cobblestone').weight(35).count([2, 4]);
            pool.addItem('minecraft:infested_deepslate').weight(25).count([1, 2]);
            pool.addItem('minecraft:end_stone').weight(30).count([2, 5]);
            pool.addItem('minecraft:stick').weight(80).count([8, 16]);
            pool.addItem('minecraft:chipped_anvil').weight(8).count([1, 1]);
            pool.addItem('minecraft:hay_block').weight(35).count([1, 3]);
            pool.addItem('minecraft:suspicious_gravel').weight(25).count([1, 2]);
            pool.addItem('minecraft:suspicious_sand').weight(25).count([1, 2]);
            pool.addItem('minecraft:ice').weight(25).count([2, 4]);
            pool.addItem('minecraft:spruce_log').weight(40).count([3, 6]);
            pool.addItem('minecraft:sea_lantern').weight(12).count([1, 1]);
            pool.addItem('minecraft:deepslate_coal_ore').weight(35).count([2, 5]);
            pool.addItem('minecraft:deepslate_redstone_ore').weight(25).count([1, 2]);
            pool.addItem('minecraft:deepslate_iron_ore').weight(30).count([1, 3]);
            pool.addItem('minecraft:dark_oak_log').weight(40).count([3, 6]);
            pool.addItem('minecraft:soul_sand').weight(45).count([3, 7]);
            pool.addItem('minecraft:blaze_rod').weight(20).count([1, 2]);
            pool.addItem('minecraft:coal').weight(70).count([5, 12]);
            pool.addItem('minecraft:coal_ore').weight(40).count([2, 5]);
            pool.addItem('minecraft:furnace').weight(25).count([1, 2]);
            pool.addItem('minecraft:flint').weight(60).count([3, 8]);
            pool.addItem('minecraft:basalt').weight(40).count([2, 6]);
            pool.addItem('minecraft:glowstone').weight(35).count([2, 5]);
            pool.addItem('minecraft:feather').weight(55).count([4, 9]);
            pool.addItem('minecraft:redstone_lamp').weight(15).count([1, 1]);
            pool.addItem('minecraft:redstone_block').weight(20).count([1, 2]);
            pool.addItem('minecraft:mangrove_roots').weight(35).count([2, 5]);
            pool.addItem('minecraft:mangrove_log').weight(40).count([3, 6]);
            pool.addItem('minecraft:amethyst_shard').weight(25).count([1, 3]);
            pool.addItem('minecraft:nether_quartz_ore').weight(30).count([2, 5]);
            pool.addItem('minecraft:nether_brick').weight(45).count([3, 7]);
            pool.addItem('minecraft:nether_gold_ore').weight(25).count([1, 3]);
            pool.addItem('minecraft:jungle_log').weight(40).count([3, 6]);
            pool.addItem('minecraft:book').weight(50).count([2, 4]);
            pool.addItem('minecraft:packed_ice').weight(15).count([1, 2]);
            pool.addItem('minecraft:piston').weight(20).count([1, 2]);
            pool.addItem('minecraft:muddy_mangrove_roots').weight(30).count([2, 4]);
            pool.addItem('minecraft:oak_log').weight(45).count([3, 6]);
            pool.addItem('apocalypsenow:plasticplate').weight(40).count([1, 3]);
            pool.addItem('apocalypsenow:scrapmetal').weight(50).count([2, 5]);
            pool.addItem('apocalypsenow:oil_canister').weight(30).count([1, 2]);
            pool.addItem('apocalypsenow:armorplate').weight(15).count([1, 1]);
            pool.addItem('apocalypsenow:papertrash').weight(55).count([4, 10]);
            pool.addItem('minecraft:netherrack').weight(65).count([5, 12]);
            pool.addItem('minecraft:quartz').weight(50).count([3, 7]);
            pool.addEmpty(200);
            pool.rolls = 5;
        })
    })

    event.modify('mryh:fire_factory_2', loot => {
        loot.addPool(pool => {
            pool.addItem('iron_ingot').weight(30).count([4, 9])
            pool.addItem('minecraft:diamond_pickaxe').weight(8);
            pool.addItem('minecraft:spyglass').weight(25);
            pool.addItem('minecraft:deepslate_gold_ore').weight(20).count([1, 2]);
            pool.addItem('minecraft:deepslate_emerald_ore').weight(12).count([1, 1]);
            pool.addItem('minecraft:gold_block').weight(5).count([1, 1]);
            pool.addItem('minecraft:raw_gold').weight(35).count([2, 5]);
            pool.addItem('minecraft:lapis_lazuli').weight(20).count([4, 9]);
            pool.addItem('minecraft:budding_amethyst').weight(10).count([1, 1]);
            pool.addItem('minecraft:amethyst_block').weight(15).count([1, 2]);
            pool.addItem('minecraft:lapis_block').weight(8).count([1, 1]);
            pool.addItem('minecraft:lightning_rod').weight(30).count([1, 2]);
            pool.addItem('minecraft:charcoal').weight(60).count([5, 12]);
            pool.addItem('minecraft:damaged_anvil').weight(10).count([1, 1]);
            pool.addItem('minecraft:deepslate_copper_ore').weight(40).count([2, 5]);
            pool.addItem('minecraft:deepslate_lapis_ore').weight(25).count([1, 3]);
            pool.addItem('minecraft:magma_block').weight(35).count([2, 5]);
            pool.addItem('minecraft:dried_kelp_block').weight(30).count([2, 4]);
            pool.addItem('minecraft:sticky_piston').weight(20).count([1, 2]);
            pool.addItem('minecraft:blast_furnace').weight(15).count([1, 1]);
            pool.addItem('minecraft:raw_gold_block').weight(12).count([1, 1]);
            pool.addItem('minecraft:diamond_ore').weight(8).count([1, 1]);
            pool.addItem('minecraft:iron_ore').weight(45).count([3, 6]);
            pool.addItem('minecraft:blackstone').weight(40).count([3, 7]);
            pool.addItem('minecraft:obsidian').weight(18).count([1, 3]);
            pool.addItem('minecraft:slime_block').weight(15).count([1, 1]);
            pool.addItem('minecraft:crying_obsidian').weight(12).count([1, 1]);
            pool.addItem('minecraft:deepslate_diamond_ore').weight(6).count([1, 1]);
            pool.addEmpty(200);
            pool.rolls = 5;
        })
    })

    event.modify('mryh:fire_factory_3', loot => {
        loot.addPool(pool => {
            pool.addItem('gold_ingot')
        })
    })

    event.modify('mryh:fire_factory_4', loot => {
        loot.addPool(pool => {
            pool.addItem('endrem:wither_eye').weight(100);
        })
    })
})

// 定义物品列表
let POOLS_fire_factory = {
    // 无幸运（0-1）
    noLuck: [

    ],
    // 幸运2+（2-5）
    luck2: [
        "apocalypsenow:dynamite",
        "apocalypsenow:pipebomb",
        "apocalypsenow:improvisedbomb",
        "apocalypsenow:coktelmolotov_2",
        "apocalypsenow:cocktelmolotov_3",
        "apocalypsenow:coktelmolotovv",
        "create:brass_sheet",
        "create:cogwheel",
        "zombiekit:snow_camouflage_dye",
        "apocalypsenow:improviseddynamiteroll",
        "apocalypsenow:improvisedgrenade",
        "create:sail_frame",
        "apocalypsenow:dynamite_roll",
        "create:white_sail",
        "create:crushed_raw_silver",
        "create:crushed_raw_zinc",
        "create:crushed_raw_nickel",
        "zombiekit:crude_nitrate",
        "zombiekit:fibre",
        "zombiekit:latex",
        "zombiekit:desert_camouflage_dye",
        "create:copper_sheet",
        "createaddition:copper_rod",
        "createaddition:iron_wire",
        "create:iron_sheet",
        "createaddition:iron_rod",
        "createaddition:gold_wire",
        "create:golden_sheet",
        "createaddition:gold_rod",
        "zombiekit:alcohol",
        "create:brass_hand",
        "create:brass_casing",
        "createaddition:brass_rod",
        "createaddition:copper_wire",
        "createaddition:zinc_sheet"
    ],
    // 幸运6+
    luck6: [
        "waystones:warp_stone",
        "zombiekit:saltpeter_soil",
        "zombiekit:saltpeter_bucket",
        "zombiekit:saltpeter",
        "zombiekit:hydrogen_nitrate",
        "zombiekit:sulfur",
        "create:crushed_raw_gold",
        "create:crushed_raw_uranium",
        "create:crushed_raw_iron",
        "create:propeller",
        "create:super_glue",
        "create:weighted_ejector",
        "zombiekit:cloth",
        "create:large_cogwheel",
        "zombiekit:plastics",
        "create:gearbox",
        "create:railway_casing",
        "zombiekit:nitrocellulose",
        "create:rose_quartz",
        "zombiekit:special_ceramics",
        "zombiekit:death_bat",
        "zombiekit:quartz_sand",
        "create:electron_tube",
        "createaddition:electrum_ingot",
        "createaddition:electrum_wire",
        "createaddition:electrum_sheet",
        "createaddition:electrum_rod",
        "create:belt_connector",
        "create:shaft",
        "zombiekit:forest_camouflage_dye",
        "waystones:waystone",
        "zombiekit:camphor",
        "zombiekit:rubber",
        "create:crushed_raw_aluminum",
        "create:crushed_raw_copper",
        "create:crushed_raw_lead"
    ],
    // 困难模式
    hardMode: [
        "minecraft:end_crystal",
        "minecraft:diamond",
        "minecraft:emerald_block",
        "minecraft:emerald",
        "minecraft:diamond_block"
    ],
    // TAG
    TagMode: [
        "minecraft:end_crystal",
        "minecraft:diamond",
        "minecraft:emerald_block",
        "minecraft:emerald",
        "minecraft:diamond_block"
    ],
    // 枪械
    gunIds: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
    // 子弹
    ammoIds: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
    // 配件
    attachmentId: {
        noLuck: [

        ],
        luck2: [

        ],
        luck6: [

        ],
        hardMode: [

        ],
        TagMode: [

        ]
    },
};


LootJS.modifiers(e => {
    e.addLootTableModifier(/.*mryh:chests\/fire_factory.*/)
        .randomChance(1)
        .apply(context => {
            let BASE_CHANCE = 0.17;
            let luck = context.getLuck();
            let difficulty = context.level.difficulty.id;
            let player = context.player;
            if (!player) return
            let hasTagMode = player?.tags.contains('difficult_level_4');
            let { finalLootPool, chanceMultiplier } = getFinalLootPool(POOLS_fire_factory, luck, difficulty, player);
            if (finalLootPool.length === 0) return;
            let finalChance = Math.min(BASE_CHANCE * chanceMultiplier, 1.0);
            let rolls = getRandomNumber(1, 3);
            for (let i = 0; i < rolls; i++) {
                let randomIndex = Math.floor(Math.random() * finalLootPool.length);
                let selectedItem = finalLootPool[randomIndex];
                let entry = createLootEntry(context, selectedItem, POOLS_fire_factory, luck, difficulty, hasTagMode, finalChance);
                context.addLoot(entry);
            }
        });
});